/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.entities;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Currency;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.Immutable;
import org.restcomm.connect.commons.dao.Sid;

@Immutable
public final class Usage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Category category;
    private final String description;
    private final Sid accountSid;
    private final DateTime startDate;
    private final DateTime endDate;
    private final Long usage;
    private final String usageUnit;
    private final Long count;
    private final String countUnit;
    private final BigDecimal price;
    private final Currency priceUnit;
    private final URI uri;

    public Usage(Category category, String description, Sid accountSid, DateTime startDate, DateTime endDate, Long usage, String usageUnit, Long count, String countUnit, BigDecimal price, Currency priceUnit, URI uri) {
        this.category = category;
        this.description = description;
        this.accountSid = accountSid;
        this.startDate = startDate;
        this.endDate = endDate;
        this.usage = usage;
        this.usageUnit = usageUnit;
        this.count = count;
        this.countUnit = countUnit;
        this.price = price;
        this.priceUnit = priceUnit;
        this.uri = uri;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getEndDate() {
        return this.endDate;
    }

    public Long getUsage() {
        return this.usage;
    }

    public String getUsageUnit() {
        return this.usageUnit;
    }

    public Long getCount() {
        return this.count;
    }

    public String getCountUnit() {
        return this.countUnit;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public Currency getPriceUnit() {
        return this.priceUnit;
    }

    public URI getUri() {
        return this.uri;
    }

    public static enum Category {
        CALLS("calls"),
        CALLS_INBOUND("calls-inbound"),
        CALLS_INBOUND_LOCAL("calls-inbound-local"),
        CALLS_INBOUND_TOLLFREE("calls-inbound-tollfree"),
        CALLS_OUTBOUND("calls-outbound"),
        CALLS_CLIENT("calls-client"),
        CALLS_SIP("calls-sip"),
        SMS("sms"),
        SMS_INBOUND("sms-inbound"),
        SMS_INBOUND_SHORTCODE("sms-inbound-shortcode"),
        SMS_INBOUND_LONGCODE("sms-inbound-longcode"),
        SMS_OUTBOUND("sms-outbound"),
        SMS_OUTBOUND_SHORTCODE("sms-outbound-shortcode"),
        SMS_OUTBOUND_LONGCODE("sms-outbound-longcode"),
        PHONENUMBERS("phonenumbers"),
        PHONENUMBERS_TOLLFREE("phonenumbers-tollfree"),
        PHONENUMBERS_LOCAL("phonenumbers-local"),
        SHORTCODES("shortcodes"),
        SHORTCODES_VANITY("shortcodes-vanity"),
        SHORTCODES_RANDOM("shortcodes-random"),
        SHORTCODES_CUSTOMEROWNED("shortcodes-customerowned"),
        CALLERIDLOOKUPS("calleridlookups"),
        RECORDINGS("recordings"),
        TRANSCRIPTIONS("transcriptions"),
        RECORDINGSTORAGE("recordingstorage"),
        TOTALPRICE("totalprice");

        private final String text;

        private Category(String text) {
            this.text = text;
        }

        public static Category getCategoryValue(String text) {
            Category[] values;
            for (Category value : values = Category.values()) {
                if (!value.toString().equals(text)) continue;
                return value;
            }
            throw new IllegalArgumentException(text + " is not a valid category.");
        }

        public String toString() {
            return this.text;
        }
    }
}

