/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.AccountsDao;
import org.restcomm.connect.dao.DaoUtils;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.exceptions.AccountHierarchyDepthCrossed;

@ThreadSafe
public final class MybatisAccountsDao
implements AccountsDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.AccountsDao.";
    private Integer accountRecursionDepth = 3;
    private final SqlSessionFactory sessions;

    public MybatisAccountsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    public void setAccountRecursionDepth(Integer accountRecursionDepth) {
        this.accountRecursionDepth = accountRecursionDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAccount(Account account) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.addAccount", this.toMap(account));
            session.commit();
        }
    }

    @Override
    public Account getAccount(Sid sid) {
        return this.getAccount("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.getAccount", sid.toString());
    }

    @Override
    public Account getAccount(String name) {
        Account account = null;
        account = this.getAccount("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.getAccountByFriendlyName", name);
        if (account == null) {
            account = this.getAccount("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.getAccountByEmail", name);
        }
        if (account == null) {
            account = this.getAccount("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.getAccount", name);
        }
        return account;
    }

    @Override
    public Account getAccountToAuthenticate(String name) {
        Account account = null;
        account = this.getAccount("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.getAccountByEmail", name);
        if (account == null) {
            account = this.getAccount("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.getAccount", name);
        }
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Account getAccount(String selector, Object parameters) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne(selector, parameters);
            if (result != null) {
                Account account = this.toAccount(result);
                return account;
            }
            Account account = null;
            return account;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Account> getChildAccounts(Sid parentSid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.getChildAccounts", (Object)parentSid.toString());
            ArrayList<Account> accounts = new ArrayList<Account>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    accounts.add(this.toAccount(result));
                }
            }
            ArrayList<Account> arrayList = accounts;
            return arrayList;
        }
    }

    @Override
    public void removeAccount(Sid sid) {
        this.removeAccount("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.removeAccount", sid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAccount(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, (Object)sid.toString());
            session.commit();
        }
    }

    @Override
    public void updateAccount(Account account) {
        this.updateAccount("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.updateAccount", account);
    }

    @Override
    public List<String> getSubAccountSidsRecursive(Sid parentAccountSid) {
        ArrayList<String> parentList = new ArrayList<String>();
        parentList.add(parentAccountSid.toString());
        ArrayList<String> allChildren = new ArrayList<String>();
        List<String> childrenList = this.getSubAccountsSids(parentList);
        for (int depth = 1; childrenList != null && !childrenList.isEmpty() && depth <= this.accountRecursionDepth; ++depth) {
            allChildren.addAll(childrenList);
            childrenList = this.getSubAccountsSids(childrenList);
        }
        return allChildren;
    }

    @Override
    public List<String> getAccountLineage(Sid accountSid) throws AccountHierarchyDepthCrossed {
        Sid parentSid;
        if (accountSid == null) {
            return null;
        }
        ArrayList<String> ancestorList = new ArrayList<String>();
        Sid sid = accountSid;
        Account account = this.getAccount(sid);
        if (account == null) {
            throw new IllegalArgumentException("Wrong accountSid is given to search for ancestor on it. This account does not even exist");
        }
        int depth = 1;
        while ((parentSid = account.getParentSid()) != null) {
            if (++depth > this.accountRecursionDepth) {
                throw new AccountHierarchyDepthCrossed();
            }
            ancestorList.add(parentSid.toString());
            Account parentAccount = this.getAccount(parentSid);
            if (parentAccount == null) {
                throw new IllegalStateException("Parent account " + parentSid.toString() + " does not exist although its child does " + account.getSid().toString());
            }
            account = parentAccount;
        }
        return ancestorList;
    }

    @Override
    public List<String> getAccountLineage(Account account) throws AccountHierarchyDepthCrossed {
        if (account == null) {
            return null;
        }
        ArrayList<String> lineage = new ArrayList<String>();
        Sid parentSid = account.getParentSid();
        if (parentSid != null) {
            lineage.add(parentSid.toString());
            lineage.addAll(this.getAccountLineage(parentSid));
        }
        return lineage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getSubAccountsSids(List<String> parentAccountSidList) {
        try (SqlSession session = this.sessions.openSession();){
            List results;
            List list = results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.getSubAccountSids", parentAccountSidList);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAccount(String selector, Account account) {
        try (SqlSession session = this.sessions.openSession();){
            session.update(selector, this.toMap(account));
            session.commit();
        }
    }

    private Account toAccount(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        String emailAddress = DaoUtils.readString(map.get("email_address"));
        String friendlyName = DaoUtils.readString(map.get("friendly_name"));
        Sid parentSid = DaoUtils.readSid(map.get("parent_sid"));
        Account.Type type = DaoUtils.readAccountType(map.get("type"));
        Account.Status status = DaoUtils.readAccountStatus(map.get("status"));
        String authToken = DaoUtils.readString(map.get("auth_token"));
        String role = DaoUtils.readString(map.get("role"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        return new Account(sid, dateCreated, dateUpdated, emailAddress, friendlyName, parentSid, type, status, authToken, role, uri);
    }

    private Map<String, Object> toMap(Account account) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(account.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(account.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(account.getDateUpdated()));
        map.put("email_address", account.getEmailAddress());
        map.put("friendly_name", account.getFriendlyName());
        map.put("parent_sid", DaoUtils.writeSid(account.getParentSid()));
        map.put("type", DaoUtils.writeAccountType(account.getType()));
        map.put("status", DaoUtils.writeAccountStatus(account.getStatus()));
        map.put("auth_token", account.getAuthToken());
        map.put("role", account.getRole());
        map.put("uri", DaoUtils.writeUri(account.getUri()));
        return map;
    }
}

