/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.AnnouncementsDao;
import org.restcomm.connect.dao.DaoUtils;
import org.restcomm.connect.dao.entities.Announcement;

public final class MybatisAnnouncementsDao
implements AnnouncementsDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.AnnouncementsDao.";
    private final SqlSessionFactory sessions;

    public MybatisAnnouncementsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAnnouncement(Announcement announcement) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.AnnouncementsDao.addAnnouncement", this.toMap(announcement));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Announcement getAnnouncement(Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.AnnouncementsDao.getAnnouncement", (Object)sid.toString());
            if (result != null) {
                Announcement announcement = this.toAnnouncement(result);
                return announcement;
            }
            Announcement announcement = null;
            return announcement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Announcement> getAnnouncements(Sid accountSid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.AnnouncementsDao.getAnnouncements", (Object)accountSid.toString());
            ArrayList<Announcement> announcements = new ArrayList<Announcement>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    announcements.add(this.toAnnouncement(result));
                }
            }
            ArrayList<Announcement> arrayList = announcements;
            return arrayList;
        }
    }

    @Override
    public void removeAnnouncement(Sid sid) {
        this.deleteAnnouncement("org.mobicents.servlet.sip.restcomm.dao.AnnouncementsDao.removeAnnouncement", sid);
    }

    @Override
    public void removeAnnouncements(Sid accountSid) {
        this.deleteAnnouncement("org.mobicents.servlet.sip.restcomm.dao.AnnouncementsDao.removeAnnouncements", accountSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAnnouncement(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, (Object)sid.toString());
            session.commit();
        }
    }

    private Map<String, Object> toMap(Announcement announcement) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(announcement.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(announcement.getDateCreated()));
        map.put("account_sid", DaoUtils.writeSid(announcement.getAccountSid()));
        map.put("gender", announcement.getGender());
        map.put("language", announcement.getLanguage());
        map.put("text", announcement.getText());
        map.put("uri", DaoUtils.writeUri(announcement.getUri()));
        return map;
    }

    private Announcement toAnnouncement(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        Sid accountSid = DaoUtils.readSid(map.get("account_sid"));
        String gender = DaoUtils.readString(map.get("gender"));
        String language = DaoUtils.readString(map.get("language"));
        String text = DaoUtils.readString(map.get("text"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        return new Announcement(sid, dateCreated, accountSid, gender, language, text, uri);
    }
}

