/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.ApplicationsDao;
import org.restcomm.connect.dao.DaoUtils;
import org.restcomm.connect.dao.entities.Application;

@ThreadSafe
public final class MybatisApplicationsDao
implements ApplicationsDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.ApplicationsDao.";
    private final SqlSessionFactory sessions;

    public MybatisApplicationsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplication(Application application) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.ApplicationsDao.addApplication", this.toMap(application));
            session.commit();
        }
    }

    @Override
    public Application getApplication(Sid sid) {
        Application application = this.getApplication("org.mobicents.servlet.sip.restcomm.dao.ApplicationsDao.getApplication", sid.toString());
        return application;
    }

    @Override
    public Application getApplication(String friendlyName) {
        return this.getApplication("org.mobicents.servlet.sip.restcomm.dao.ApplicationsDao.getApplicationByFriendlyName", friendlyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Application getApplication(String selector, String parameter) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne(selector, (Object)parameter);
            if (result != null) {
                Application application = this.toApplication(result);
                return application;
            }
            Application application = null;
            return application;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Application> getApplications(Sid accountSid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.ApplicationsDao.getApplications", (Object)accountSid.toString());
            ArrayList<Application> applications = new ArrayList<Application>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    applications.add(this.toApplication(result));
                }
            }
            ArrayList<Application> arrayList = applications;
            return arrayList;
        }
    }

    @Override
    public void removeApplication(Sid sid) {
        this.removeApplications("removeApplication", sid);
    }

    @Override
    public void removeApplications(Sid accountSid) {
        this.removeApplications("removeApplications", accountSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeApplications(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(namespace + selector, (Object)sid.toString());
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateApplication(Application application) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.ApplicationsDao.updateApplication", this.toMap(application));
            session.commit();
        }
    }

    private Application toApplication(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        String friendlyName = DaoUtils.readString(map.get("friendly_name"));
        Sid accountSid = DaoUtils.readSid(map.get("account_sid"));
        String apiVersion = DaoUtils.readString(map.get("api_version"));
        Boolean hasVoiceCallerIdLookup = DaoUtils.readBoolean(map.get("voice_caller_id_lookup"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        URI rcmlUrl = DaoUtils.readUri(map.get("rcml_url"));
        Application.Kind kind = DaoUtils.readApplicationKind(map.get("kind"));
        return new Application(sid, dateCreated, dateUpdated, friendlyName, accountSid, apiVersion, hasVoiceCallerIdLookup, uri, rcmlUrl, kind);
    }

    private Map<String, Object> toMap(Application application) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(application.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(application.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(application.getDateUpdated()));
        map.put("friendly_name", application.getFriendlyName());
        map.put("account_sid", DaoUtils.writeSid(application.getAccountSid()));
        map.put("api_version", application.getApiVersion());
        map.put("voice_caller_id_lookup", application.hasVoiceCallerIdLookup());
        map.put("uri", DaoUtils.writeUri(application.getUri()));
        map.put("rcml_url", DaoUtils.writeUri(application.getRcmlUrl()));
        map.put("kind", DaoUtils.writeApplicationKind(application.getKind()));
        return map;
    }
}

