/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.dao.AvailablePhoneNumbersDao;
import org.restcomm.connect.dao.DaoUtils;
import org.restcomm.connect.dao.entities.AvailablePhoneNumber;

@ThreadSafe
public final class MybatisAvailablePhoneNumbersDao
implements AvailablePhoneNumbersDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.AvailablePhoneNumbersDao.";
    private static final char[] lookupTable = new char[]{'2', '2', '2', '3', '3', '3', '4', '4', '4', '5', '5', '5', '6', '6', '6', '7', '7', '7', '7', '8', '8', '8', '9', '9', '9', '9'};
    private final SqlSessionFactory sessions;

    public MybatisAvailablePhoneNumbersDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAvailablePhoneNumber(AvailablePhoneNumber availablePhoneNumber) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.AvailablePhoneNumbersDao.addAvailablePhoneNumber", this.toMap(availablePhoneNumber));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AvailablePhoneNumber> getAvailablePhoneNumbers(String selector, Object parameter) {
        try (SqlSession session = this.sessions.openSession();){
            List results = null;
            results = parameter == null ? session.selectList(selector) : session.selectList(selector, parameter);
            ArrayList<AvailablePhoneNumber> availablePhoneNumbers = new ArrayList<AvailablePhoneNumber>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    availablePhoneNumbers.add(this.toAvailablePhoneNumber(result));
                }
            }
            ArrayList<AvailablePhoneNumber> arrayList = availablePhoneNumbers;
            return arrayList;
        }
    }

    @Override
    public List<AvailablePhoneNumber> getAvailablePhoneNumbers() {
        return this.getAvailablePhoneNumbers("org.mobicents.servlet.sip.restcomm.dao.AvailablePhoneNumbersDao.getAvailablePhoneNumbers", null);
    }

    @Override
    public List<AvailablePhoneNumber> getAvailablePhoneNumbersByAreaCode(String areaCode) {
        String phoneNumber = "+1" + areaCode + "_______";
        return this.getAvailablePhoneNumbers("org.mobicents.servlet.sip.restcomm.dao.AvailablePhoneNumbersDao.getAvailablePhoneNumbersByAreaCode", phoneNumber);
    }

    @Override
    public List<AvailablePhoneNumber> getAvailablePhoneNumbersByPattern(String pattern) throws IllegalArgumentException {
        return this.getAvailablePhoneNumbers("org.mobicents.servlet.sip.restcomm.dao.AvailablePhoneNumbersDao.getAvailablePhoneNumbersByPattern", this.normalizePattern(pattern));
    }

    @Override
    public List<AvailablePhoneNumber> getAvailablePhoneNumbersByRegion(String region) {
        return this.getAvailablePhoneNumbers("org.mobicents.servlet.sip.restcomm.dao.AvailablePhoneNumbersDao.getAvailablePhoneNumbersByRegion", region);
    }

    @Override
    public List<AvailablePhoneNumber> getAvailablePhoneNumbersByPostalCode(int postalCode) {
        return this.getAvailablePhoneNumbers("org.mobicents.servlet.sip.restcomm.dao.AvailablePhoneNumbersDao.getAvailablePhoneNumbersByPostalCode", postalCode);
    }

    private String normalizePattern(String input) throws IllegalArgumentException {
        char[] tokens = input.toUpperCase().toCharArray();
        char[] result = new char[tokens.length];
        for (int index = 0; index < tokens.length; ++index) {
            char token = tokens[index];
            if (token == '+' || Character.isDigit(token)) {
                result[index] = token;
                continue;
            }
            if (token == '*') {
                result[index] = 95;
                continue;
            }
            if (Character.isLetter(token)) {
                int delta = 65;
                int position = Character.getNumericValue(token) - 65;
                result[index] = lookupTable[position];
                continue;
            }
            throw new IllegalArgumentException(token + " is not a valid character.");
        }
        return new String(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAvailablePhoneNumber(String phoneNumber) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete("org.mobicents.servlet.sip.restcomm.dao.AvailablePhoneNumbersDao.removeAvailablePhoneNumber", (Object)phoneNumber);
            session.commit();
        }
    }

    private AvailablePhoneNumber toAvailablePhoneNumber(Map<String, Object> map) {
        String friendlyName = DaoUtils.readString(map.get("friendly_name"));
        String phoneNumber = DaoUtils.readString(map.get("phone_number"));
        Integer lata = DaoUtils.readInteger(map.get("lata"));
        String rateCenter = DaoUtils.readString(map.get("rate_center"));
        Double latitude = DaoUtils.readDouble(map.get("latitude"));
        Double longitude = DaoUtils.readDouble(map.get("longitude"));
        String region = DaoUtils.readString(map.get("region"));
        Integer postalCode = DaoUtils.readInteger(map.get("postal_code"));
        String isoCountry = DaoUtils.readString(map.get("iso_country"));
        Boolean voiceCapable = DaoUtils.readBoolean(map.get("voice_capable"));
        Boolean smsCapable = DaoUtils.readBoolean(map.get("sms_capable"));
        Boolean mmsCapable = DaoUtils.readBoolean(map.get("mms_capable"));
        Boolean faxCapable = DaoUtils.readBoolean(map.get("fax_capable"));
        String cost = DaoUtils.readString(map.get("cost"));
        return new AvailablePhoneNumber(friendlyName, phoneNumber, lata, rateCenter, latitude, longitude, region, postalCode, isoCountry, cost, voiceCapable, smsCapable, mmsCapable, faxCapable);
    }

    private Map<String, Object> toMap(AvailablePhoneNumber availablePhoneNumber) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("friendly_name", availablePhoneNumber.getFriendlyName());
        map.put("phone_number", availablePhoneNumber.getPhoneNumber());
        map.put("lata", availablePhoneNumber.getLata());
        map.put("rate_center", availablePhoneNumber.getRateCenter());
        map.put("latitude", availablePhoneNumber.getLatitude());
        map.put("longitude", availablePhoneNumber.getLongitude());
        map.put("region", availablePhoneNumber.getRegion());
        map.put("postal_code", availablePhoneNumber.getPostalCode());
        map.put("iso_country", availablePhoneNumber.getIsoCountry());
        map.put("voice_capable", availablePhoneNumber.isVoiceCapable());
        map.put("sms_capable", availablePhoneNumber.isSmsCapable());
        map.put("mms_capable", availablePhoneNumber.isMmsCapable());
        map.put("fax_capable", availablePhoneNumber.isFaxCapable());
        map.put("cost", availablePhoneNumber.getCost());
        return map;
    }
}

