/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import java.math.BigDecimal;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.CallDetailRecordsDao;
import org.restcomm.connect.dao.DaoUtils;
import org.restcomm.connect.dao.entities.CallDetailRecord;
import org.restcomm.connect.dao.entities.CallDetailRecordFilter;

@ThreadSafe
public final class MybatisCallDetailRecordsDao
implements CallDetailRecordsDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.";
    private final SqlSessionFactory sessions;

    public MybatisCallDetailRecordsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallDetailRecord(CallDetailRecord cdr) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.addCallDetailRecord", this.toMap(cdr));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallDetailRecord getCallDetailRecord(Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getCallDetailRecord", (Object)sid.toString());
            if (result != null) {
                CallDetailRecord callDetailRecord = this.toCallDetailRecord(result);
                return callDetailRecord;
            }
            CallDetailRecord callDetailRecord = null;
            return callDetailRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getTotalCallDetailRecords(CallDetailRecordFilter filter) {
        try (SqlSession session = this.sessions.openSession();){
            Integer total;
            Integer n = total = (Integer)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getTotalCallDetailRecordByUsingFilters", (Object)filter);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getInProgressCallsByClientName(String client) {
        try (SqlSession session = this.sessions.openSession();){
            Integer total;
            Integer n = total = (Integer)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getInProgressCallsByClientName", (Object)client);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getInProgressCallsByAccountSid(String accountSid) {
        try (SqlSession session = this.sessions.openSession();){
            Integer total;
            Integer n = total = (Integer)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getInProgressCallsByAccountSid", (Object)accountSid);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getTotalRunningCallDetailRecordsByConferenceSid(Sid conferenceSid) {
        try (SqlSession session = this.sessions.openSession();){
            Integer total;
            Integer n = total = (Integer)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getTotalRunningCallDetailRecordsByConferenceSid", (Object)conferenceSid.toString());
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CallDetailRecord> getCallDetailRecords(CallDetailRecordFilter filter) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getCallDetailRecordByUsingFilters", (Object)filter);
            ArrayList<CallDetailRecord> cdrs = new ArrayList<CallDetailRecord>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    cdrs.add(this.toCallDetailRecord(result));
                }
            }
            ArrayList<CallDetailRecord> arrayList = cdrs;
            return arrayList;
        }
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByAccountSid(Sid accountSid) {
        return this.getCallDetailRecords("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getCallDetailRecords", accountSid.toString());
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByRecipient(String recipient) {
        return this.getCallDetailRecords("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getCallDetailRecordsByRecipient", recipient);
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsBySender(String sender) {
        return this.getCallDetailRecords("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getCallDetailRecordsBySender", sender);
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByStatus(String status) {
        return this.getCallDetailRecords("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getCallDetailRecordsByStatus", status);
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByStartTime(DateTime startTime) {
        return this.getCallDetailRecords("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getCallDetailRecordsByStartTime", startTime.toDate());
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByEndTime(DateTime endTime) {
        return this.getCallDetailRecords("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getCallDetailRecordsByEndTime", endTime.toDate());
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByStarTimeAndEndTime(DateTime endTime) {
        return this.getCallDetailRecords("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getCallDetailRecordsByStarTimeAndEndTime", endTime.toDate());
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByParentCall(Sid parentCallSid) {
        return this.getCallDetailRecords("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getCallDetailRecordsByParentCall", parentCallSid.toString());
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByConferenceSid(Sid conferenceSid) {
        return this.getCallDetailRecords("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getCallDetailRecordsByConferenceSid", conferenceSid.toString());
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByInstanceId(Sid instanceId) {
        return this.getCallDetailRecords("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getCallDetailRecordsByInstanceId", instanceId.toString());
    }

    @Override
    public List<CallDetailRecord> getInCompleteCallDetailRecordsByInstanceId(Sid instanceId) {
        return this.getCallDetailRecords("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getInCompleteCallDetailRecordsByInstanceId", instanceId.toString());
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByMsId(String msId) {
        return this.getCallDetailRecords("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getCallDetailRecordsByMsId", msId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double getAverageCallDurationLast24Hours(Sid instanceId) throws ParseException {
        DateTime now = DateTime.now();
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date today = formatter.parse(now.toString(fmt));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("instanceid", instanceId.toString());
        params.put("startTime", today);
        try (SqlSession session = this.sessions.openSession();){
            Double total;
            Double d = total = (Double)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getAverageCallDurationLast24Hours", params);
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double getAverageCallDurationLastHour(Sid instanceId) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:00:00");
        String hour = formatter.format(Calendar.getInstance().getTime());
        Date lastHour = formatter.parse(hour);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("instanceid", instanceId.toString());
        params.put("startTime", lastHour);
        try (SqlSession session = this.sessions.openSession();){
            Double total;
            Double d = total = (Double)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.getAverageCallDurationLastHour", params);
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CallDetailRecord> getCallDetailRecords(String selector, Object input) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList(selector, input);
            ArrayList<CallDetailRecord> cdrs = new ArrayList<CallDetailRecord>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    cdrs.add(this.toCallDetailRecord(result));
                }
            }
            ArrayList<CallDetailRecord> arrayList = cdrs;
            return arrayList;
        }
    }

    @Override
    public void removeCallDetailRecord(Sid sid) {
        this.removeCallDetailRecords("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.removeCallDetailRecord", sid);
    }

    @Override
    public void removeCallDetailRecords(Sid accountSid) {
        this.removeCallDetailRecords("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.removeCallDetailRecords", accountSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCallDetailRecords(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, (Object)sid.toString());
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCallDetailRecord(CallDetailRecord cdr) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.updateCallDetailRecord", this.toMap(cdr));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInCompleteCallDetailRecordsToCompletedByInstanceId(Sid instanceId) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.CallDetailRecordsDao.updateInCompleteCallDetailRecordsToCompletedByInstanceId", (Object)instanceId.toString());
            session.commit();
        }
    }

    private CallDetailRecord toCallDetailRecord(Map<String, Object> map) {
        String msId = DaoUtils.readString(map.get("ms_id"));
        Sid sid = DaoUtils.readSid(map.get("sid"));
        String instanceId = DaoUtils.readString(map.get("instanceid"));
        Sid parentCallSid = DaoUtils.readSid(map.get("parent_call_sid"));
        Sid conferenceSid = DaoUtils.readSid(map.get("conference_sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        Sid accountSid = DaoUtils.readSid(map.get("account_sid"));
        String to = DaoUtils.readString(map.get("recipient"));
        String from = DaoUtils.readString(map.get("sender"));
        Sid phoneNumberSid = DaoUtils.readSid(map.get("phone_number_sid"));
        String status = DaoUtils.readString(map.get("status"));
        DateTime startTime = DaoUtils.readDateTime(map.get("start_time"));
        DateTime endTime = DaoUtils.readDateTime(map.get("end_time"));
        Integer duration = DaoUtils.readInteger(map.get("duration"));
        Integer ringDuration = DaoUtils.readInteger(map.get("ring_duration"));
        BigDecimal price = DaoUtils.readBigDecimal(map.get("price"));
        Currency priceUnit = DaoUtils.readCurrency(map.get("price_unit"));
        String direction = DaoUtils.readString(map.get("direction"));
        String answeredBy = DaoUtils.readString(map.get("answered_by"));
        String apiVersion = DaoUtils.readString(map.get("api_version"));
        String forwardedFrom = DaoUtils.readString(map.get("forwarded_from"));
        String callerName = DaoUtils.readString(map.get("caller_name"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        String callPath = DaoUtils.readString(map.get("call_path"));
        Boolean muted = DaoUtils.readBoolean(map.get("muted"));
        Boolean startConferenceOnEnter = DaoUtils.readBoolean(map.get("start_conference_on_enter"));
        Boolean endConferenceOnExit = DaoUtils.readBoolean(map.get("end_conference_on_exit"));
        Boolean onHold = DaoUtils.readBoolean(map.get("on_hold"));
        return new CallDetailRecord(sid, instanceId, parentCallSid, conferenceSid, dateCreated, dateUpdated, accountSid, to, from, phoneNumberSid, status, startTime, endTime, duration, price, priceUnit, direction, answeredBy, apiVersion, forwardedFrom, callerName, uri, callPath, ringDuration, muted, startConferenceOnEnter, endConferenceOnExit, onHold, msId);
    }

    private Map<String, Object> toMap(CallDetailRecord cdr) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(cdr.getSid()));
        map.put("instanceid", cdr.getInstanceId());
        map.put("parent_call_sid", DaoUtils.writeSid(cdr.getParentCallSid()));
        map.put("conference_sid", DaoUtils.writeSid(cdr.getConferenceSid()));
        map.put("date_created", DaoUtils.writeDateTime(cdr.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(cdr.getDateUpdated()));
        map.put("account_sid", DaoUtils.writeSid(cdr.getAccountSid()));
        map.put("to", cdr.getTo());
        map.put("from", cdr.getFrom());
        map.put("phone_number_sid", DaoUtils.writeSid(cdr.getPhoneNumberSid()));
        map.put("status", cdr.getStatus());
        map.put("start_time", DaoUtils.writeDateTime(cdr.getStartTime()));
        map.put("end_time", DaoUtils.writeDateTime(cdr.getEndTime()));
        map.put("duration", cdr.getDuration());
        map.put("ring_duration", cdr.getRingDuration());
        map.put("price", DaoUtils.writeBigDecimal(cdr.getPrice()));
        map.put("direction", cdr.getDirection());
        map.put("answered_by", cdr.getAnsweredBy());
        map.put("api_version", cdr.getApiVersion());
        map.put("forwarded_from", cdr.getForwardedFrom());
        map.put("caller_name", cdr.getCallerName());
        map.put("uri", DaoUtils.writeUri(cdr.getUri()));
        map.put("call_path", cdr.getCallPath());
        map.put("muted", cdr.isMuted());
        map.put("start_conference_on_enter", cdr.isStartConferenceOnEnter());
        map.put("end_conference_on_exit", cdr.isEndConferenceOnExit());
        map.put("on_hold", cdr.isOnHold());
        map.put("ms_id", cdr.getMsId());
        return map;
    }
}

