/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.ConferenceDetailRecordsDao;
import org.restcomm.connect.dao.DaoUtils;
import org.restcomm.connect.dao.entities.ConferenceDetailRecord;
import org.restcomm.connect.dao.entities.ConferenceDetailRecordFilter;

@ThreadSafe
public final class MybatisConferenceDetailRecordsDao
implements ConferenceDetailRecordsDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.ConferenceDetailRecordsDao.";
    private final SqlSessionFactory sessions;

    public MybatisConferenceDetailRecordsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addConferenceDetailRecord(ConferenceDetailRecord cdr) {
        int effectedRows = 0;
        try (SqlSession session = this.sessions.openSession();){
            effectedRows = session.insert("org.mobicents.servlet.sip.restcomm.dao.ConferenceDetailRecordsDao.addConferenceDetailRecord", this.toMap(cdr));
            session.commit();
        }
        return effectedRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConferenceDetailRecord getConferenceDetailRecord(Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.ConferenceDetailRecordsDao.getConferenceDetailRecord", (Object)sid.toString());
            if (result != null) {
                ConferenceDetailRecord conferenceDetailRecord = this.toConferenceDetailRecord(result);
                return conferenceDetailRecord;
            }
            ConferenceDetailRecord conferenceDetailRecord = null;
            return conferenceDetailRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getTotalConferenceDetailRecords(ConferenceDetailRecordFilter filter) {
        try (SqlSession session = this.sessions.openSession();){
            Integer total;
            Integer n = total = (Integer)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.ConferenceDetailRecordsDao.getTotalConferenceDetailRecordByUsingFilters", (Object)filter);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConferenceDetailRecord> getConferenceDetailRecords(ConferenceDetailRecordFilter filter) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.ConferenceDetailRecordsDao.getConferenceDetailRecordByUsingFilters", (Object)filter);
            ArrayList<ConferenceDetailRecord> cdrs = new ArrayList<ConferenceDetailRecord>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    cdrs.add(this.toConferenceDetailRecord(result));
                }
            }
            ArrayList<ConferenceDetailRecord> arrayList = cdrs;
            return arrayList;
        }
    }

    @Override
    public List<ConferenceDetailRecord> getConferenceDetailRecords(Sid accountSid) {
        return this.getConferenceDetailRecords("org.mobicents.servlet.sip.restcomm.dao.ConferenceDetailRecordsDao.getConferenceDetailRecords", accountSid.toString());
    }

    @Override
    public List<ConferenceDetailRecord> getConferenceDetailRecordsByStatus(String status) {
        return this.getConferenceDetailRecords("org.mobicents.servlet.sip.restcomm.dao.ConferenceDetailRecordsDao.getConferenceDetailRecordsByStatus", status);
    }

    @Override
    public List<ConferenceDetailRecord> getConferenceDetailRecordsByDateCreated(DateTime dateCreated) {
        return this.getConferenceDetailRecords("org.mobicents.servlet.sip.restcomm.dao.ConferenceDetailRecordsDao.getConferenceDetailRecordsByDateCreated", dateCreated.toDate());
    }

    @Override
    public List<ConferenceDetailRecord> getConferenceDetailRecordsByDateUpdated(DateTime dateUpdated) {
        return this.getConferenceDetailRecords("org.mobicents.servlet.sip.restcomm.dao.ConferenceDetailRecordsDao.getConferenceDetailRecordsByDateUpdated", dateUpdated.toDate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConferenceDetailRecordStatus(ConferenceDetailRecord cdr) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.ConferenceDetailRecordsDao.updateConferenceDetailRecordStatus", this.toMap(cdr));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConferenceDetailRecordMasterEndpointID(ConferenceDetailRecord cdr) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.ConferenceDetailRecordsDao.updateConferenceDetailRecordMasterEndpointID", this.toMap(cdr));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConferenceDetailRecordMasterBridgeEndpointID(ConferenceDetailRecord cdr) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.ConferenceDetailRecordsDao.updateConferenceDetailRecordMasterBridgeEndpointID", this.toMap(cdr));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMasterPresent(ConferenceDetailRecord cdr) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.ConferenceDetailRecordsDao.updateMasterPresent", this.toMap(cdr));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateModeratorPresent(ConferenceDetailRecord cdr) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.ConferenceDetailRecordsDao.updateModeratorPresent", this.toMap(cdr));
            session.commit();
        }
    }

    @Override
    public void removeConferenceDetailRecord(Sid sid) {
    }

    @Override
    public void removeConferenceDetailRecords(Sid accountSid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConferenceDetailRecord> getConferenceDetailRecords(String selector, Object input) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList(selector, input);
            ArrayList<ConferenceDetailRecord> cdrs = new ArrayList<ConferenceDetailRecord>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    cdrs.add(this.toConferenceDetailRecord(result));
                }
            }
            ArrayList<ConferenceDetailRecord> arrayList = cdrs;
            return arrayList;
        }
    }

    private ConferenceDetailRecord toConferenceDetailRecord(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        Sid accountSid = DaoUtils.readSid(map.get("account_sid"));
        String status = DaoUtils.readString(map.get("status"));
        String friendlyName = DaoUtils.readString(map.get("friendly_name"));
        String apiVersion = DaoUtils.readString(map.get("api_version"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        String msId = DaoUtils.readString(map.get("master_ms_id"));
        String masterConferenceEndpointId = DaoUtils.readString(map.get("master_conference_endpoint_id"));
        String masterIVREndpointId = DaoUtils.readString(map.get("master_ivr_endpoint_id"));
        boolean masterPresent = false;
        String masterIVREndpointSessionId = null;
        String masterBridgeEndpointId = null;
        String masterBridgeEndpointSessionId = null;
        String masterBridgeConnectionIdentifier = null;
        String masterIVRConnectionIdentifier = null;
        boolean moderatorPresent = false;
        try {
            masterPresent = DaoUtils.readBoolean(map.get("master_present"));
            masterIVREndpointSessionId = DaoUtils.readString(map.get("master_ivr_endpoint_session_id"));
            masterBridgeEndpointId = DaoUtils.readString(map.get("master_bridge_endpoint_id"));
            masterBridgeEndpointSessionId = DaoUtils.readString(map.get("master_bridge_endpoint_session_id"));
            masterBridgeConnectionIdentifier = DaoUtils.readString(map.get("master_bridge_conn_id"));
            masterIVRConnectionIdentifier = DaoUtils.readString(map.get("master_ivr_conn_id"));
            moderatorPresent = DaoUtils.readBoolean(map.get("moderator_present"));
        }
        catch (Exception e) {
            // empty catch block
        }
        return new ConferenceDetailRecord(sid, dateCreated, dateUpdated, accountSid, status, friendlyName, apiVersion, uri, msId, masterConferenceEndpointId, masterPresent, masterIVREndpointId, masterIVREndpointSessionId, masterBridgeEndpointId, masterBridgeEndpointSessionId, masterBridgeConnectionIdentifier, masterIVRConnectionIdentifier, moderatorPresent);
    }

    private Map<String, Object> toMap(ConferenceDetailRecord cdr) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(cdr.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(cdr.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(cdr.getDateUpdated()));
        map.put("account_sid", DaoUtils.writeSid(cdr.getAccountSid()));
        map.put("status", cdr.getStatus());
        map.put("friendly_name", cdr.getFriendlyName());
        map.put("api_version", cdr.getApiVersion());
        map.put("uri", DaoUtils.writeUri(cdr.getUri()));
        map.put("master_ms_id", cdr.getMasterMsId());
        map.put("master_conference_endpoint_id", cdr.getMasterConferenceEndpointId());
        map.put("master_ivr_endpoint_id", cdr.getMasterIVREndpointId());
        map.put("master_ivr_endpoint_session_id", cdr.getMasterIVREndpointSessionId());
        map.put("master_bridge_endpoint_id", cdr.getMasterBridgeEndpointId());
        map.put("master_bridge_endpoint_session_id", cdr.getMasterBridgeEndpointSessionId());
        map.put("master_present", cdr.isMasterPresent());
        map.put("master_bridge_conn_id", cdr.getMasterBridgeConnectionIdentifier());
        map.put("master_ivr_conn_id", cdr.getMasterIVRConnectionIdentifier());
        map.put("moderator_present", cdr.isModeratorPresent());
        return map;
    }
}

