/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.restcomm.connect.commons.amazonS3.S3AccessTool;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.dao.AccountsDao;
import org.restcomm.connect.dao.AnnouncementsDao;
import org.restcomm.connect.dao.ApplicationsDao;
import org.restcomm.connect.dao.AvailablePhoneNumbersDao;
import org.restcomm.connect.dao.CallDetailRecordsDao;
import org.restcomm.connect.dao.ClientsDao;
import org.restcomm.connect.dao.ConferenceDetailRecordsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.ExtensionsConfigurationDao;
import org.restcomm.connect.dao.GatewaysDao;
import org.restcomm.connect.dao.GeolocationDao;
import org.restcomm.connect.dao.HttpCookiesDao;
import org.restcomm.connect.dao.IncomingPhoneNumbersDao;
import org.restcomm.connect.dao.InstanceIdDao;
import org.restcomm.connect.dao.MediaResourceBrokerDao;
import org.restcomm.connect.dao.MediaServersDao;
import org.restcomm.connect.dao.NotificationsDao;
import org.restcomm.connect.dao.OutgoingCallerIdsDao;
import org.restcomm.connect.dao.RecordingsDao;
import org.restcomm.connect.dao.RegistrationsDao;
import org.restcomm.connect.dao.ShortCodesDao;
import org.restcomm.connect.dao.SmsMessagesDao;
import org.restcomm.connect.dao.TranscriptionsDao;
import org.restcomm.connect.dao.UsageDao;
import org.restcomm.connect.dao.mybatis.MybatisAccountsDao;
import org.restcomm.connect.dao.mybatis.MybatisAnnouncementsDao;
import org.restcomm.connect.dao.mybatis.MybatisApplicationsDao;
import org.restcomm.connect.dao.mybatis.MybatisAvailablePhoneNumbersDao;
import org.restcomm.connect.dao.mybatis.MybatisCallDetailRecordsDao;
import org.restcomm.connect.dao.mybatis.MybatisClientsDao;
import org.restcomm.connect.dao.mybatis.MybatisConferenceDetailRecordsDao;
import org.restcomm.connect.dao.mybatis.MybatisExtensionsConfigurationDao;
import org.restcomm.connect.dao.mybatis.MybatisGatewaysDao;
import org.restcomm.connect.dao.mybatis.MybatisGeolocationDao;
import org.restcomm.connect.dao.mybatis.MybatisHttpCookiesDao;
import org.restcomm.connect.dao.mybatis.MybatisIncomingPhoneNumbersDao;
import org.restcomm.connect.dao.mybatis.MybatisInstanceIdDao;
import org.restcomm.connect.dao.mybatis.MybatisMediaResourceBrokerDao;
import org.restcomm.connect.dao.mybatis.MybatisMediaServerDao;
import org.restcomm.connect.dao.mybatis.MybatisNotificationsDao;
import org.restcomm.connect.dao.mybatis.MybatisOutgoingCallerIdsDao;
import org.restcomm.connect.dao.mybatis.MybatisRecordingsDao;
import org.restcomm.connect.dao.mybatis.MybatisRegistrationsDao;
import org.restcomm.connect.dao.mybatis.MybatisShortCodesDao;
import org.restcomm.connect.dao.mybatis.MybatisSmsMessagesDao;
import org.restcomm.connect.dao.mybatis.MybatisTranscriptionsDao;
import org.restcomm.connect.dao.mybatis.MybatisUsageDao;

@ThreadSafe
public final class MybatisDaoManager
implements DaoManager {
    private Configuration configuration;
    private Configuration amazonS3Configuration;
    private Configuration runtimeConfiguration;
    private S3AccessTool s3AccessTool;
    private AccountsDao accountsDao;
    private ApplicationsDao applicationsDao;
    private AvailablePhoneNumbersDao availablePhoneNumbersDao;
    private CallDetailRecordsDao callDetailRecordsDao;
    private ConferenceDetailRecordsDao conferenceDetailRecordsDao;
    private ClientsDao clientsDao;
    private HttpCookiesDao httpCookiesDao;
    private IncomingPhoneNumbersDao incomingPhoneNumbersDao;
    private NotificationsDao notificationsDao;
    private OutgoingCallerIdsDao outgoingCallerIdsDao;
    private RegistrationsDao presenceRecordsDao;
    private RecordingsDao recordingsDao;
    private ShortCodesDao shortCodesDao;
    private SmsMessagesDao smsMessagesDao;
    private UsageDao usageDao;
    private TranscriptionsDao transcriptionsDao;
    private GatewaysDao gatewaysDao;
    private AnnouncementsDao announcementsDao;
    private InstanceIdDao instanceIdDao;
    private MediaServersDao mediaServersDao;
    private MediaResourceBrokerDao mediaResourceBrokerDao;
    private ExtensionsConfigurationDao extensionsConfigurationDao;
    private GeolocationDao geolocationDao;

    public void configure(Configuration configuration, Configuration daoManagerConfiguration) {
        this.configuration = daoManagerConfiguration.subset("dao-manager");
        this.amazonS3Configuration = configuration.subset("amazon-s3");
        this.runtimeConfiguration = configuration.subset("runtime-settings");
    }

    @Override
    public AccountsDao getAccountsDao() {
        return this.accountsDao;
    }

    @Override
    public ApplicationsDao getApplicationsDao() {
        return this.applicationsDao;
    }

    @Override
    public AnnouncementsDao getAnnouncementsDao() {
        return this.announcementsDao;
    }

    @Override
    public AvailablePhoneNumbersDao getAvailablePhoneNumbersDao() {
        return this.availablePhoneNumbersDao;
    }

    @Override
    public CallDetailRecordsDao getCallDetailRecordsDao() {
        return this.callDetailRecordsDao;
    }

    @Override
    public ConferenceDetailRecordsDao getConferenceDetailRecordsDao() {
        return this.conferenceDetailRecordsDao;
    }

    @Override
    public ClientsDao getClientsDao() {
        return this.clientsDao;
    }

    @Override
    public HttpCookiesDao getHttpCookiesDao() {
        return this.httpCookiesDao;
    }

    @Override
    public IncomingPhoneNumbersDao getIncomingPhoneNumbersDao() {
        return this.incomingPhoneNumbersDao;
    }

    @Override
    public NotificationsDao getNotificationsDao() {
        return this.notificationsDao;
    }

    @Override
    public RegistrationsDao getRegistrationsDao() {
        return this.presenceRecordsDao;
    }

    @Override
    public OutgoingCallerIdsDao getOutgoingCallerIdsDao() {
        return this.outgoingCallerIdsDao;
    }

    @Override
    public RecordingsDao getRecordingsDao() {
        return this.recordingsDao;
    }

    @Override
    public ShortCodesDao getShortCodesDao() {
        return this.shortCodesDao;
    }

    @Override
    public SmsMessagesDao getSmsMessagesDao() {
        return this.smsMessagesDao;
    }

    @Override
    public UsageDao getUsageDao() {
        return this.usageDao;
    }

    @Override
    public TranscriptionsDao getTranscriptionsDao() {
        return this.transcriptionsDao;
    }

    @Override
    public GatewaysDao getGatewaysDao() {
        return this.gatewaysDao;
    }

    @Override
    public InstanceIdDao getInstanceIdDao() {
        return this.instanceIdDao;
    }

    @Override
    public MediaServersDao getMediaServersDao() {
        return this.mediaServersDao;
    }

    @Override
    public MediaResourceBrokerDao getMediaResourceBrokerDao() {
        return this.mediaResourceBrokerDao;
    }

    @Override
    public ExtensionsConfigurationDao getExtensionsConfigurationDao() {
        return this.extensionsConfigurationDao;
    }

    @Override
    public GeolocationDao getGeolocationDao() {
        return this.geolocationDao;
    }

    public void shutdown() {
    }

    public void start() throws RuntimeException {
        boolean amazonS3Enabled;
        LogFactory.useSlf4jLogging();
        SqlSessionFactoryBuilder builder = new SqlSessionFactoryBuilder();
        String path = this.configuration.getString("configuration-file");
        FileReader reader = null;
        try {
            reader = new FileReader(path);
        }
        catch (FileNotFoundException exception) {
            throw new RuntimeException(exception);
        }
        Properties properties = new Properties();
        String dataFiles = this.configuration.getString("data-files");
        String sqlFiles = this.configuration.getString("sql-files");
        properties.setProperty("data", dataFiles);
        properties.setProperty("sql", sqlFiles);
        SqlSessionFactory sessions = builder.build((Reader)reader, properties);
        if (!this.amazonS3Configuration.isEmpty() && (amazonS3Enabled = this.amazonS3Configuration.getBoolean("enabled"))) {
            String accessKey = this.amazonS3Configuration.getString("access-key");
            String securityKey = this.amazonS3Configuration.getString("security-key");
            String bucketName = this.amazonS3Configuration.getString("bucket-name");
            String folder = this.amazonS3Configuration.getString("folder");
            boolean reducedRedundancy = this.amazonS3Configuration.getBoolean("reduced-redundancy");
            int minutesToRetainPublicUrl = this.amazonS3Configuration.getInt("minutes-to-retain-public-url", 10);
            boolean removeOriginalFile = this.amazonS3Configuration.getBoolean("remove-original-file");
            String bucketRegion = this.amazonS3Configuration.getString("bucket-region");
            boolean testing = this.amazonS3Configuration.getBoolean("testing", false);
            String testingUrl = this.amazonS3Configuration.getString("testing-url", null);
            this.s3AccessTool = new S3AccessTool(accessKey, securityKey, bucketName, folder, reducedRedundancy, minutesToRetainPublicUrl, removeOriginalFile, bucketRegion, testing, testingUrl);
        }
        this.start(sessions);
    }

    public void start(SqlSessionFactory sessions) {
        this.accountsDao = new MybatisAccountsDao(sessions);
        this.applicationsDao = new MybatisApplicationsDao(sessions);
        this.announcementsDao = new MybatisAnnouncementsDao(sessions);
        this.availablePhoneNumbersDao = new MybatisAvailablePhoneNumbersDao(sessions);
        this.callDetailRecordsDao = new MybatisCallDetailRecordsDao(sessions);
        this.conferenceDetailRecordsDao = new MybatisConferenceDetailRecordsDao(sessions);
        this.clientsDao = new MybatisClientsDao(sessions);
        this.httpCookiesDao = new MybatisHttpCookiesDao(sessions);
        this.incomingPhoneNumbersDao = new MybatisIncomingPhoneNumbersDao(sessions);
        this.notificationsDao = new MybatisNotificationsDao(sessions);
        this.outgoingCallerIdsDao = new MybatisOutgoingCallerIdsDao(sessions);
        this.presenceRecordsDao = new MybatisRegistrationsDao(sessions);
        if (this.s3AccessTool != null) {
            String recordingPath = this.runtimeConfiguration.getString("recordings-path");
            this.recordingsDao = new MybatisRecordingsDao(sessions, this.s3AccessTool, recordingPath);
        } else {
            this.recordingsDao = new MybatisRecordingsDao(sessions);
        }
        this.shortCodesDao = new MybatisShortCodesDao(sessions);
        this.smsMessagesDao = new MybatisSmsMessagesDao(sessions);
        this.usageDao = new MybatisUsageDao(sessions);
        this.transcriptionsDao = new MybatisTranscriptionsDao(sessions);
        this.gatewaysDao = new MybatisGatewaysDao(sessions);
        this.instanceIdDao = new MybatisInstanceIdDao(sessions);
        this.mediaServersDao = new MybatisMediaServerDao(sessions);
        this.mediaResourceBrokerDao = new MybatisMediaResourceBrokerDao(sessions);
        this.extensionsConfigurationDao = new MybatisExtensionsConfigurationDao(sessions);
        this.geolocationDao = new MybatisGeolocationDao(sessions);
    }
}

