/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoUtils;
import org.restcomm.connect.dao.ExtensionsConfigurationDao;
import org.restcomm.connect.extension.api.ConfigurationException;
import org.restcomm.connect.extension.api.ExtensionConfiguration;

public class MybatisExtensionsConfigurationDao
implements ExtensionsConfigurationDao {
    private static Logger logger = Logger.getLogger(MybatisExtensionsConfigurationDao.class);
    private static final String namespace = "org.restcomm.connect.dao.ExtensionsConfigurationDao.";
    private final SqlSessionFactory sessions;

    public MybatisExtensionsConfigurationDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfiguration(ExtensionConfiguration extensionConfiguration) throws ConfigurationException {
        block4: {
            try (SqlSession session = this.sessions.openSession();){
                if (extensionConfiguration == null || extensionConfiguration.getConfigurationData() == null) break block4;
                if (this.validate(extensionConfiguration)) {
                    session.insert("org.restcomm.connect.dao.ExtensionsConfigurationDao.addConfiguration", this.toMap(extensionConfiguration));
                    session.commit();
                    break block4;
                }
                throw new ConfigurationException("Exception trying to add new configuration, validation failed. configuration type: " + extensionConfiguration.getConfigurationType());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfiguration(ExtensionConfiguration extensionConfiguration) throws ConfigurationException {
        try (SqlSession session = this.sessions.openSession();){
            if (extensionConfiguration != null && extensionConfiguration.getConfigurationData() != null) {
                if (this.validate(extensionConfiguration)) {
                    session.update("org.restcomm.connect.dao.ExtensionsConfigurationDao.updateConfiguration", this.toMap(extensionConfiguration));
                } else {
                    throw new ConfigurationException("Exception trying to update configuration, validation failed. configuration type: " + extensionConfiguration.getConfigurationType());
                }
            }
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtensionConfiguration getConfigurationByName(String extensionName) {
        ExtensionConfiguration extensionConfiguration = null;
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne("org.restcomm.connect.dao.ExtensionsConfigurationDao.getConfigurationByName", (Object)extensionName);
            if (result != null) {
                extensionConfiguration = this.toExtensionConfiguration(result);
            }
            ExtensionConfiguration extensionConfiguration2 = extensionConfiguration;
            return extensionConfiguration2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtensionConfiguration getConfigurationBySid(Sid extensionSid) {
        ExtensionConfiguration extensionConfiguration = null;
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne("org.restcomm.connect.dao.ExtensionsConfigurationDao.getConfigurationBySid", (Object)extensionSid.toString());
            if (result != null) {
                extensionConfiguration = this.toExtensionConfiguration(result);
            }
            ExtensionConfiguration extensionConfiguration2 = extensionConfiguration;
            return extensionConfiguration2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExtensionConfiguration> getAllConfiguration() {
        Object extensionConfiguration = null;
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.restcomm.connect.dao.ExtensionsConfigurationDao.getAllConfiguration");
            ArrayList<ExtensionConfiguration> confs = new ArrayList<ExtensionConfiguration>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    confs.add(this.toExtensionConfiguration(result));
                }
            }
            ArrayList<ExtensionConfiguration> arrayList = confs;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteConfigurationByName(String extensionName) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete("org.restcomm.connect.dao.ExtensionsConfigurationDao.deleteConfigurationByName", (Object)extensionName);
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteConfigurationBySid(Sid extensionSid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete("org.restcomm.connect.dao.ExtensionsConfigurationDao.deleteConfigurationBySid", (Object)extensionSid.toString());
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLatestVersionByName(String extensionName, DateTime dateTime) {
        boolean result = false;
        try (SqlSession session = this.sessions.openSession();){
            int comp;
            DateTime dateUpdated = new DateTime(session.selectOne("org.restcomm.connect.dao.ExtensionsConfigurationDao.getDateUpdatedByName", (Object)extensionName));
            if (dateUpdated != null && (comp = DateTimeComparator.getInstance().compare((Object)dateTime, (Object)dateUpdated)) < 0) {
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLatestVersionBySid(Sid extensionSid, DateTime dateTime) {
        boolean result = false;
        try (SqlSession session = this.sessions.openSession();){
            int comp;
            DateTime dateUpdated = new DateTime(session.selectOne("org.restcomm.connect.dao.ExtensionsConfigurationDao.getDateUpdatedBySid", (Object)extensionSid.toString()));
            if (dateUpdated != null && (comp = DateTimeComparator.getInstance().compare((Object)dateTime, (Object)dateUpdated)) < 0) {
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validate(ExtensionConfiguration extensionConfiguration) {
        ExtensionConfiguration.configurationType configurationType2 = extensionConfiguration.getConfigurationType();
        if (configurationType2.equals((Object)ExtensionConfiguration.configurationType.JSON)) {
            Gson gson = new Gson();
            try {
                Object o = gson.fromJson((String)extensionConfiguration.getConfigurationData(), Object.class);
                String json = new GsonBuilder().setPrettyPrinting().create().toJson(o);
                boolean bl = json != null || !json.isEmpty();
                return bl;
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) return false;
                logger.debug((Object)("invalid json format, exception: " + e));
                return false;
            }
            finally {
                gson = null;
            }
        }
        if (!configurationType2.equals((Object)ExtensionConfiguration.configurationType.XML)) return false;
        XMLConfiguration xml = null;
        try {
            XMLConfiguration xmlConfiguration = new XMLConfiguration();
            xmlConfiguration.setDelimiterParsingDisabled(true);
            xmlConfiguration.setAttributeSplittingDisabled(true);
            InputStream is = IOUtils.toInputStream((String)extensionConfiguration.getConfigurationData().toString());
            xmlConfiguration.load(is);
            xml = xmlConfiguration;
            boolean bl = xml != null || !xml.isEmpty();
            return bl;
        }
        catch (Exception e) {
            if (!logger.isDebugEnabled()) return false;
            logger.debug((Object)("invalid xml document, exception: " + e));
            return false;
        }
        finally {
            xml = null;
        }
    }

    private ExtensionConfiguration toExtensionConfiguration(Map<String, Object> map) {
        Sid sid = new Sid((String)map.get("sid"));
        String extension = (String)map.get("extension");
        boolean enabled = true;
        if (DaoUtils.readBoolean(map.get("enabled")) != null) {
            enabled = DaoUtils.readBoolean(map.get("enabled"));
        }
        Object confData = map.get("configuration_data");
        ExtensionConfiguration.configurationType confType = ExtensionConfiguration.configurationType.valueOf((String)((String)map.get("configuration_type")));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        return new ExtensionConfiguration(sid, extension, enabled, confData, confType, dateCreated, dateUpdated);
    }

    private Map<String, Object> toMap(ExtensionConfiguration extensionConfiguration) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(extensionConfiguration.getSid()));
        map.put("extension", extensionConfiguration.getExtensionName());
        if (extensionConfiguration.getConfigurationData() != null) {
            map.put("configuration_data", extensionConfiguration.getConfigurationData());
        }
        if (extensionConfiguration.getConfigurationType() != null) {
            map.put("configuration_type", extensionConfiguration.getConfigurationType().toString());
        }
        if (extensionConfiguration.getDateCreated() != null) {
            map.put("date_created", DaoUtils.writeDateTime(extensionConfiguration.getDateCreated()));
        }
        if (extensionConfiguration.getDateUpdated() != null) {
            map.put("date_updated", DaoUtils.writeDateTime(extensionConfiguration.getDateUpdated()));
        }
        map.put("enabled", extensionConfiguration.isEnabled());
        return map;
    }
}

