/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoUtils;
import org.restcomm.connect.dao.GeolocationDao;
import org.restcomm.connect.dao.entities.Geolocation;

public class MybatisGeolocationDao
implements GeolocationDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.GeolocationDao.";
    private final SqlSessionFactory sessions;

    public MybatisGeolocationDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGeolocation(Geolocation gl) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.GeolocationDao.addGeolocation", this.toMap(gl));
            session.commit();
        }
    }

    @Override
    public Geolocation getGeolocation(Sid sid) {
        return this.getGeolocation("org.mobicents.servlet.sip.restcomm.dao.GeolocationDao.getGeolocation", sid.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Geolocation getGeolocation(String selector, String parameter) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne(selector, (Object)parameter);
            if (result != null) {
                Geolocation geolocation = this.toGeolocation(result);
                return geolocation;
            }
            Geolocation geolocation = null;
            return geolocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Geolocation> getGeolocations(Sid accountSid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.GeolocationDao.getGeolocations", (Object)accountSid.toString());
            ArrayList<Geolocation> geolocations = new ArrayList<Geolocation>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    geolocations.add(this.toGeolocation(result));
                }
            }
            ArrayList<Geolocation> arrayList = geolocations;
            return arrayList;
        }
    }

    @Override
    public void removeGeolocation(Sid sid) {
        this.removeGeolocations("org.mobicents.servlet.sip.restcomm.dao.GeolocationDao.removeGeolocation", sid);
    }

    @Override
    public void removeGeolocations(Sid accountSid) {
        this.removeGeolocations("org.mobicents.servlet.sip.restcomm.dao.GeolocationDao.removeGeolocations", accountSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeGeolocations(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, (Object)sid.toString());
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGeolocation(Geolocation gl) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.GeolocationDao.updateGeolocation", this.toMap(gl));
            session.commit();
        }
    }

    private Map<String, Object> toMap(Geolocation gl) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(gl.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(gl.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(gl.getDateUpdated()));
        map.put("date_executed", DaoUtils.writeDateTime(gl.getDateExecuted()));
        map.put("account_sid", DaoUtils.writeSid(gl.getAccountSid()));
        map.put("source", gl.getSource());
        map.put("device_identifier", gl.getDeviceIdentifier());
        map.put("geolocation_type", (Object)gl.getGeolocationType());
        map.put("response_status", gl.getResponseStatus());
        map.put("cell_id", gl.getCellId());
        map.put("location_area_code", gl.getLocationAreaCode());
        map.put("mobile_country_code", gl.getMobileCountryCode());
        map.put("mobile_network_code", gl.getMobileNetworkCode());
        map.put("network_entity_address", gl.getNetworkEntityAddress());
        map.put("age_of_location_info", gl.getAgeOfLocationInfo());
        map.put("device_latitude", gl.getDeviceLatitude());
        map.put("device_longitude", gl.getDeviceLongitude());
        map.put("accuracy", gl.getAccuracy());
        map.put("physical_address", gl.getPhysicalAddress());
        map.put("internet_address", gl.getInternetAddress());
        map.put("formatted_address", gl.getFormattedAddress());
        map.put("location_timestamp", DaoUtils.writeDateTime(gl.getLocationTimestamp()));
        map.put("event_geofence_latitude", gl.getEventGeofenceLatitude());
        map.put("event_geofence_longitude", gl.getEventGeofenceLongitude());
        map.put("radius", gl.getRadius());
        map.put("geolocation_positioning_type", gl.getGeolocationPositioningType());
        map.put("last_geolocation_response", gl.getLastGeolocationResponse());
        map.put("cause", gl.getCause());
        map.put("api_version", gl.getApiVersion());
        map.put("uri", DaoUtils.writeUri(gl.getUri()));
        return map;
    }

    private Geolocation toGeolocation(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime date_created = DaoUtils.readDateTime(map.get("date_created"));
        DateTime date_updated = DaoUtils.readDateTime(map.get("date_updated"));
        DateTime date_executed = DaoUtils.readDateTime(map.get("date_executed"));
        Sid account_sid = DaoUtils.readSid(map.get("account_sid"));
        String source = DaoUtils.readString(map.get("source"));
        String device_identifier = DaoUtils.readString(map.get("device_identifier"));
        Geolocation.GeolocationType geolocation_type = DaoUtils.readGeolocationType(map.get("geolocation_type"));
        String response_status = DaoUtils.readString(map.get("response_status"));
        String cell_id = DaoUtils.readString(map.get("cell_id"));
        String location_area_code = DaoUtils.readString(map.get("location_area_code"));
        Integer mobile_country_code = DaoUtils.readInteger(map.get("mobile_country_code"));
        String mobile_network_code = DaoUtils.readString(map.get("mobile_network_code"));
        Long network_entity_address = DaoUtils.readLong(map.get("network_entity_address"));
        Integer age_of_location_info = DaoUtils.readInteger(map.get("age_of_location_info"));
        String device_latitude = DaoUtils.readString(map.get("device_latitude"));
        String device_longitude = DaoUtils.readString(map.get("device_longitude"));
        Long accuracy = DaoUtils.readLong(map.get("accuracy"));
        String physical_address = DaoUtils.readString(map.get("physical_address"));
        String internet_address = DaoUtils.readString(map.get("internet_address"));
        String formatted_address = DaoUtils.readString(map.get("formatted_address"));
        DateTime location_timestamp = DaoUtils.readDateTime(map.get("location_timestamp"));
        String event_geofence_latitude = DaoUtils.readString(map.get("event_geofence_latitude"));
        String event_geofence_longitude = DaoUtils.readString(map.get("event_geofence_longitude"));
        Long radius = DaoUtils.readLong(map.get("radius"));
        String geolocation_positioning_type = DaoUtils.readString(map.get("geolocation_positioning_type"));
        String last_geolocation_response = DaoUtils.readString(map.get("last_geolocation_response"));
        String cause = DaoUtils.readString(map.get("cause"));
        String api_version = DaoUtils.readString(map.get("api_version"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        return new Geolocation(sid, date_created, date_updated, date_executed, account_sid, source, device_identifier, geolocation_type, response_status, cell_id, location_area_code, mobile_country_code, mobile_network_code, network_entity_address, age_of_location_info, device_latitude, device_longitude, accuracy, physical_address, internet_address, formatted_address, location_timestamp, event_geofence_latitude, event_geofence_longitude, radius, geolocation_positioning_type, last_geolocation_response, cause, api_version, uri);
    }
}

