/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoUtils;
import org.restcomm.connect.dao.HttpCookiesDao;

public final class MybatisHttpCookiesDao
implements HttpCookiesDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.HttpCookiesDao.";
    private final SqlSessionFactory sessions;

    public MybatisHttpCookiesDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCookie(Sid sid, Cookie cookie) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.HttpCookiesDao.addCookie", this.toMap(sid, cookie));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Cookie> getCookies(Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.HttpCookiesDao.getCookies", (Object)sid.toString());
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    cookies.add(this.toCookie(result));
                }
            }
            ArrayList<Cookie> arrayList = cookies;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasCookie(Sid sid, Cookie cookie) {
        try (SqlSession session = this.sessions.openSession();){
            Integer result = (Integer)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.HttpCookiesDao.hasCookie", this.toMap(sid, cookie));
            if (result > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasExpiredCookies(Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            Integer result = (Integer)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.HttpCookiesDao.hasExpiredCookies", (Object)sid.toString());
            if (result > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCookies(Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete("org.mobicents.servlet.sip.restcomm.dao.HttpCookiesDao.removeCookies", (Object)sid.toString());
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExpiredCookies(Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete("org.mobicents.servlet.sip.restcomm.dao.HttpCookiesDao.removeExpiredCookies", (Object)sid.toString());
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCookie(Sid sid, Cookie cookie) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.HttpCookiesDao.updateCookie", this.toMap(sid, cookie));
            session.commit();
        }
    }

    private Cookie toCookie(Map<String, Object> map) {
        String comment = DaoUtils.readString(map.get("comment"));
        String domain = DaoUtils.readString(map.get("domain"));
        Date expirationDate = (Date)map.get("expiration_date");
        String name = DaoUtils.readString(map.get("name"));
        String path = DaoUtils.readString(map.get("path"));
        String value = DaoUtils.readString(map.get("value"));
        int version = DaoUtils.readInteger(map.get("version"));
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setComment(comment);
        cookie.setDomain(domain);
        cookie.setExpiryDate(expirationDate);
        cookie.setPath(path);
        cookie.setVersion(version);
        return cookie;
    }

    private Map<String, Object> toMap(Sid sid, Cookie cookie) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(sid));
        map.put("comment", cookie.getComment());
        map.put("domain", cookie.getDomain());
        map.put("expiration_date", cookie.getExpiryDate());
        map.put("name", cookie.getName());
        map.put("path", cookie.getPath());
        map.put("value", cookie.getValue());
        map.put("version", cookie.getVersion());
        return map;
    }
}

