/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoUtils;
import org.restcomm.connect.dao.InstanceIdDao;
import org.restcomm.connect.dao.entities.InstanceId;

@ThreadSafe
public class MybatisInstanceIdDao
implements InstanceIdDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.InstanceIdDao.";
    private final SqlSessionFactory sessions;

    public MybatisInstanceIdDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstanceId getInstanceId() {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.InstanceIdDao.getInstanceId");
            if (result != null) {
                InstanceId instanceId = this.toInstanceId(result);
                return instanceId;
            }
            InstanceId instanceId = null;
            return instanceId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstanceId getInstanceIdByHost(String host) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.InstanceIdDao.getInstanceIdByHost", (Object)host);
            if (result != null) {
                InstanceId instanceId = this.toInstanceId(result);
                return instanceId;
            }
            InstanceId instanceId = null;
            return instanceId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInstancecId(InstanceId instanceId) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.InstanceIdDao.addInstanceId", this.toMap(instanceId));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInstanceId(InstanceId instanceId) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.InstanceIdDao.updateInstanceId", this.toMap(instanceId));
            session.commit();
        }
    }

    private InstanceId toInstanceId(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("instance_id"));
        String host = DaoUtils.readString(map.get("host"));
        if (host == null || host.isEmpty()) {
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        return new InstanceId(sid, host, dateCreated, dateUpdated);
    }

    private Map<String, Object> toMap(InstanceId instanceId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instance_id", DaoUtils.writeSid(instanceId.getId()));
        String host = instanceId.getHost();
        if (host == null || host.isEmpty()) {
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        map.put("host", host);
        map.put("date_created", DaoUtils.writeDateTime(instanceId.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(instanceId.getDateUpdated()));
        return map;
    }
}

