/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoUtils;
import org.restcomm.connect.dao.MediaResourceBrokerDao;
import org.restcomm.connect.dao.entities.MediaResourceBrokerEntity;
import org.restcomm.connect.dao.entities.MediaResourceBrokerEntityFilter;

@ThreadSafe
public final class MybatisMediaResourceBrokerDao
implements MediaResourceBrokerDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.MediaResourceBrokerDao.";
    private final SqlSessionFactory sessions;

    public MybatisMediaResourceBrokerDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediaResourceBrokerEntity(MediaResourceBrokerEntity ms) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.MediaResourceBrokerDao.addMediaResourceBrokerEntity", this.toMap(ms));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMediaResource(MediaResourceBrokerEntity ms) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.MediaResourceBrokerDao.updateMediaResource", this.toMap(ms));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MediaResourceBrokerEntity> getMediaResourceBrokerEntities() {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.MediaResourceBrokerDao.getMediaServers");
            ArrayList<MediaResourceBrokerEntity> mList = new ArrayList<MediaResourceBrokerEntity>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    mList.add(this.toMRBEntity(result));
                }
            }
            ArrayList<MediaResourceBrokerEntity> arrayList = mList;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MediaResourceBrokerEntity> getConnectedSlaveEntitiesByConfSid(Sid conferenceSid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.MediaResourceBrokerDao.getConnectedSlaveEntitiesByConfSid", (Object)conferenceSid.toString());
            ArrayList<MediaResourceBrokerEntity> entities = new ArrayList<MediaResourceBrokerEntity>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    entities.add(this.toMRBEntity(result));
                }
            }
            ArrayList<MediaResourceBrokerEntity> arrayList = entities;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMediaResourceBrokerEntity(MediaResourceBrokerEntityFilter filter) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete("org.mobicents.servlet.sip.restcomm.dao.MediaResourceBrokerDao.removeMediaResourceBrokerEntity", (Object)filter);
            session.commit();
        }
    }

    private MediaResourceBrokerEntity toMRBEntity(Map<String, Object> map) {
        Sid conferenceSid = DaoUtils.readSid(map.get("conference_sid"));
        String slaveMsId = DaoUtils.readString(map.get("slave_ms_id"));
        String slaveMsBridgeEpId = DaoUtils.readString(map.get("slave_ms_bridge_ep_id"));
        String slaveMsCnfEpId = DaoUtils.readString(map.get("slave_ms_cnf_ep_id"));
        boolean isBridgedTogether = DaoUtils.readBoolean(map.get("is_bridged_together"));
        return new MediaResourceBrokerEntity(conferenceSid, slaveMsId, slaveMsBridgeEpId, slaveMsCnfEpId, isBridgedTogether);
    }

    private Map<String, Object> toMap(MediaResourceBrokerEntity ms) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conference_sid", DaoUtils.writeSid(ms.getConferenceSid()));
        map.put("slave_ms_id", ms.getSlaveMsId());
        map.put("slave_ms_bridge_ep_id", ms.getSlaveMsBridgeEpId());
        map.put("slave_ms_cnf_ep_id", ms.getSlaveMsCnfEpId());
        map.put("is_bridged_together", ms.isBridgedTogether());
        return map;
    }
}

