/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.dao.DaoUtils;
import org.restcomm.connect.dao.MediaServersDao;
import org.restcomm.connect.dao.entities.MediaServerEntity;

@ThreadSafe
public final class MybatisMediaServerDao
implements MediaServersDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.MediaServersDao.";
    private final SqlSessionFactory sessions;

    public MybatisMediaServerDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediaServer(MediaServerEntity ms) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.MediaServersDao.addMediaServer", this.toMap(ms));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMediaServer(MediaServerEntity ms) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.MediaServersDao.updateMediaServer", this.toMap(ms));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MediaServerEntity> getMediaServerEntityByIP(String msIPAddress) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.MediaServersDao.getMediaServerEntityByIP", (Object)msIPAddress);
            ArrayList<MediaServerEntity> msList = new ArrayList<MediaServerEntity>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    msList.add(this.toMediaServer(result));
                }
            }
            ArrayList<MediaServerEntity> arrayList = msList;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MediaServerEntity> getMediaServers() {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.MediaServersDao.getMediaServers");
            ArrayList<MediaServerEntity> msList = new ArrayList<MediaServerEntity>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    msList.add(this.toMediaServer(result));
                }
            }
            ArrayList<MediaServerEntity> arrayList = msList;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaServerEntity getMediaServer(String msId) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.MediaServersDao.getMediaServer", (Object)msId);
            if (result != null) {
                MediaServerEntity mediaServerEntity = this.toMediaServer(result);
                return mediaServerEntity;
            }
            MediaServerEntity mediaServerEntity = null;
            return mediaServerEntity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMediaServerEntity(String msId) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete("org.mobicents.servlet.sip.restcomm.dao.MediaServersDao.removeMediaServerEntity", (Object)msId);
            session.commit();
        }
    }

    private MediaServerEntity toMediaServer(Map<String, Object> map) {
        int msId = DaoUtils.readInteger(map.get("ms_id"));
        String compatibility = DaoUtils.readString(map.get("compatibility"));
        String localIpAddress = DaoUtils.readString(map.get("local_ip"));
        int localPort = DaoUtils.readInteger(map.get("local_port"));
        String remoteIpAddress = DaoUtils.readString(map.get("remote_ip"));
        int remotePort = DaoUtils.readInteger(map.get("remote_port"));
        String responseTimeout = DaoUtils.readString(map.get("response_timeout"));
        String externalAddress = DaoUtils.readString(map.get("external_address"));
        return new MediaServerEntity(msId, compatibility, localIpAddress, localPort, remoteIpAddress, remotePort, responseTimeout, externalAddress);
    }

    private Map<String, Object> toMap(MediaServerEntity ms) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ms_id", ms.getMsId());
        map.put("compatibility", ms.getCompatibility());
        map.put("local_ip", ms.getLocalIpAddress());
        map.put("local_port", ms.getLocalPort());
        map.put("remote_ip", ms.getRemoteIpAddress());
        map.put("remote_port", ms.getRemotePort());
        map.put("response_timeout", ms.getResponseTimeout());
        map.put("external_address", ms.getExternalAddress());
        return map;
    }
}

