/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoUtils;
import org.restcomm.connect.dao.NotificationsDao;
import org.restcomm.connect.dao.entities.Notification;
import org.restcomm.connect.dao.entities.NotificationFilter;

@ThreadSafe
public final class MybatisNotificationsDao
implements NotificationsDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.NotificationsDao.";
    private final SqlSessionFactory sessions;

    public MybatisNotificationsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotification(Notification notification) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.NotificationsDao.addNotification", this.toMap(notification));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification getNotification(Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.NotificationsDao.getNotification", (Object)sid.toString());
            if (result != null) {
                Notification notification = this.toNotification(result);
                return notification;
            }
            Notification notification = null;
            return notification;
        }
    }

    @Override
    public List<Notification> getNotifications(Sid accountSid) {
        return this.getNotifications("org.mobicents.servlet.sip.restcomm.dao.NotificationsDao.getNotifications", accountSid.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Notification> getNotifications(NotificationFilter filter) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.NotificationsDao.getNotificationsByUsingFilters", (Object)filter);
            ArrayList<Notification> cdrs = new ArrayList<Notification>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    cdrs.add(this.toNotification(result));
                }
            }
            ArrayList<Notification> arrayList = cdrs;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getTotalNotification(NotificationFilter filter) {
        try (SqlSession session = this.sessions.openSession();){
            Integer total;
            Integer n = total = (Integer)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.NotificationsDao.getTotalNotificationByUsingFilters", (Object)filter);
            return n;
        }
    }

    @Override
    public List<Notification> getNotificationsByCall(Sid callSid) {
        return this.getNotifications("org.mobicents.servlet.sip.restcomm.dao.NotificationsDao.getNotificationsByCall", callSid.toString());
    }

    @Override
    public List<Notification> getNotificationsByLogLevel(int logLevel) {
        return this.getNotifications("org.mobicents.servlet.sip.restcomm.dao.NotificationsDao.getNotificationsByLogLevel", logLevel);
    }

    @Override
    public List<Notification> getNotificationsByMessageDate(DateTime messageDate) {
        HashMap<String, Date> parameters = new HashMap<String, Date>();
        parameters.put("start_date", messageDate.toDate());
        parameters.put("end_date", messageDate.plusDays(1).toDate());
        return this.getNotifications("org.mobicents.servlet.sip.restcomm.dao.NotificationsDao.getNotificationsByMessageDate", parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Notification> getNotifications(String selector, Object input) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList(selector, input);
            ArrayList<Notification> notifications = new ArrayList<Notification>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    notifications.add(this.toNotification(result));
                }
            }
            ArrayList<Notification> arrayList = notifications;
            return arrayList;
        }
    }

    @Override
    public void removeNotification(Sid sid) {
        this.removeNotifications("org.mobicents.servlet.sip.restcomm.dao.NotificationsDao.removeNotification", sid);
    }

    @Override
    public void removeNotifications(Sid accountSid) {
        this.removeNotifications("org.mobicents.servlet.sip.restcomm.dao.NotificationsDao.removeNotifications", accountSid);
    }

    @Override
    public void removeNotificationsByCall(Sid callSid) {
        this.removeNotifications("org.mobicents.servlet.sip.restcomm.dao.NotificationsDao.removeNotificationsByCall", callSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNotifications(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, (Object)sid.toString());
            session.commit();
        }
    }

    private Map<String, Object> toMap(Notification notification) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(notification.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(notification.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(notification.getDateUpdated()));
        map.put("account_sid", DaoUtils.writeSid(notification.getAccountSid()));
        map.put("call_sid", DaoUtils.writeSid(notification.getCallSid()));
        map.put("api_version", notification.getApiVersion());
        map.put("log", notification.getLog());
        map.put("error_code", notification.getErrorCode());
        map.put("more_info", DaoUtils.writeUri(notification.getMoreInfo()));
        map.put("message_text", notification.getMessageText());
        map.put("message_date", DaoUtils.writeDateTime(notification.getMessageDate()));
        map.put("request_url", DaoUtils.writeUri(notification.getRequestUrl()));
        map.put("request_method", notification.getRequestMethod());
        map.put("request_variables", notification.getRequestVariables());
        map.put("response_headers", notification.getResponseHeaders());
        map.put("response_body", notification.getResponseBody());
        map.put("uri", DaoUtils.writeUri(notification.getUri()));
        return map;
    }

    private Notification toNotification(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        Sid accountSid = DaoUtils.readSid(map.get("account_sid"));
        Sid callSid = DaoUtils.readSid(map.get("call_sid"));
        String apiVersion = DaoUtils.readString(map.get("api_version"));
        Integer log = DaoUtils.readInteger(map.get("log"));
        Integer errorCode = DaoUtils.readInteger(map.get("error_code"));
        URI moreInfo = DaoUtils.readUri(map.get("more_info"));
        String messageText = DaoUtils.readString(map.get("message_text"));
        DateTime messageDate = DaoUtils.readDateTime(map.get("message_date"));
        URI requestUrl = DaoUtils.readUri(map.get("request_url"));
        String requestMethod = DaoUtils.readString(map.get("request_method"));
        String requestVariables = DaoUtils.readString(map.get("request_variables"));
        String responseHeaders = DaoUtils.readString(map.get("response_headers"));
        String responseBody = DaoUtils.readString(map.get("response_body"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        return new Notification(sid, dateCreated, dateUpdated, accountSid, callSid, apiVersion, log, errorCode, moreInfo, messageText, messageDate, requestUrl, requestMethod, requestVariables, responseHeaders, responseBody, uri);
    }
}

