/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoUtils;
import org.restcomm.connect.dao.OutgoingCallerIdsDao;
import org.restcomm.connect.dao.entities.OutgoingCallerId;

@ThreadSafe
public final class MybatisOutgoingCallerIdsDao
implements OutgoingCallerIdsDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.OutgoingCallerIdsDao.";
    private final SqlSessionFactory sessions;

    public MybatisOutgoingCallerIdsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOutgoingCallerId(OutgoingCallerId outgoingCallerId) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.OutgoingCallerIdsDao.addOutgoingCallerId", this.toMap(outgoingCallerId));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutgoingCallerId getOutgoingCallerId(Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.OutgoingCallerIdsDao.getOutgoingCallerId", (Object)sid.toString());
            if (result != null) {
                OutgoingCallerId outgoingCallerId = this.toOutgoingCallerId(result);
                return outgoingCallerId;
            }
            OutgoingCallerId outgoingCallerId = null;
            return outgoingCallerId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OutgoingCallerId> getOutgoingCallerIds(Sid accountSid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.OutgoingCallerIdsDao.getOutgoingCallerIds", (Object)accountSid.toString());
            ArrayList<OutgoingCallerId> outgoingCallerIds = new ArrayList<OutgoingCallerId>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    outgoingCallerIds.add(this.toOutgoingCallerId(result));
                }
            }
            ArrayList<OutgoingCallerId> arrayList = outgoingCallerIds;
            return arrayList;
        }
    }

    @Override
    public void removeOutgoingCallerId(Sid sid) {
        this.removeOutgoingCallerIds("org.mobicents.servlet.sip.restcomm.dao.OutgoingCallerIdsDao.removeOutgoingCallerId", sid);
    }

    @Override
    public void removeOutgoingCallerIds(Sid accountSid) {
        this.removeOutgoingCallerIds("org.mobicents.servlet.sip.restcomm.dao.OutgoingCallerIdsDao.removeOutgoingCallerIds", accountSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOutgoingCallerIds(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, (Object)sid.toString());
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateOutgoingCallerId(OutgoingCallerId outgoingCallerId) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.OutgoingCallerIdsDao.updateOutgoingCallerId", this.toMap(outgoingCallerId));
            session.commit();
        }
    }

    private Map<String, Object> toMap(OutgoingCallerId outgoingCallerId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(outgoingCallerId.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(outgoingCallerId.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(outgoingCallerId.getDateUpdated()));
        map.put("friendly_name", outgoingCallerId.getFriendlyName());
        map.put("account_sid", DaoUtils.writeSid(outgoingCallerId.getAccountSid()));
        map.put("phone_number", outgoingCallerId.getPhoneNumber());
        map.put("uri", DaoUtils.writeUri(outgoingCallerId.getUri()));
        return map;
    }

    private OutgoingCallerId toOutgoingCallerId(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        String friendlyName = DaoUtils.readString(map.get("friendly_name"));
        Sid accountSid = DaoUtils.readSid(map.get("account_sid"));
        String phoneNumber = DaoUtils.readString(map.get("phone_number"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        return new OutgoingCallerId(sid, dateCreated, dateUpdated, friendlyName, accountSid, phoneNumber, uri);
    }
}

