/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.amazonS3.S3AccessTool;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.util.UriUtils;
import org.restcomm.connect.dao.DaoUtils;
import org.restcomm.connect.dao.RecordingsDao;
import org.restcomm.connect.dao.entities.Recording;
import org.restcomm.connect.dao.entities.RecordingFilter;

@ThreadSafe
public final class MybatisRecordingsDao
implements RecordingsDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.RecordingsDao.";
    private final SqlSessionFactory sessions;
    private S3AccessTool s3AccessTool;
    private String recordingPath;

    public MybatisRecordingsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    public MybatisRecordingsDao(SqlSessionFactory sessions, S3AccessTool s3AccessTool, String recordingPath) {
        this.sessions = sessions;
        this.s3AccessTool = s3AccessTool;
        this.recordingPath = recordingPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRecording(Recording recording) {
        URI s3Uri;
        if (this.s3AccessTool != null && (s3Uri = this.s3AccessTool.uploadFile(this.recordingPath + "/" + recording.getSid().toString() + ".wav")) != null) {
            recording = recording.setS3Uri(s3Uri);
        }
        String fileUrl = String.format("/restcomm/%s/Accounts/%s/Recordings/%s", recording.getApiVersion(), recording.getAccountSid(), recording.getSid());
        recording = recording.updateFileUri(this.generateLocalFileUri(fileUrl));
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.RecordingsDao.addRecording", this.toMap(recording));
            session.commit();
        }
    }

    public URI generateLocalFileUri(String recordingRelativeUri) {
        URI uriToResolve = null;
        try {
            uriToResolve = new URI(recordingRelativeUri + ".wav");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return UriUtils.resolve(uriToResolve);
    }

    @Override
    public Recording getRecording(Sid sid) {
        return this.getRecording("org.mobicents.servlet.sip.restcomm.dao.RecordingsDao.getRecording", sid);
    }

    @Override
    public Recording getRecordingByCall(Sid callSid) {
        return this.getRecording("org.mobicents.servlet.sip.restcomm.dao.RecordingsDao.getRecordingByCall", callSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Recording> getRecordingsByCall(Sid callSid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.RecordingsDao.getRecordingsByCall", (Object)callSid.toString());
            ArrayList<Recording> recordings = new ArrayList<Recording>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    recordings.add(this.toRecording(result));
                }
            }
            ArrayList<Recording> arrayList = recordings;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Recording getRecording(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne(selector, (Object)sid.toString());
            if (result != null) {
                Recording recording = this.toRecording(result);
                return recording;
            }
            Recording recording = null;
            return recording;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Recording> getRecordings(Sid accountSid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.RecordingsDao.getRecordings", (Object)accountSid.toString());
            ArrayList<Recording> recordings = new ArrayList<Recording>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    recordings.add(this.toRecording(result));
                }
            }
            ArrayList<Recording> arrayList = recordings;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Recording> getRecordings(RecordingFilter filter) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.RecordingsDao.getRecordingsByUsingFilters", (Object)filter);
            ArrayList<Recording> cdrs = new ArrayList<Recording>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    cdrs.add(this.toRecording(result));
                }
            }
            ArrayList<Recording> arrayList = cdrs;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getTotalRecording(RecordingFilter filter) {
        try (SqlSession session = this.sessions.openSession();){
            Integer total;
            Integer n = total = (Integer)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.RecordingsDao.getTotalRecordingByUsingFilters", (Object)filter);
            return n;
        }
    }

    @Override
    public void removeRecording(Sid sid) {
        this.removeRecording("org.mobicents.servlet.sip.restcomm.dao.RecordingsDao.removeRecording", sid);
    }

    @Override
    public void removeRecordings(Sid accountSid) {
        this.removeRecording("org.mobicents.servlet.sip.restcomm.dao.RecordingsDao.removeRecordings", accountSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRecording(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, (Object)sid.toString());
            session.commit();
        }
    }

    private Map<String, Object> toMap(Recording recording) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(recording.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(recording.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(recording.getDateUpdated()));
        map.put("account_sid", DaoUtils.writeSid(recording.getAccountSid()));
        map.put("call_sid", DaoUtils.writeSid(recording.getCallSid()));
        map.put("duration", recording.getDuration());
        map.put("api_version", recording.getApiVersion());
        map.put("uri", DaoUtils.writeUri(recording.getUri()));
        map.put("file_uri", DaoUtils.writeUri(recording.getFileUri()));
        if (recording.getS3Uri() != null) {
            map.put("s3_uri", DaoUtils.writeUri(recording.getS3Uri()));
        } else {
            map.put("s3_uri", null);
        }
        return map;
    }

    private Recording toRecording(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        Sid accountSid = DaoUtils.readSid(map.get("account_sid"));
        Sid callSid = DaoUtils.readSid(map.get("call_sid"));
        Double duration = DaoUtils.readDouble(map.get("duration"));
        String apiVersion = DaoUtils.readString(map.get("api_version"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        String fileUri = (String)map.get("file_uri");
        if (fileUri == null || fileUri.isEmpty()) {
            String file = String.format("/restcomm/%s/Accounts/%s/Recordings/%s", apiVersion, accountSid, sid);
            fileUri = this.generateLocalFileUri(file).toString();
        }
        String s3Uri = (String)map.get("s3_uri");
        return new Recording(sid, dateCreated, dateUpdated, accountSid, callSid, duration, apiVersion, uri, DaoUtils.readUri(fileUri), DaoUtils.readUri(s3Uri));
    }
}

