/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.dao.mybatis;

import java.math.BigDecimal;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoUtils;
import org.restcomm.connect.dao.SmsMessagesDao;
import org.restcomm.connect.dao.entities.SmsMessage;
import org.restcomm.connect.dao.entities.SmsMessageFilter;

@ThreadSafe
public final class MybatisSmsMessagesDao
implements SmsMessagesDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.SmsMessagesDao.";
    private final SqlSessionFactory sessions;

    public MybatisSmsMessagesDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSmsMessage(SmsMessage smsMessage) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.SmsMessagesDao.addSmsMessage", this.toMap(smsMessage));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SmsMessage getSmsMessage(Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.SmsMessagesDao.getSmsMessage", (Object)sid.toString());
            if (result != null) {
                SmsMessage smsMessage = this.toSmsMessage(result);
                return smsMessage;
            }
            SmsMessage smsMessage = null;
            return smsMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SmsMessage> getSmsMessages(Sid accountSid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.SmsMessagesDao.getSmsMessages", (Object)accountSid.toString());
            ArrayList<SmsMessage> smsMessages = new ArrayList<SmsMessage>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    smsMessages.add(this.toSmsMessage(result));
                }
            }
            ArrayList<SmsMessage> arrayList = smsMessages;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SmsMessage> getSmsMessages(SmsMessageFilter filter) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.SmsMessagesDao.getSmsMessagesByUsingFilters", (Object)filter);
            ArrayList<SmsMessage> cdrs = new ArrayList<SmsMessage>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    cdrs.add(this.toSmsMessage(result));
                }
            }
            ArrayList<SmsMessage> arrayList = cdrs;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getTotalSmsMessage(SmsMessageFilter filter) {
        try (SqlSession session = this.sessions.openSession();){
            Integer total;
            Integer n = total = (Integer)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.SmsMessagesDao.getTotalSmsMessageByUsingFilters", (Object)filter);
            return n;
        }
    }

    @Override
    public void removeSmsMessage(Sid sid) {
        this.deleteSmsMessage("org.mobicents.servlet.sip.restcomm.dao.SmsMessagesDao.removeSmsMessage", sid);
    }

    @Override
    public void removeSmsMessages(Sid accountSid) {
        this.deleteSmsMessage("org.mobicents.servlet.sip.restcomm.dao.SmsMessagesDao.removeSmsMessages", accountSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSmsMessage(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, (Object)sid.toString());
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSmsMessage(SmsMessage smsMessage) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.SmsMessagesDao.updateSmsMessage", this.toMap(smsMessage));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSmsMessagesPerAccountLastPerMinute(String accountSid) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = formatter.format(DateTime.now().minusSeconds(60).toDate());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("start_time", date);
        params.put("account_sid", accountSid);
        try (SqlSession session = this.sessions.openSession();){
            int total;
            int n = total = ((Integer)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.SmsMessagesDao.getSmsMessagesPerAccountLastPerMinute", params)).intValue();
            return n;
        }
    }

    private Map<String, Object> toMap(SmsMessage smsMessage) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(smsMessage.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(smsMessage.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(smsMessage.getDateUpdated()));
        map.put("date_sent", DaoUtils.writeDateTime(smsMessage.getDateSent()));
        map.put("account_sid", DaoUtils.writeSid(smsMessage.getAccountSid()));
        map.put("sender", smsMessage.getSender());
        map.put("recipient", smsMessage.getRecipient());
        map.put("body", smsMessage.getBody());
        map.put("status", smsMessage.getStatus().toString());
        map.put("direction", smsMessage.getDirection().toString());
        map.put("price", DaoUtils.writeBigDecimal(smsMessage.getPrice()));
        map.put("price_unit", DaoUtils.writeCurrency(smsMessage.getPriceUnit()));
        map.put("api_version", smsMessage.getApiVersion());
        map.put("uri", DaoUtils.writeUri(smsMessage.getUri()));
        return map;
    }

    private SmsMessage toSmsMessage(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        DateTime dateSent = DaoUtils.readDateTime(map.get("date_sent"));
        Sid accountSid = DaoUtils.readSid(map.get("account_sid"));
        String sender = DaoUtils.readString(map.get("sender"));
        String recipient = DaoUtils.readString(map.get("recipient"));
        String body = DaoUtils.readString(map.get("body"));
        SmsMessage.Status status = SmsMessage.Status.getStatusValue(DaoUtils.readString(map.get("status")));
        SmsMessage.Direction direction = SmsMessage.Direction.getDirectionValue(DaoUtils.readString(map.get("direction")));
        BigDecimal price = DaoUtils.readBigDecimal(map.get("price"));
        Currency priceUnit = DaoUtils.readCurrency(map.get("price_unit"));
        String apiVersion = DaoUtils.readString(map.get("api_version"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        return new SmsMessage(sid, dateCreated, dateUpdated, dateSent, accountSid, sender, recipient, body, status, direction, price, priceUnit, apiVersion, uri);
    }
}

