/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.fax;

import akka.actor.ActorRef;
import java.io.File;
import java.net.URI;
import java.net.URLConnection;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.configuration.Configuration;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.StatusLine;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.restcomm.connect.commons.faulttolerance.RestcommUntypedActor;
import org.restcomm.connect.fax.FaxRequest;
import org.restcomm.connect.fax.FaxResponse;
import org.restcomm.connect.fax.FaxServiceException;

public final class InterfaxService
extends RestcommUntypedActor {
    private static final String url = "https://rest.interfax.net/outbound/faxes?faxNumber=";
    private final TrustStrategy strategy;
    private final String user;
    private final String password;

    public InterfaxService(Configuration configuration) {
        this.user = configuration.getString("user");
        this.password = configuration.getString("password");
        this.strategy = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        };
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (FaxRequest.class.equals(klass)) {
            try {
                sender.tell((Object)new FaxResponse(this.send(message)), self);
            }
            catch (Exception exception) {
                sender.tell((Object)new FaxResponse(exception), self);
            }
        }
    }

    private URI send(Object message) throws Exception {
        FaxRequest request = (FaxRequest)message;
        String to = request.to();
        File file = request.file();
        DefaultHttpClient client = new DefaultHttpClient();
        BasicHttpContext context = new BasicHttpContext();
        SSLSocketFactory sockets = new SSLSocketFactory(this.strategy);
        Scheme scheme = new Scheme("https", 443, (SchemeSocketFactory)sockets);
        client.getConnectionManager().getSchemeRegistry().register(scheme);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.user, this.password);
        HttpPost post = new HttpPost(url + to);
        String mime = URLConnection.guessContentTypeFromName(file.getName());
        FileEntity entity = new FileEntity(file, mime);
        post.addHeader(new BasicScheme().authenticate((Credentials)credentials, (HttpRequest)post, (HttpContext)context));
        post.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = client.execute((HttpUriRequest)post, (HttpContext)context);
        StatusLine status = response.getStatusLine();
        int code = status.getStatusCode();
        if (201 == code) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            Header[] headers = response.getHeaders("Location");
            Header location = headers[0];
            String resource = location.getValue();
            return URI.create(resource);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(code).append(" ").append(status.getReasonPhrase());
        throw new FaxServiceException(buffer.toString());
    }
}

