/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.sms.smpp;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import java.net.URI;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.entities.Sid;
import org.restcomm.connect.sms.smpp.SmppInterpreter;

public class SmppInterpreterBuilder {
    private final ActorSystem system;
    private Configuration configuration;
    private ActorRef service;
    private DaoManager storage;
    private Sid accountId;
    private String version;
    private URI url;
    private String method;
    private URI fallbackUrl;
    private String fallbackMethod;

    public SmppInterpreterBuilder(ActorSystem system) {
        this.system = system;
    }

    public ActorRef build() {
        return this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new SmppInterpreter(SmppInterpreterBuilder.this.service, SmppInterpreterBuilder.this.configuration, SmppInterpreterBuilder.this.storage, SmppInterpreterBuilder.this.accountId, SmppInterpreterBuilder.this.version, SmppInterpreterBuilder.this.url, SmppInterpreterBuilder.this.method, SmppInterpreterBuilder.this.fallbackUrl, SmppInterpreterBuilder.this.fallbackMethod);
            }
        }));
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setSmsService(ActorRef service) {
        this.service = service;
    }

    public void setStorage(DaoManager storage) {
        this.storage = storage;
    }

    public void setAccount(Sid accountId) {
        this.accountId = accountId;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setFallbackUrl(URI fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
    }

    public void setFallbackMethod(String fallbackMethod) {
        this.fallbackMethod = fallbackMethod;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

