/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.sms.smpp;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import com.cloudhopper.commons.charset.Charset;
import com.cloudhopper.commons.charset.CharsetUtil;
import com.cloudhopper.smpp.pdu.SubmitSm;
import com.cloudhopper.smpp.type.Address;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.SmppChannelException;
import com.cloudhopper.smpp.type.SmppInvalidArgumentException;
import com.cloudhopper.smpp.type.SmppTimeoutException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipURI;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.util.UriUtils;
import org.restcomm.connect.dao.AccountsDao;
import org.restcomm.connect.dao.ApplicationsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.IncomingPhoneNumbersDao;
import org.restcomm.connect.dao.entities.Application;
import org.restcomm.connect.dao.entities.IncomingPhoneNumber;
import org.restcomm.connect.interpreter.StartInterpreter;
import org.restcomm.connect.monitoringservice.MonitoringService;
import org.restcomm.connect.sms.SmsSession;
import org.restcomm.connect.sms.api.CreateSmsSession;
import org.restcomm.connect.sms.api.DestroySmsSession;
import org.restcomm.connect.sms.api.SmsServiceResponse;
import org.restcomm.connect.sms.smpp.SmppClientOpsThread;
import org.restcomm.connect.sms.smpp.SmppInboundMessageEntity;
import org.restcomm.connect.sms.smpp.SmppInterpreterBuilder;
import org.restcomm.connect.sms.smpp.SmppOutboundMessageEntity;
import org.restcomm.connect.sms.smpp.SmppService;

public class SmppMessageHandler
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final ActorSystem system = this.getContext().system();
    private final ServletContext servletContext;
    private final DaoManager storage;
    private final Configuration configuration;
    private final SipFactory sipFactory;
    private final ActorRef monitoringService;

    public SmppMessageHandler(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.storage = (DaoManager)servletContext.getAttribute(DaoManager.class.getName());
        this.configuration = (Configuration)servletContext.getAttribute(Configuration.class.getName());
        this.sipFactory = (SipFactory)servletContext.getAttribute(SipFactory.class.getName());
        this.monitoringService = (ActorRef)servletContext.getAttribute(MonitoringService.class.getName());
    }

    public void onReceive(Object message) throws Exception {
        UntypedActorContext context = this.getContext();
        ActorRef sender = this.sender();
        ActorRef self = this.self();
        if (message instanceof SmppInboundMessageEntity) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("SmppMessageHandler processing Inbound Message " + message.toString());
            }
            this.inbound((SmppInboundMessageEntity)message);
        } else if (message instanceof SmppOutboundMessageEntity) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("SmppMessageHandler processing Outbound Message " + message.toString());
            }
            this.outbound((SmppOutboundMessageEntity)message);
        } else if (message instanceof CreateSmsSession) {
            ActorRef session = this.session();
            SmsServiceResponse response = new SmsServiceResponse((Object)session);
            sender.tell((Object)response, self);
        } else if (message instanceof DestroySmsSession) {
            DestroySmsSession destroySmsSession = (DestroySmsSession)message;
            ActorRef session = destroySmsSession.session();
            context.stop(session);
        }
    }

    private void inbound(SmppInboundMessageEntity request) throws IOException {
        ActorRef self = this.self();
        String to = request.getSmppTo();
        IncomingPhoneNumbersDao numbers = this.storage.getIncomingPhoneNumbersDao();
        IncomingPhoneNumber number = numbers.getIncomingPhoneNumber(to);
        if (this.redirectToHostedSmsApp(self, request, this.storage.getAccountsDao(), this.storage.getApplicationsDao(), to)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("SMPP Message Accepted - A Restcomm Hosted App is Found for Number : " + number.getPhoneNumber());
            }
            return;
        }
        this.logger.error("SMPP Message Rejected : No Restcomm Hosted App Found for inbound number : " + to);
    }

    private boolean redirectToHostedSmsApp(ActorRef self, SmppInboundMessageEntity request, AccountsDao accounts, ApplicationsDao applications, String id) throws IOException {
        String to;
        boolean isFoundHostedApp = false;
        String phone = to = request.getSmppTo();
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        try {
            phone = phoneNumberUtil.format(phoneNumberUtil.parse(to, "US"), PhoneNumberUtil.PhoneNumberFormat.E164);
        }
        catch (Exception e) {
            // empty catch block
        }
        IncomingPhoneNumbersDao numbers = this.storage.getIncomingPhoneNumbersDao();
        IncomingPhoneNumber number = numbers.getIncomingPhoneNumber(phone);
        if (number == null) {
            number = numbers.getIncomingPhoneNumber(to);
        }
        if (number == null) {
            number = numbers.getIncomingPhoneNumber("*");
        }
        try {
            if (number != null) {
                ActorRef interpreter = null;
                URI appUri = number.getSmsUrl();
                SmppInterpreterBuilder builder = new SmppInterpreterBuilder(this.system);
                builder.setSmsService(self);
                builder.setConfiguration(this.configuration);
                builder.setStorage(this.storage);
                builder.setAccount(number.getAccountSid());
                builder.setVersion(number.getApiVersion());
                Sid sid = number.getSmsApplicationSid();
                if (sid != null) {
                    Application application = applications.getApplication(sid);
                    builder.setUrl(UriUtils.resolve((URI)application.getRcmlUrl()));
                } else if (appUri != null) {
                    builder.setUrl(UriUtils.resolve((URI)appUri));
                } else {
                    this.logger.error("the matched number doesn't have SMS application attached, number: " + number.getPhoneNumber());
                    return false;
                }
                builder.setMethod(number.getSmsMethod());
                URI appFallbackUrl = number.getSmsFallbackUrl();
                if (appFallbackUrl != null) {
                    builder.setFallbackUrl(UriUtils.resolve((URI)number.getSmsFallbackUrl()));
                    builder.setFallbackMethod(number.getSmsFallbackMethod());
                }
                interpreter = builder.build();
                ActorRef session = this.session();
                session.tell((Object)request, self);
                StartInterpreter start = new StartInterpreter(session);
                interpreter.tell((Object)start, self);
                isFoundHostedApp = true;
            }
        }
        catch (Exception e) {
            this.logger.error("Error processing inbound SMPP Message. There is no locally hosted Restcomm app for the number :" + e);
        }
        return isFoundHostedApp;
    }

    private SipURI outboundInterface() {
        SipURI result = null;
        List uris = (List)this.servletContext.getAttribute("javax.servlet.sip.outboundInterfaces");
        for (SipURI uri : uris) {
            String transport = uri.getTransportParam();
            if (!"udp".equalsIgnoreCase(transport)) continue;
            result = uri;
        }
        return result;
    }

    private ActorRef session() {
        return this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new SmsSession(SmppMessageHandler.this.configuration, SmppMessageHandler.this.sipFactory, SmppMessageHandler.this.outboundInterface(), SmppMessageHandler.this.storage, SmppMessageHandler.this.monitoringService, SmppMessageHandler.this.servletContext);
            }
        }));
    }

    public void outbound(SmppOutboundMessageEntity request) throws SmppInvalidArgumentException, IOException {
        byte[] textBytes;
        int smppTonNpiValue = Integer.parseInt(SmppService.getSmppTonNpiValue());
        SubmitSm submit0 = new SubmitSm();
        submit0.setSourceAddress(new Address((byte)smppTonNpiValue, (byte)smppTonNpiValue, request.getSmppFrom()));
        submit0.setDestAddress(new Address((byte)smppTonNpiValue, (byte)smppTonNpiValue, request.getSmppTo()));
        if (CharsetUtil.CHARSET_UCS_2 == request.getSmppEncoding()) {
            submit0.setDataCoding((byte)8);
            textBytes = request.getSmppContent().getBytes();
        } else {
            submit0.setDataCoding((byte)0);
            textBytes = CharsetUtil.encode((CharSequence)request.getSmppContent(), (Charset)request.getSmppEncoding());
        }
        submit0.setShortMessage(textBytes);
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Sending SubmitSM for " + request);
            }
            SmppClientOpsThread.getSmppSession().submit(submit0, 10000L);
        }
        catch (RecoverablePduException | SmppChannelException | SmppTimeoutException | UnrecoverablePduException | InterruptedException e) {
            this.logger.error("SMPP message cannot be sent : " + e);
        }
    }
}

