/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.sms.smpp;

import akka.actor.ActorRef;
import com.cloudhopper.commons.charset.Charset;
import com.cloudhopper.commons.charset.CharsetUtil;
import com.cloudhopper.smpp.PduAsyncResponse;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.impl.DefaultSmppClient;
import com.cloudhopper.smpp.impl.DefaultSmppSession;
import com.cloudhopper.smpp.pdu.DeliverSm;
import com.cloudhopper.smpp.pdu.EnquireLink;
import com.cloudhopper.smpp.pdu.EnquireLinkResp;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.type.Address;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.restcomm.connect.sms.smpp.ChangeRequest;
import org.restcomm.connect.sms.smpp.Smpp;
import org.restcomm.connect.sms.smpp.SmppInboundMessageEntity;

public class SmppClientOpsThread
implements Runnable {
    private static final Logger logger = Logger.getLogger(SmppClientOpsThread.class);
    private static final long SCHEDULE_CONNECT_DELAY = 30000L;
    private List<ChangeRequest> pendingChanges = new CopyOnWriteArrayList<ChangeRequest>();
    private Object waitObject = new Object();
    private final DefaultSmppClient clientBootstrap;
    private static SmppSession getSmppSession;
    protected volatile boolean started = true;
    private static int sipPort;
    private final ActorRef smppMessageHandler;

    public SmppClientOpsThread(DefaultSmppClient clientBootstrap, int sipPort, ActorRef smppMessageHandler) {
        this.clientBootstrap = clientBootstrap;
        SmppClientOpsThread.sipPort = sipPort;
        this.smppMessageHandler = smppMessageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStarted(boolean started) {
        this.started = started;
        Object object = this.waitObject;
        synchronized (object) {
            this.waitObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleConnect(Smpp esme) {
        Object object = this.pendingChanges;
        synchronized (object) {
            this.pendingChanges.add(new ChangeRequest(esme, 0, System.currentTimeMillis() + 30000L));
        }
        object = this.waitObject;
        synchronized (object) {
            this.waitObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleEnquireLink(Smpp esme) {
        Object object = this.pendingChanges;
        synchronized (object) {
            this.pendingChanges.add(new ChangeRequest(esme, 2, System.currentTimeMillis() + esme.getEnquireLinkDelay()));
        }
        object = this.waitObject;
        synchronized (object) {
            this.waitObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"SmppClientOpsThread started.");
        }
        while (this.started) {
            try {
                Object object = this.pendingChanges;
                synchronized (object) {
                    for (ChangeRequest change : this.pendingChanges) {
                        switch (change.getType()) {
                            case 0: {
                                if (!change.getSmpp().isStarted()) {
                                    this.pendingChanges.remove(change);
                                    break;
                                }
                                if (change.getExecutionTime() > System.currentTimeMillis()) break;
                                this.pendingChanges.remove(change);
                                this.initiateConnection(change.getSmpp());
                                break;
                            }
                            case 2: {
                                if (!change.getSmpp().isStarted()) {
                                    this.pendingChanges.remove(change);
                                    break;
                                }
                                if (change.getExecutionTime() > System.currentTimeMillis()) break;
                                this.pendingChanges.remove(change);
                                this.enquireLink(change.getSmpp());
                            }
                        }
                    }
                }
                object = this.waitObject;
                synchronized (object) {
                    this.waitObject.wait(5000L);
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)"Error while looping SmppClientOpsThread thread", (Throwable)e);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"SmppClientOpsThread for stopped.");
        }
    }

    private void enquireLink(Smpp esme) {
        DefaultSmppSession smppSession = esme.getSmppSession();
        if (!esme.isStarted()) {
            return;
        }
        if (smppSession != null && smppSession.isBound()) {
            try {
                EnquireLinkResp enquireLinkResp1 = smppSession.enquireLink(new EnquireLink(), 10000L);
                this.scheduleEnquireLink(esme);
                return;
            }
            catch (RecoverablePduException e) {
                logger.warn((Object)String.format("RecoverablePduException while sending the ENQURE_LINK for ESME SystemId=%s", esme.getSystemId()), (Throwable)e);
                this.scheduleEnquireLink(esme);
                return;
            }
            catch (Exception e) {
                logger.error((Object)String.format("Exception while trying to send ENQUIRE_LINK for ESME SystemId=%s", esme.getSystemId()), (Throwable)e);
                smppSession.close();
                this.scheduleConnect(esme);
            }
        } else {
            logger.warn((Object)String.format("Sending ENQURE_LINK fialed for ESME SystemId=%s as SmppSession is =%s !", esme.getSystemId(), smppSession == null ? null : smppSession.getStateName()));
            if (smppSession != null) {
                smppSession.close();
            }
            this.scheduleConnect(esme);
        }
    }

    private void initiateConnection(Smpp esme) {
        if (!esme.isStarted()) {
            return;
        }
        DefaultSmppSession smppSession = esme.getSmppSession();
        if (smppSession != null && smppSession.isBound() || smppSession != null && smppSession.isBinding()) {
            return;
        }
        SmppSession session0 = null;
        try {
            SmppSessionConfiguration config0 = new SmppSessionConfiguration();
            config0.setWindowSize(esme.getWindowSize());
            config0.setName(esme.getSystemId());
            config0.setType(esme.getSmppBindType());
            config0.setSystemType(esme.getSystemType());
            config0.setHost(esme.getPeerIp());
            config0.setPort(esme.getPeerPort());
            config0.setConnectTimeout(esme.getConnectTimeout());
            config0.setSystemId(esme.getSystemId());
            config0.setPassword(esme.getPassword());
            config0.getLoggingOptions().setLogBytes(false);
            config0.getLoggingOptions().setLogPdu(false);
            config0.setRequestExpiryTimeout(esme.getRequestExpiryTimeout());
            config0.setWindowMonitorInterval(esme.getWindowMonitorInterval());
            config0.setCountersEnabled(esme.isCountersEnabled());
            Address address = esme.getAddress();
            config0.setAddressRange(address);
            ClientSmppSessionHandler sessionHandler = new ClientSmppSessionHandler(esme);
            getSmppSession = session0 = this.clientBootstrap.bind(config0, (SmppSessionHandler)sessionHandler);
            esme.setSmppSession((DefaultSmppSession)session0);
            this.scheduleEnquireLink(esme);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Exception when trying to bind client SMPP connection for ESME systemId=%s", esme.getSystemId()), (Throwable)e);
            if (session0 != null) {
                session0.close();
            }
            this.scheduleConnect(esme);
        }
    }

    public static SmppSession getSmppSession() {
        return getSmppSession;
    }

    public void sendSmppMessageToRestcomm(String smppMessage, String smppTo, String smppFrom, Charset charset) throws IOException, ServletException {
        SmppSession smppSession = SmppClientOpsThread.getSmppSession();
        String to = smppTo;
        String from = smppFrom;
        String inboundMessage = smppMessage;
        SmppInboundMessageEntity smppInboundMessage = new SmppInboundMessageEntity(to, from, inboundMessage, charset);
        this.smppMessageHandler.tell((Object)smppInboundMessage, null);
    }

    protected class ClientSmppSessionHandler
    implements SmppSessionHandler {
        private Smpp esme = null;

        public ClientSmppSessionHandler(Smpp esme) {
            this.esme = esme;
        }

        public String lookupResultMessage(int arg0) {
            return null;
        }

        public String lookupTlvTagName(short arg0) {
            return null;
        }

        public void fireChannelUnexpectedlyClosed() {
            logger.error((Object)("ChannelUnexpectedlyClosed for Smpp " + this.esme.getName() + " Closing Smpp session and restrting BIND process again"));
            this.esme.getSmppSession().close();
            SmppClientOpsThread.this.scheduleConnect(this.esme);
        }

        public void fireExpectedPduResponseReceived(PduAsyncResponse pduAsyncResponse) {
            logger.warn((Object)("ExpectedPduResponseReceived received for Smpp " + this.esme.getName() + " PduAsyncResponse=" + pduAsyncResponse));
        }

        public void firePduRequestExpired(PduRequest pduRequest) {
            logger.warn((Object)("PduRequestExpired for Smpp " + this.esme.getName() + " PduRequest=" + pduRequest));
        }

        public PduResponse firePduRequestReceived(PduRequest pduRequest) {
            PduResponse response = pduRequest.createResponse();
            if (!pduRequest.toString().toLowerCase().contains("enquire_link")) {
                DeliverSm deliverSm = (DeliverSm)pduRequest;
                try {
                    String decodedPduMessage = CharsetUtil.CHARSET_MODIFIED_UTF8.decode(deliverSm.getShortMessage());
                    String destSmppAddress = deliverSm.getDestAddress().getAddress();
                    String sourceSmppAddress = deliverSm.getSourceAddress().getAddress();
                    Charset charset = 8 == deliverSm.getDataCoding() ? CharsetUtil.CHARSET_UCS_2 : CharsetUtil.CHARSET_GSM;
                    try {
                        SmppClientOpsThread.this.sendSmppMessageToRestcomm(decodedPduMessage, destSmppAddress, sourceSmppAddress, charset);
                    }
                    catch (IOException | ServletException e) {
                        logger.error((Object)("Exception while trying to dispatch incoming SMPP message to Restcomm: " + e));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Exception while trying to process incoming SMPP message to Restcomm: " + e));
                }
            }
            return response;
        }

        public void fireRecoverablePduException(RecoverablePduException e) {
            logger.warn((Object)("RecoverablePduException received for Smpp " + this.esme.getName()), (Throwable)e);
        }

        public void fireUnexpectedPduResponseReceived(PduResponse pduResponse) {
            logger.warn((Object)("UnexpectedPduResponseReceived received for Smpp " + this.esme.getName() + " PduResponse=" + pduResponse));
        }

        public void fireUnknownThrowable(Throwable e) {
            logger.error((Object)("UnknownThrowable for Smpp " + this.esme.getName() + " Closing Smpp session and restarting BIND process again"), e);
            this.esme.getSmppSession().close();
            SmppClientOpsThread.this.scheduleConnect(this.esme);
        }

        public void fireUnrecoverablePduException(UnrecoverablePduException e) {
            logger.error((Object)("UnrecoverablePduException for Smpp " + this.esme.getName() + " Closing Smpp session and restrting BIND process again"), (Throwable)e);
            this.esme.getSmppSession().close();
            SmppClientOpsThread.this.scheduleConnect(this.esme);
        }
    }
}

