/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.sms.smpp;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.impl.DefaultSmppClient;
import com.cloudhopper.smpp.type.Address;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipURI;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.sms.smpp.Smpp;
import org.restcomm.connect.sms.smpp.SmppClientOpsThread;

public final class SmppService
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final ActorSystem system;
    private final ActorRef smppMessageHandler;
    private final Configuration configuration;
    private boolean authenticateUsers = true;
    private final ServletConfig servletConfig;
    private final SipFactory sipFactory;
    private final DaoManager storage;
    private final ServletContext servletContext;
    private static String smppActivated;
    static final int ERROR_NOTIFICATION = 0;
    static final int WARNING_NOTIFICATION = 1;
    private static String smppSourceAddressMap;
    private static String smppDestinationAddressMap;
    private static String smppTonNpiValue;
    private ThreadPoolExecutor executor;
    private ScheduledThreadPoolExecutor monitorExecutor;
    private DefaultSmppClient clientBootstrap = null;
    private SmppClientOpsThread smppClientOpsThread = null;
    private ArrayList<Smpp> smppList = new ArrayList();

    public SmppService(ActorSystem system, Configuration configuration, SipFactory factory, DaoManager storage, ServletContext servletContext, ActorRef smppMessageHandler) {
        this.system = system;
        this.smppMessageHandler = smppMessageHandler;
        this.configuration = configuration;
        Configuration runtime = configuration.subset("runtime-settings");
        this.authenticateUsers = runtime.getBoolean("authenticate");
        this.servletConfig = (ServletConfig)configuration.getProperty(ServletConfig.class.getName());
        this.sipFactory = factory;
        this.storage = storage;
        this.servletContext = servletContext;
        Configuration config = this.configuration.subset("smpp");
        smppActivated = config.getString("[@activateSmppConnection]");
        smppSourceAddressMap = config.getString("connections.connection[@sourceAddressMap]");
        smppDestinationAddressMap = config.getString("connections.connection[@destinationAddressMap]");
        smppTonNpiValue = config.getString("connections.connection[@tonNpiValue]");
        this.initializeSmppConnections();
    }

    public static String getSmppTonNpiValue() {
        return smppTonNpiValue;
    }

    public void onReceive(Object message) throws Exception {
    }

    private void initializeSmppConnections() {
        Configuration smppConfiguration = this.configuration.subset("smpp");
        List smppConnections = smppConfiguration.getList("connections.connection.name");
        int smppConnecsSize = smppConnections.size();
        if (smppConnecsSize == 0) {
            this.logger.warning("No SMPP Connections defined!");
            return;
        }
        for (int count = 0; count < smppConnecsSize; ++count) {
            String name = smppConfiguration.getString("connections.connection(" + count + ").name");
            String systemId = smppConfiguration.getString("connections.connection(" + count + ").systemid");
            String peerIp = smppConfiguration.getString("connections.connection(" + count + ").peerip");
            int peerPort = smppConfiguration.getInt("connections.connection(" + count + ").peerport");
            SmppBindType bindtype = SmppBindType.valueOf((String)smppConfiguration.getString("connections.connection(" + count + ").bindtype"));
            if (bindtype == null) {
                this.logger.warning("Bindtype for SMPP name=" + name + " is not specified. Using default TRANSCEIVER");
            }
            String password = smppConfiguration.getString("connections.connection(" + count + ").password");
            String systemType = smppConfiguration.getString("connections.connection(" + count + ").systemtype");
            byte interfaceVersion = smppConfiguration.getByte("connections.connection(" + count + ").interfaceversion");
            byte ton = smppConfiguration.getByte("connections.connection(" + count + ").ton");
            byte npi = smppConfiguration.getByte("connections.connection(" + count + ").npi");
            String range = smppConfiguration.getString("connections.connection(" + count + ").range");
            Address address = null;
            if (ton != -1 && npi != -1 && range != null) {
                address = new Address(ton, npi, range);
            }
            int windowSize = smppConfiguration.getInt("connections.connection(" + count + ").windowsize");
            long windowWaitTimeout = smppConfiguration.getLong("connections.connection(" + count + ").windowwaittimeout");
            long connectTimeout = smppConfiguration.getLong("connections.connection(" + count + ").connecttimeout");
            long requestExpiryTimeout = smppConfiguration.getLong("connections.connection(" + count + ").requestexpirytimeout");
            long windowMonitorInterval = smppConfiguration.getLong("connections.connection(" + count + ").windowmonitorinterval");
            boolean logBytes = smppConfiguration.getBoolean("connections.connection(" + count + ").logbytes");
            boolean countersEnabled = smppConfiguration.getBoolean("connections.connection(" + count + ").countersenabled");
            long enquireLinkDelay = smppConfiguration.getLong("connections.connection(" + count + ").enquirelinkdelay");
            Smpp smpp = new Smpp(name, systemId, peerIp, peerPort, bindtype, password, systemType, interfaceVersion, address, connectTimeout, windowSize, windowWaitTimeout, requestExpiryTimeout, windowMonitorInterval, countersEnabled, logBytes, enquireLinkDelay);
            this.smppList.add(smpp);
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info("creating new SMPP connection " + smpp);
        }
        this.executor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        this.monitorExecutor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, new ThreadFactory(){
            private AtomicInteger sequence = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("SmppServer-SessionWindowMonitorPool-" + this.sequence.getAndIncrement());
                return t;
            }
        });
        this.clientBootstrap = new DefaultSmppClient((ExecutorService)this.executor, 25, (ScheduledExecutorService)this.monitorExecutor);
        this.smppClientOpsThread = new SmppClientOpsThread(this.clientBootstrap, this.outboundInterface("udp").getPort(), this.smppMessageHandler);
        new Thread(this.smppClientOpsThread).start();
        for (Smpp smpp : this.smppList) {
            this.smppClientOpsThread.scheduleConnect(smpp);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("SMPP Service started");
        }
    }

    private SipURI outboundInterface(String transport) {
        SipURI result = null;
        List uris = (List)this.servletContext.getAttribute("javax.servlet.sip.outboundInterfaces");
        for (SipURI uri : uris) {
            String interfaceTransport = uri.getTransportParam();
            if (!transport.equalsIgnoreCase(interfaceTransport)) continue;
            result = uri;
        }
        return result;
    }
}

