/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.sms.smpp;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import akka.pattern.Patterns;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.sms.smpp.SmppInterpreter;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;

public class SmppInterpreterBuilder {
    private static Logger logger = Logger.getLogger(SmppInterpreterBuilder.class);
    private final ActorRef supervisor;
    private Configuration configuration;
    private ActorRef service;
    private DaoManager storage;
    private Sid accountId;
    private String version;
    private URI url;
    private String method;
    private URI fallbackUrl;
    private String fallbackMethod;

    public SmppInterpreterBuilder(ActorRef supervisor) {
        this.supervisor = supervisor;
    }

    public ActorRef build() {
        Props props = new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new SmppInterpreter(SmppInterpreterBuilder.this.supervisor, SmppInterpreterBuilder.this.service, SmppInterpreterBuilder.this.configuration, SmppInterpreterBuilder.this.storage, SmppInterpreterBuilder.this.accountId, SmppInterpreterBuilder.this.version, SmppInterpreterBuilder.this.url, SmppInterpreterBuilder.this.method, SmppInterpreterBuilder.this.fallbackUrl, SmppInterpreterBuilder.this.fallbackMethod);
            }
        });
        ActorRef smppInterpreter = null;
        try {
            smppInterpreter = (ActorRef)Await.result((Awaitable)Patterns.ask((ActorRef)this.supervisor, (Object)props, (long)500L), (Duration)Duration.create((long)500L, (TimeUnit)TimeUnit.MILLISECONDS));
        }
        catch (Exception e) {
            logger.error((Object)("Problem during creation of actor: " + e));
        }
        return smppInterpreter;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setSmsService(ActorRef service) {
        this.service = service;
    }

    public void setStorage(DaoManager storage) {
        this.storage = storage;
    }

    public void setAccount(Sid accountId) {
        this.accountId = accountId;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setFallbackUrl(URI fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
    }

    public void setFallbackMethod(String fallbackMethod) {
        this.fallbackMethod = fallbackMethod;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

