/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.sms.smpp;

import akka.actor.ActorRef;
import java.net.URI;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoManager;

public final class SmppInterpreterParams {
    private Configuration configuration;
    private ActorRef smsService;
    private DaoManager storage;
    private Sid accountId;
    private String version;
    private URI url;
    private String method;
    private URI fallbackUrl;
    private String fallbackMethod;

    private SmppInterpreterParams(Configuration configuration, ActorRef smsService, DaoManager storage, Sid accountId, String version, URI url, String method, URI fallbackUrl, String fallbackMethod) {
        this.configuration = configuration;
        this.smsService = smsService;
        this.storage = storage;
        this.accountId = accountId;
        this.version = version;
        this.url = url;
        this.method = method;
        this.fallbackUrl = fallbackUrl;
        this.fallbackMethod = fallbackMethod;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ActorRef getSmsService() {
        return this.smsService;
    }

    public DaoManager getStorage() {
        return this.storage;
    }

    public Sid getAccountId() {
        return this.accountId;
    }

    public String getVersion() {
        return this.version;
    }

    public URI getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public URI getFallbackUrl() {
        return this.fallbackUrl;
    }

    public String getFallbackMethod() {
        return this.fallbackMethod;
    }

    public static final class Builder {
        private Configuration configuration;
        private ActorRef smsService;
        private DaoManager storage;
        private Sid accountId;
        private String version;
        private URI url;
        private String method;
        private URI fallbackUrl;
        private String fallbackMethod;

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setSmsService(ActorRef smsService) {
            this.smsService = smsService;
            return this;
        }

        public Builder setStorage(DaoManager storage) {
            this.storage = storage;
            return this;
        }

        public Builder setAccountId(Sid accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setUrl(URI url) {
            this.url = url;
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setFallbackUrl(URI fallbackUrl) {
            this.fallbackUrl = fallbackUrl;
            return this;
        }

        public Builder setFallbackMethod(String fallbackMethod) {
            this.fallbackMethod = fallbackMethod;
            return this;
        }

        public SmppInterpreterParams build() {
            return new SmppInterpreterParams(this.configuration, this.smsService, this.storage, this.accountId, this.version, this.url, this.method, this.fallbackUrl, this.fallbackMethod);
        }
    }
}

