/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.sms;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import com.cloudhopper.commons.charset.Charset;
import com.cloudhopper.commons.charset.CharsetUtil;
import com.cloudhopper.commons.util.ByteArrayUtil;
import com.cloudhopper.smpp.tlv.Tlv;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.faulttolerance.RestcommUntypedActor;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.commons.patterns.Observing;
import org.restcomm.connect.commons.patterns.StopObserving;
import org.restcomm.connect.commons.push.PushNotificationServerHelper;
import org.restcomm.connect.dao.ClientsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.RegistrationsDao;
import org.restcomm.connect.dao.entities.Client;
import org.restcomm.connect.dao.entities.Registration;
import org.restcomm.connect.sms.api.GetLastSmsRequest;
import org.restcomm.connect.sms.api.SmsSessionAttribute;
import org.restcomm.connect.sms.api.SmsSessionInfo;
import org.restcomm.connect.sms.api.SmsSessionRequest;
import org.restcomm.connect.sms.api.SmsSessionResponse;
import org.restcomm.connect.sms.smpp.SmppClientOpsThread;
import org.restcomm.connect.sms.smpp.SmppInboundMessageEntity;
import org.restcomm.connect.sms.smpp.SmppMessageHandler;
import org.restcomm.connect.sms.smpp.SmppOutboundMessageEntity;
import org.restcomm.connect.telephony.api.TextMessage;
import org.restcomm.smpp.parameter.TlvSet;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;

public final class SmsSession
extends RestcommUntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final ActorSystem system;
    private final Configuration smsConfiguration;
    private final Configuration configuration;
    private final SipFactory factory;
    private final List<ActorRef> observers;
    private final SipURI transport;
    private final Map<String, Object> attributes;
    private final PushNotificationServerHelper pushNotificationServerHelper;
    private ConcurrentHashMap<String, String> customRequestHeaderMap = new ConcurrentHashMap();
    private TlvSet tlvSet;
    private final DaoManager storage;
    private SmsSessionRequest initial;
    private SmsSessionRequest last;
    private final boolean smppActivated;
    private String externalIP;
    private final ServletContext servletContext;
    private ActorRef smppMessageHandler;
    private final ActorRef monitoringService;
    private final Sid fromOrganizationSid;

    public SmsSession(Configuration configuration, SipFactory factory, SipURI transport, DaoManager storage, ActorRef monitoringService, ServletContext servletContext, Sid fromOrganizationSid) {
        this.system = this.getContext().system();
        this.configuration = configuration;
        this.smsConfiguration = configuration.subset("sms-aggregator");
        this.factory = factory;
        this.observers = new ArrayList<ActorRef>();
        this.transport = transport;
        this.attributes = new HashMap<String, Object>();
        this.storage = storage;
        this.monitoringService = monitoringService;
        this.servletContext = servletContext;
        this.smppActivated = Boolean.parseBoolean(this.configuration.subset("smpp").getString("[@activateSmppConnection]", "false"));
        if (this.smppActivated) {
            this.smppMessageHandler = (ActorRef)servletContext.getAttribute(SmppMessageHandler.class.getName());
        }
        String defaultHost = transport.getHost();
        this.externalIP = this.configuration.subset("runtime-settings").getString("external-ip");
        if (this.externalIP == null || this.externalIP.isEmpty() || this.externalIP.equals("")) {
            this.externalIP = defaultHost;
        }
        this.fromOrganizationSid = fromOrganizationSid;
        this.tlvSet = new TlvSet();
        if (!this.configuration.subset("outbound-sms").isEmpty()) {
            try {
                String valStr = this.configuration.subset("outbound-sms").getString("destination_network_id");
                this.tlvSet.addOptionalParameter(new Tlv(1550, ByteArrayUtil.toByteArray((int)Integer.parseInt(valStr))));
            }
            catch (Exception e) {
                this.logger.error("Error while parsing tlv configuration " + e);
            }
        }
        this.pushNotificationServerHelper = new PushNotificationServerHelper(this.system, configuration);
    }

    private void inbound(Object message) throws IOException {
        block7: {
            block6: {
                if (!(message instanceof SipServletRequest)) break block6;
                SipServletRequest request = (SipServletRequest)message;
                SipURI uri = (SipURI)request.getFrom().getURI();
                String from = uri.getUser();
                uri = (SipURI)request.getTo().getURI();
                String to = uri.getUser();
                String body = null;
                if (request.getContentLength() > 0) {
                    body = new String(request.getRawContent());
                }
                Iterator headerIt = request.getHeaderNames();
                while (headerIt.hasNext()) {
                    String headerName = (String)headerIt.next();
                    if (!headerName.startsWith("X-")) continue;
                    this.customRequestHeaderMap.put(headerName, request.getHeader(headerName));
                }
                this.last = new SmsSessionRequest(from, to, body, this.tlvSet, this.customRequestHeaderMap);
                if (this.initial == null) {
                    this.initial = this.last;
                }
                ActorRef self = this.self();
                for (ActorRef observer : this.observers) {
                    observer.tell((Object)this.last, self);
                }
                break block7;
            }
            if (!(message instanceof SmppInboundMessageEntity)) break block7;
            SmppInboundMessageEntity request = (SmppInboundMessageEntity)message;
            SmsSessionRequest.Encoding encoding = request.getSmppEncoding().equals(CharsetUtil.CHARSET_UCS_2) ? SmsSessionRequest.Encoding.UCS_2 : SmsSessionRequest.Encoding.GSM;
            this.last = new SmsSessionRequest(request.getSmppFrom(), request.getSmppTo(), request.getSmppContent(), encoding, request.getTlvSet(), null);
            if (this.initial == null) {
                this.initial = this.last;
            }
            for (ActorRef observer : this.observers) {
                observer.tell((Object)this.last, this.self());
            }
        }
    }

    private SmsSessionInfo info() {
        String from = this.initial.from();
        String to = this.initial.to();
        ImmutableMap attributes = ImmutableMap.copyOf(this.attributes);
        return new SmsSessionInfo(from, to, (Map)attributes);
    }

    private void observe(Object message) {
        ActorRef self = this.self();
        Observe request = (Observe)message;
        ActorRef observer = request.observer();
        if (observer != null) {
            this.observers.add(observer);
            observer.tell((Object)new Observing(self), self);
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (Observe.class.equals(klass)) {
            this.observe(message);
        } else if (StopObserving.class.equals(klass)) {
            this.stopObserving(message);
        } else if (GetLastSmsRequest.class.equals(klass)) {
            sender.tell((Object)this.last, self);
        } else if (SmsSessionAttribute.class.equals(klass)) {
            SmsSessionAttribute attribute = (SmsSessionAttribute)message;
            this.attributes.put(attribute.name(), attribute.value());
        } else if (SmsSessionRequest.class.equals(klass)) {
            this.outbound(message);
        } else if (message instanceof SipServletRequest) {
            this.inbound(message);
        } else if (message instanceof SipServletResponse) {
            this.response(message);
        } else if (message instanceof SmppInboundMessageEntity) {
            this.inbound(message);
        }
    }

    private void response(Object message) {
        SipServletResponse response = (SipServletResponse)message;
        int status = response.getStatus();
        SmsSessionInfo info = this.info();
        SmsSessionResponse result = null;
        result = 202 == status || 200 == status ? new SmsSessionResponse(info, true) : new SmsSessionResponse(info, false);
        ActorRef self = this.self();
        for (ActorRef observer : this.observers) {
            observer.tell((Object)result, self);
        }
    }

    private void outbound(final Object message) {
        Charset charset;
        this.last = (SmsSessionRequest)message;
        if (this.initial == null) {
            this.initial = this.last;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("SMS encoding:  " + this.last.encoding());
        }
        switch (this.last.encoding()) {
            case GSM: {
                charset = CharsetUtil.CHARSET_GSM;
                break;
            }
            case UCS_2: {
                charset = CharsetUtil.CHARSET_UCS_2;
                break;
            }
            case UTF_8: {
                charset = CharsetUtil.CHARSET_UTF_8;
                break;
            }
            default: {
                charset = CharsetUtil.CHARSET_GSM;
            }
        }
        this.monitoringService.tell((Object)new TextMessage(this.last.from(), this.last.to(), TextMessage.SmsState.OUTBOUND), this.self());
        ClientsDao clients = this.storage.getClientsDao();
        String to = this.last.to().toLowerCase().startsWith("client") ? this.last.to().replaceAll("client:", "") : this.last.to();
        final Client toClient = clients.getClient(to, this.fromOrganizationSid);
        long delay = 0L;
        if (toClient == null) {
            if (this.smppActivated) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Destination is not a local registered client, therefore, sending through SMPP to:  " + this.last.to());
                }
                if (this.sendUsingSmpp(this.last.from(), this.last.to(), this.last.body(), this.tlvSet, charset)) {
                    return;
                }
            }
        } else {
            delay = this.pushNotificationServerHelper.sendPushNotificationIfNeeded(toClient.getPushClientIdentity());
        }
        this.system.scheduler().scheduleOnce(Duration.create((long)delay, (TimeUnit)TimeUnit.MILLISECONDS), new Runnable(){

            @Override
            public void run() {
                SmsSession.this.sendUsingSip(toClient, (SmsSessionRequest)message);
            }
        }, (ExecutionContext)this.system.dispatcher());
    }

    private boolean sendUsingSmpp(String from, String to, String body, Charset encoding) {
        return this.sendUsingSmpp(from, to, body, null, encoding);
    }

    private boolean sendUsingSmpp(String from, String to, String body, TlvSet tlvSet, Charset encoding) {
        if (SmppClientOpsThread.getSmppSession() != null && SmppClientOpsThread.getSmppSession().isBound() && this.smppMessageHandler != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("SMPP session is available and connected, outbound message will be forwarded to :  " + to);
                this.logger.info("Encoding:  " + encoding);
            }
            try {
                SmppOutboundMessageEntity sms = new SmppOutboundMessageEntity(to, from, body, encoding, tlvSet);
                this.smppMessageHandler.tell((Object)sms, null);
            }
            catch (Exception exception) {
                this.logger.error("There was an error sending SMS to SMPP endpoint : " + exception);
            }
            return true;
        }
        return false;
    }

    private void sendUsingSip(Client toClient, SmsSessionRequest request) {
        Registration toClientRegistration = null;
        if (toClient != null) {
            RegistrationsDao registrations = this.storage.getRegistrationsDao();
            toClientRegistration = registrations.getRegistration(toClient.getLogin(), this.fromOrganizationSid);
        }
        SipApplicationSession application = this.factory.createApplicationSession();
        StringBuilder buffer = new StringBuilder();
        buffer.append("sip:").append(request.from()).append("@").append(this.externalIP + ":" + this.transport.getPort());
        String sender = buffer.toString();
        buffer = new StringBuilder();
        if (toClientRegistration != null) {
            buffer.append(toClientRegistration.getLocation());
        } else {
            String service = this.smsConfiguration.getString("outbound-endpoint");
            if (service == null) {
                return;
            }
            buffer.append("sip:");
            String prefix = this.smsConfiguration.getString("outbound-prefix");
            if (prefix != null) {
                buffer.append(prefix);
            }
            buffer.append(request.to()).append("@").append(service);
        }
        String recipient = buffer.toString();
        try {
            application.setAttribute(SmsSession.class.getName(), (Object)this.self());
            if (request.getOrigRequest() != null) {
                application.setAttribute(SipServletRequest.class.getName(), (Object)request.getOrigRequest());
            }
            SipServletRequest sms = this.factory.createRequest(application, "MESSAGE", sender, recipient);
            SipURI uri = (SipURI)this.factory.createURI(recipient);
            sms.pushRoute(uri);
            sms.setRequestURI((URI)uri);
            sms.setContent((Object)request.body(), "text/plain");
            SipSession session = sms.getSession();
            session.setHandler("SmsService");
            ConcurrentHashMap headers = request.headers();
            if (headers != null) {
                for (Map.Entry header : headers.entrySet()) {
                    sms.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            sms.send();
        }
        catch (Exception exception) {
            SmsSessionInfo info = this.info();
            SmsSessionResponse error = new SmsSessionResponse(info, false);
            for (ActorRef observer : this.observers) {
                observer.tell((Object)error, this.self());
            }
            this.logger.error(exception.getMessage(), (Object)exception);
        }
    }

    private void stopObserving(Object message) {
        StopObserving request = (StopObserving)message;
        ActorRef observer = request.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }
}

