/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.sms;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Currency;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.commons.configuration.sets.RcmlserverConfigurationSet;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.faulttolerance.RestcommUntypedActor;
import org.restcomm.connect.commons.push.PushNotificationServerHelper;
import org.restcomm.connect.commons.util.UriUtils;
import org.restcomm.connect.dao.AccountsDao;
import org.restcomm.connect.dao.ApplicationsDao;
import org.restcomm.connect.dao.ClientsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.NotificationsDao;
import org.restcomm.connect.dao.OrganizationsDao;
import org.restcomm.connect.dao.SmsMessagesDao;
import org.restcomm.connect.dao.common.OrganizationUtil;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.Application;
import org.restcomm.connect.dao.entities.Client;
import org.restcomm.connect.dao.entities.IncomingPhoneNumber;
import org.restcomm.connect.dao.entities.Notification;
import org.restcomm.connect.dao.entities.SmsMessage;
import org.restcomm.connect.extension.api.ExtensionResponse;
import org.restcomm.connect.extension.api.ExtensionType;
import org.restcomm.connect.extension.api.IExtensionRequest;
import org.restcomm.connect.extension.api.RestcommExtensionException;
import org.restcomm.connect.extension.api.RestcommExtensionGeneric;
import org.restcomm.connect.extension.controller.ExtensionController;
import org.restcomm.connect.http.client.rcmlserver.resolver.RcmlserverResolver;
import org.restcomm.connect.interpreter.NumberSelectorService;
import org.restcomm.connect.interpreter.SIPOrganizationUtil;
import org.restcomm.connect.interpreter.SmsInterpreter;
import org.restcomm.connect.interpreter.SmsInterpreterParams;
import org.restcomm.connect.interpreter.StartInterpreter;
import org.restcomm.connect.monitoringservice.MonitoringService;
import org.restcomm.connect.sms.SmsSession;
import org.restcomm.connect.sms.api.CreateSmsSession;
import org.restcomm.connect.sms.api.DestroySmsSession;
import org.restcomm.connect.sms.api.SmsServiceResponse;
import org.restcomm.connect.sms.api.SmsSessionAttribute;
import org.restcomm.connect.sms.api.SmsSessionRequest;
import org.restcomm.connect.telephony.api.FeatureAccessRequest;
import org.restcomm.connect.telephony.api.TextMessage;
import org.restcomm.connect.telephony.api.util.B2BUAHelper;
import org.restcomm.connect.telephony.api.util.CallControlHelper;
import org.restcomm.smpp.parameter.TlvSet;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;

public final class SmsService
extends RestcommUntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    static final int ACCOUNT_NOT_ACTIVE_FAILURE_RESPONSE_CODE = 403;
    private final ActorSystem system = this.context().system();
    private final Configuration configuration;
    private boolean authenticateUsers = true;
    private final ServletConfig servletConfig;
    private final SipFactory sipFactory;
    private final DaoManager storage;
    private final ServletContext servletContext;
    static final int ERROR_NOTIFICATION = 0;
    static final int WARNING_NOTIFICATION = 1;
    private final ActorRef monitoringService;
    private final PushNotificationServerHelper pushNotificationServerHelper;
    private boolean useTo = true;
    private boolean patchForNatB2BUASessions;
    List<RestcommExtensionGeneric> extensions;
    private final NumberSelectorService numberSelector;

    public SmsService(Configuration configuration, SipFactory factory, DaoManager storage, ServletContext servletContext) {
        this.configuration = configuration;
        Configuration runtime = configuration.subset("runtime-settings");
        this.authenticateUsers = runtime.getBoolean("authenticate");
        this.servletConfig = (ServletConfig)configuration.getProperty(ServletConfig.class.getName());
        this.sipFactory = factory;
        this.storage = storage;
        this.servletContext = servletContext;
        this.monitoringService = (ActorRef)servletContext.getAttribute(MonitoringService.class.getName());
        this.numberSelector = (NumberSelectorService)servletContext.getAttribute(NumberSelectorService.class.getName());
        this.pushNotificationServerHelper = new PushNotificationServerHelper(this.system, configuration);
        this.patchForNatB2BUASessions = runtime.getBoolean("patch-for-nat-b2bua-sessions", true);
        this.extensions = ExtensionController.getInstance().getExtensions(ExtensionType.SmsService);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("SmsService extensions: " + (this.extensions != null ? Integer.valueOf(this.extensions.size()) : "0"));
        }
    }

    private void message(Object message) throws IOException {
        Account toAccount;
        Account numAccount;
        final ActorRef self = this.self();
        final SipServletRequest request = (SipServletRequest)message;
        if (request.getContentLength() == 0 || !request.getContentType().contains("text/plain")) {
            SipServletResponse reject = request.createResponse(406);
            reject.addHeader("Reason", "Content Type is not text plain");
            reject.send();
            return;
        }
        SipURI fromURI = (SipURI)request.getFrom().getURI();
        String fromUser = fromURI.getUser();
        ClientsDao clients = this.storage.getClientsDao();
        SipURI ruri = (SipURI)request.getRequestURI();
        String to = ruri.getUser();
        Sid destinationOrganizationSid = SIPOrganizationUtil.searchOrganizationBySIPRequest((OrganizationsDao)this.storage.getOrganizationsDao(), (SipServletRequest)request);
        Sid sourceOrganizationSid = OrganizationUtil.getOrganizationSidBySipURIHost((DaoManager)this.storage, (SipURI)fromURI);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sourceOrganizationSid: " + sourceOrganizationSid);
            this.logger.debug("destinationOrganizationSid: " + destinationOrganizationSid);
        }
        if (sourceOrganizationSid == null) {
            this.logger.error("Null Organization: fromUri: " + fromURI);
        }
        final Client client = clients.getClient(fromUser, sourceOrganizationSid);
        String toUser = CallControlHelper.getUserSipId((SipServletRequest)request, (boolean)this.useTo);
        final Client toClient = clients.getClient(toUser, destinationOrganizationSid);
        AccountsDao accounts = this.storage.getAccountsDao();
        ApplicationsDao applications = this.storage.getApplicationsDao();
        IncomingPhoneNumber number = this.getIncomingPhoneNumber(to, sourceOrganizationSid, destinationOrganizationSid);
        if (number != null && !(numAccount = accounts.getAccount(number.getAccountSid())).getStatus().equals((Object)Account.Status.ACTIVE)) {
            SipServletResponse response = request.createResponse(403, "Account is not ACTIVE");
            response.send();
            String msg = String.format("Restcomm rejects this SMS because number's %s account %s is not ACTIVE, current state %s", number.getPhoneNumber(), numAccount.getSid(), numAccount.getStatus());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(msg);
            }
            this.sendNotification(msg, 11005, "error", true);
            return;
        }
        if (client != null) {
            Account clientAccount = accounts.getAccount(client.getAccountSid());
            if (!clientAccount.getStatus().equals((Object)Account.Status.ACTIVE)) {
                SipServletResponse response = request.createResponse(403, "Account is not ACTIVE");
                response.send();
                String msg = String.format("Restcomm rejects this SMS because client's %s account %s is not ACTIVE, current state %s", client.getFriendlyName(), clientAccount.getSid(), clientAccount.getStatus());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(msg);
                }
                this.sendNotification(msg, 11005, "error", true);
                return;
            }
            if (this.authenticateUsers && !CallControlHelper.checkAuthentication((SipServletRequest)request, (DaoManager)this.storage, (Sid)sourceOrganizationSid)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Client " + client.getLogin() + " failed to authenticate");
                }
                return;
            }
        }
        if (toClient != null && !(toAccount = accounts.getAccount(toClient.getAccountSid())).getStatus().equals((Object)Account.Status.ACTIVE)) {
            SipServletResponse response = request.createResponse(403, "Account is not ACTIVE");
            response.send();
            String msg = String.format("Restcomm rejects this SMS because client's %s account %s is not ACTIVE, current state %s", client.getFriendlyName(), toAccount.getSid(), toAccount.getStatus());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(msg);
            }
            this.sendNotification(msg, 11005, "error", true);
            return;
        }
        if (this.redirectToHostedSmsApp(request, applications, number)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Message to :" + toUser + " matched to one of the hosted applications");
            }
            SipServletResponse messageAccepted = request.createResponse(202);
            messageAccepted.send();
            this.monitoringService.tell((Object)new TextMessage(((SipURI)request.getFrom().getURI()).getUser(), ((SipURI)request.getTo().getURI()).getUser(), TextMessage.SmsState.INBOUND_TO_APP), self);
            return;
        }
        if (client != null) {
            if (toClient != null) {
                long delay = this.pushNotificationServerHelper.sendPushNotificationIfNeeded(toClient.getPushClientIdentity());
                if (delay > 0L) {
                    SipServletResponse trying = request.createResponse(100);
                    trying.send();
                }
                this.system.scheduler().scheduleOnce(Duration.create((long)delay, (TimeUnit)TimeUnit.MILLISECONDS), new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (B2BUAHelper.redirectToB2BUA((ActorSystem)SmsService.this.system, (SipServletRequest)request, (Client)client, (Client)toClient, (DaoManager)SmsService.this.storage, (SipFactory)SmsService.this.sipFactory, (boolean)SmsService.this.patchForNatB2BUASessions)) {
                                if (SmsService.this.logger.isInfoEnabled()) {
                                    SmsService.this.logger.info("P2P, Message from: " + client.getLogin() + " redirected to registered client: " + toClient.getLogin());
                                }
                                SmsService.this.monitoringService.tell((Object)new TextMessage(((SipURI)request.getFrom().getURI()).getUser(), ((SipURI)request.getTo().getURI()).getUser(), TextMessage.SmsState.INBOUND_TO_CLIENT), self);
                                return;
                            }
                            String errMsg = "Cannot Connect to Client: " + toClient.getFriendlyName() + " : Make sure the Client exist or is registered with Restcomm";
                            SmsService.this.sendNotification(errMsg, 11001, "warning", true);
                            SipServletResponse resp = request.createResponse(404, "Cannot complete P2P messages");
                            resp.send();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }, (ExecutionContext)this.system.dispatcher());
            } else {
                FeatureAccessRequest far;
                ExtensionController ec;
                ExtensionResponse er;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Restcomm will route this SMS to an external aggregator: " + client.getLogin() + " to: " + toUser);
                }
                if ((er = (ec = ExtensionController.getInstance()).executePreOutboundAction((IExtensionRequest)(far = new FeatureAccessRequest(FeatureAccessRequest.Feature.OUTBOUND_SMS, client.getAccountSid())), this.extensions)).isAllowed()) {
                    SipServletResponse trying = request.createResponse(100);
                    trying.send();
                    ActorRef session = this.session(this.configuration, sourceOrganizationSid);
                    Sid sid = Sid.generate((Sid.Type)Sid.Type.SMS_MESSAGE);
                    SmsMessage.Builder builder = SmsMessage.builder();
                    builder.setSid(sid);
                    builder.setAccountSid(client.getAccountSid());
                    builder.setApiVersion(client.getApiVersion());
                    builder.setRecipient(toUser);
                    builder.setSender(client.getLogin());
                    builder.setBody(new String(request.getRawContent()));
                    builder.setDirection(SmsMessage.Direction.OUTBOUND_CALL);
                    builder.setStatus(SmsMessage.Status.RECEIVED);
                    builder.setPrice(new BigDecimal("0.00"));
                    builder.setPriceUnit(Currency.getInstance("USD"));
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("/").append(client.getApiVersion()).append("/Accounts/");
                    buffer.append(client.getAccountSid().toString()).append("/SMS/Messages/");
                    buffer.append(sid.toString());
                    URI uri = URI.create(buffer.toString());
                    builder.setUri(uri);
                    SmsMessage record = builder.build();
                    SmsMessagesDao messages = this.storage.getSmsMessagesDao();
                    messages.addSmsMessage(record);
                    session.tell((Object)new SmsSessionAttribute("record", (Object)record), this.self());
                    TlvSet tlvSet = new TlvSet();
                    SmsSessionRequest sms = new SmsSessionRequest(client.getLogin(), toUser, new String(request.getRawContent()), request, tlvSet, null);
                    this.monitoringService.tell((Object)new TextMessage(((SipURI)request.getFrom().getURI()).getUser(), ((SipURI)request.getTo().getURI()).getUser(), TextMessage.SmsState.INBOUND_TO_PROXY_OUT), self);
                    session.tell((Object)sms, this.self());
                } else {
                    String errMsg;
                    if (this.logger.isDebugEnabled()) {
                        errMsg = "Outbound SMS from Client " + client.getFriendlyName() + " not Allowed";
                        this.logger.debug(errMsg);
                    }
                    errMsg = "Outbound SMS from Client: " + client.getFriendlyName() + " is not Allowed";
                    this.sendNotification(errMsg, 11001, "warning", true);
                    SipServletResponse resp = request.createResponse(403, "Call not allowed");
                    resp.send();
                }
                ec.executePostOutboundAction((IExtensionRequest)far, this.extensions);
            }
        } else {
            SipServletResponse response = request.createResponse(404);
            response.send();
            String errMsg = "Restcomm cannot process this SMS because the destination number is not hosted locally. To: " + toUser;
            this.sendNotification(errMsg, 11005, "error", true);
            this.monitoringService.tell((Object)new TextMessage(((SipURI)request.getFrom().getURI()).getUser(), ((SipURI)request.getTo().getURI()).getUser(), TextMessage.SmsState.NOT_FOUND), self);
        }
    }

    private IncomingPhoneNumber getIncomingPhoneNumber(String phone, Sid sourceOrganizationSid, Sid destinationOrganization) {
        IncomingPhoneNumber number = this.numberSelector.searchNumber(phone, sourceOrganizationSid, destinationOrganization);
        return number;
    }

    private boolean redirectToHostedSmsApp(SipServletRequest request, ApplicationsDao applications, IncomingPhoneNumber number) {
        boolean isFoundHostedApp;
        block11: {
            isFoundHostedApp = false;
            try {
                String errMsg;
                FeatureAccessRequest far;
                if (number == null) break block11;
                ExtensionController ec = ExtensionController.getInstance();
                ExtensionResponse er = ec.executePreInboundAction((IExtensionRequest)(far = new FeatureAccessRequest(FeatureAccessRequest.Feature.INBOUND_SMS, number.getAccountSid())), this.extensions);
                if (er.isAllowed()) {
                    URI appUri = number.getSmsUrl();
                    ActorRef interpreter = null;
                    if (appUri != null || number.getSmsApplicationSid() != null) {
                        SmsInterpreterParams.Builder builder = new SmsInterpreterParams.Builder();
                        builder.setSmsService(this.self());
                        builder.setConfiguration(this.configuration);
                        builder.setStorage(this.storage);
                        builder.setAccountId(number.getAccountSid());
                        builder.setVersion(number.getApiVersion());
                        Sid sid = number.getSmsApplicationSid();
                        if (sid != null) {
                            Application application = applications.getApplication(sid);
                            RcmlserverConfigurationSet rcmlserverConfig = RestcommConfiguration.getInstance().getRcmlserver();
                            RcmlserverResolver resolver = RcmlserverResolver.getInstance((String)rcmlserverConfig.getBaseUrl(), (String)rcmlserverConfig.getApiPath());
                            builder.setUrl(UriUtils.resolve((URI)resolver.resolveRelative(application.getRcmlUrl())));
                        } else {
                            builder.setUrl(UriUtils.resolve((URI)appUri));
                        }
                        String smsMethod = number.getSmsMethod();
                        if (smsMethod == null || smsMethod.isEmpty()) {
                            builder.setMethod("POST");
                        } else {
                            builder.setMethod(smsMethod);
                        }
                        URI appFallbackUrl = number.getSmsFallbackUrl();
                        if (appFallbackUrl != null) {
                            builder.setFallbackUrl(UriUtils.resolve((URI)number.getSmsFallbackUrl()));
                            builder.setFallbackMethod(number.getSmsFallbackMethod());
                        }
                        Props props = SmsInterpreter.props((SmsInterpreterParams)builder.build());
                        interpreter = this.getContext().actorOf(props);
                    }
                    Sid organizationSid = this.storage.getOrganizationsDao().getOrganization(this.storage.getAccountsDao().getAccount(number.getAccountSid()).getOrganizationSid()).getSid();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("redirectToHostedSmsApp organizationSid = " + organizationSid);
                    }
                    ActorRef session = this.session(this.configuration, organizationSid);
                    session.tell((Object)request, this.self());
                    StartInterpreter start = new StartInterpreter(session);
                    interpreter.tell((Object)start, this.self());
                    isFoundHostedApp = true;
                    ec.executePostInboundAction((IExtensionRequest)far, this.extensions);
                    break block11;
                }
                if (this.logger.isDebugEnabled()) {
                    errMsg = "Inbound SMS is not Allowed";
                    this.logger.debug("Inbound SMS is not Allowed");
                }
                errMsg = "Inbound SMS to Number: " + number.getPhoneNumber() + " is not allowed";
                this.sendNotification(errMsg, 11001, "warning", true);
                SipServletResponse resp = request.createResponse(403, "SMS not allowed");
                resp.send();
                ec.executePostInboundAction((IExtensionRequest)far, this.extensions);
                return false;
            }
            catch (Exception e) {
                String msg = String.format("There is no valid Restcomm SMS Request URL configured for this number : %s", ((SipURI)request.getRequestURI()).getUser());
                this.sendNotification(msg, 12003, "warning", true);
            }
        }
        return isFoundHostedApp;
    }

    public void onReceive(Object message) throws Exception {
        SipServletResponse response;
        SipServletRequest request;
        String method;
        UntypedActorContext context = this.getContext();
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        ExtensionController ec = ExtensionController.getInstance();
        if (CreateSmsSession.class.equals(klass)) {
            CreateSmsSession ier = (CreateSmsSession)message;
            ier.setConfiguration(this.configuration);
            ExtensionResponse executePreOutboundAction = ec.executePreOutboundAction((IExtensionRequest)ier, this.extensions);
            if (executePreOutboundAction.isAllowed()) {
                CreateSmsSession createSmsSession = (CreateSmsSession)message;
                ActorRef session = this.session(ier.getConfiguration(), OrganizationUtil.getOrganizationSidByAccountSid((DaoManager)this.storage, (Sid)new Sid(createSmsSession.getAccountSid())));
                SmsServiceResponse response2 = new SmsServiceResponse((Object)session);
                sender.tell((Object)response2, self);
            } else {
                SmsServiceResponse response3 = new SmsServiceResponse((Throwable)new RestcommExtensionException("Now allowed to create SmsSession"));
                sender.tell((Object)response3, this.self());
            }
            ec.executePostOutboundAction((IExtensionRequest)ier, this.extensions);
        } else if (DestroySmsSession.class.equals(klass)) {
            DestroySmsSession request2 = (DestroySmsSession)message;
            ActorRef session = request2.session();
            context.stop(session);
        } else if (message instanceof SipServletRequest) {
            SipServletRequest request3 = (SipServletRequest)message;
            String method2 = request3.getMethod();
            if ("MESSAGE".equalsIgnoreCase(method2)) {
                this.message(message);
            }
        } else if (message instanceof SipServletResponse && "MESSAGE".equalsIgnoreCase(method = (request = (response = (SipServletResponse)message).getRequest()).getMethod())) {
            this.response(message);
        }
    }

    private void response(Object message) throws Exception {
        ActorRef self = this.self();
        SipServletResponse response = (SipServletResponse)message;
        if (B2BUAHelper.isB2BUASession((SipServletMessage)response)) {
            B2BUAHelper.forwardResponse((ActorSystem)this.system, (SipServletResponse)response, (boolean)this.patchForNatB2BUASessions);
            return;
        }
        SipApplicationSession application = response.getApplicationSession();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Is SipApplicationSession valid: " + application.isValid());
        }
        if (application != null) {
            SipServletRequest origRequest;
            ActorRef session = (ActorRef)application.getAttribute(SmsSession.class.getName());
            if (session != null) {
                session.tell((Object)response, self);
            }
            if ((origRequest = (SipServletRequest)application.getAttribute(SipServletRequest.class.getName())) != null && origRequest.getSession().isValid()) {
                SipServletResponse responseToOriginator = origRequest.createResponse(response.getStatus(), response.getReasonPhrase());
                responseToOriginator.send();
            }
        }
    }

    private SipURI outboundInterface() {
        SipURI result = null;
        List uris = (List)this.servletContext.getAttribute("javax.servlet.sip.outboundInterfaces");
        for (SipURI uri : uris) {
            String transport = uri.getTransportParam();
            if (!"udp".equalsIgnoreCase(transport)) continue;
            result = uri;
        }
        return result;
    }

    private ActorRef session(final Configuration p_configuration, final Sid organizationSid) {
        Props props = new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new SmsSession(p_configuration, SmsService.this.sipFactory, SmsService.this.outboundInterface(), SmsService.this.storage, SmsService.this.monitoringService, SmsService.this.servletContext, organizationSid);
            }
        });
        return this.getContext().actorOf(props);
    }

    private void sendNotification(String errMessage, int errCode, String errType, boolean createNotification) {
        NotificationsDao notifications = this.storage.getNotificationsDao();
        if (errType == "warning") {
            this.logger.warning(errMessage);
            if (createNotification) {
                Notification notification = this.notification(1, errCode, errMessage);
                notifications.addNotification(notification);
            }
        } else if (errType == "error") {
            this.logger.error(errMessage);
            if (createNotification) {
                Notification notification = this.notification(0, errCode, errMessage);
                notifications.addNotification(notification);
            }
        } else if (errType == "info" && this.logger.isInfoEnabled()) {
            this.logger.info(errMessage);
        }
    }

    private Notification notification(int log, int error, String message) {
        String version = this.configuration.subset("runtime-settings").getString("api-version");
        Sid accountId = new Sid("ACae6e420f425248d6a26948c17a9e2acf");
        Notification.Builder builder = Notification.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.NOTIFICATION);
        builder.setSid(sid);
        builder.setAccountSid(accountId);
        builder.setApiVersion(version);
        builder.setLog(log);
        builder.setErrorCode(error);
        String base = this.configuration.subset("runtime-settings").getString("error-dictionary-uri");
        StringBuilder buffer = new StringBuilder();
        buffer.append(base);
        if (!base.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(error).append(".html");
        URI info = URI.create(buffer.toString());
        builder.setMoreInfo(info);
        builder.setMessageText(message);
        DateTime now = DateTime.now();
        builder.setMessageDate(now);
        try {
            builder.setRequestUrl(new URI(""));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        builder.setRequestMethod("");
        builder.setRequestVariables("");
        buffer = new StringBuilder();
        buffer.append("/").append(version).append("/Accounts/");
        buffer.append(accountId.toString()).append("/Notifications/");
        buffer.append(sid.toString());
        URI uri = URI.create(buffer.toString());
        builder.setUri(uri);
        return builder.build();
    }
}

