/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.sms.smpp;

import com.cloudhopper.commons.charset.Charset;
import com.cloudhopper.commons.charset.CharsetUtil;
import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.impl.DefaultSmppSession;
import com.cloudhopper.smpp.type.Address;
import org.apache.log4j.Logger;

public class Smpp {
    private static final Logger logger = Logger.getLogger(Smpp.class);
    private static final String DEFAULT_SMPP_INBOUND_ENCODING = "MODIFIED-UTF8";
    private static final String DEFAULT_SMPP_OUTBOUND_ENCODING = "GSM";
    private String name;
    private String systemId;
    private String peerIp;
    private int peerPort;
    private SmppBindType smppBindType;
    private String password;
    private String systemType;
    private byte interfaceVersion;
    private Address address;
    private long connectTimeout;
    private int windowSize;
    private long windowWaitTimeout;
    private long requestExpiryTimeout;
    private long windowMonitorInterval;
    private boolean countersEnabled;
    private boolean logBytes;
    private long enquireLinkDelay;
    private Charset inboundCharacterEncoding;
    private Charset outboundCharacterEncoding;
    private boolean started;
    private transient DefaultSmppSession defaultSmppSession;

    public Smpp(String name, String systemId, String peerIp, int peerPort, SmppBindType smppBindType, String password, String systemType, byte interfaceVersion, Address address, long connectTimeout, int windowSize, long windowWaitTimeout, long requestExpiryTimeout, long windowMonitorInterval, boolean countersEnabled, boolean logBytes, long enquireLinkDelay, String inboundCharacterEncoding, String outboundCharacterEncoding) {
        block5: {
            block4: {
                this.started = true;
                this.defaultSmppSession = null;
                this.name = name;
                this.systemId = systemId;
                this.peerIp = peerIp;
                this.peerPort = peerPort;
                this.smppBindType = smppBindType;
                this.password = password;
                this.systemType = systemType;
                this.interfaceVersion = interfaceVersion;
                this.address = address;
                this.connectTimeout = connectTimeout;
                this.windowSize = windowSize;
                this.windowWaitTimeout = windowWaitTimeout;
                this.requestExpiryTimeout = requestExpiryTimeout;
                this.windowMonitorInterval = windowMonitorInterval;
                this.countersEnabled = countersEnabled;
                this.logBytes = logBytes;
                this.enquireLinkDelay = enquireLinkDelay;
                try {
                    this.inboundCharacterEncoding = CharsetUtil.map((String)inboundCharacterEncoding);
                }
                catch (Exception e) {
                    this.inboundCharacterEncoding = CharsetUtil.map((String)DEFAULT_SMPP_INBOUND_ENCODING);
                    if (!logger.isInfoEnabled()) break block4;
                    logger.info((Object)("Charset " + inboundCharacterEncoding + " does not exist. Inbound encoding is set to default " + DEFAULT_SMPP_INBOUND_ENCODING + "\n" + e.getMessage()));
                }
            }
            try {
                this.outboundCharacterEncoding = CharsetUtil.map((String)outboundCharacterEncoding);
            }
            catch (Exception e) {
                this.outboundCharacterEncoding = CharsetUtil.map((String)DEFAULT_SMPP_OUTBOUND_ENCODING);
                if (!logger.isInfoEnabled()) break block5;
                logger.info((Object)("Charset " + outboundCharacterEncoding + " does not exist. Outbound encoding is set to default " + DEFAULT_SMPP_OUTBOUND_ENCODING + "\n" + e.getMessage()));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getPeerIp() {
        return this.peerIp;
    }

    public void setPeerIp(String peerIp) {
        this.peerIp = peerIp;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public void setPeerPort(int peerPort) {
        this.peerPort = peerPort;
    }

    public SmppBindType getSmppBindType() {
        return this.smppBindType;
    }

    public void setSmppBindType(SmppBindType smppBindType) {
        this.smppBindType = smppBindType;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public byte getInterfaceVersion() {
        return this.interfaceVersion;
    }

    public void setInterfaceVersion(byte interfaceVersion) {
        this.interfaceVersion = interfaceVersion;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public long getWindowWaitTimeout() {
        return this.windowWaitTimeout;
    }

    public void setWindowWaitTimeout(long windowWaitTimeout) {
        this.windowWaitTimeout = windowWaitTimeout;
    }

    public long getRequestExpiryTimeout() {
        return this.requestExpiryTimeout;
    }

    public void setRequestExpiryTimeout(long requestExpiryTimeout) {
        this.requestExpiryTimeout = requestExpiryTimeout;
    }

    public long getWindowMonitorInterval() {
        return this.windowMonitorInterval;
    }

    public void setWindowMonitorInterval(long windowMonitorInterval) {
        this.windowMonitorInterval = windowMonitorInterval;
    }

    public boolean isCountersEnabled() {
        return this.countersEnabled;
    }

    public void setCountersEnabled(boolean countersEnabled) {
        this.countersEnabled = countersEnabled;
    }

    public boolean isLogBytes() {
        return this.logBytes;
    }

    public void setLogBytes(boolean logBytes) {
        this.logBytes = logBytes;
    }

    public long getEnquireLinkDelay() {
        return this.enquireLinkDelay;
    }

    public void setEnquireLinkDelay(long enquireLinkDelay) {
        this.enquireLinkDelay = enquireLinkDelay;
    }

    public Charset getInboundDefaultEncoding() {
        return this.inboundCharacterEncoding;
    }

    public Charset getOutboundDefaultEncoding() {
        return this.outboundCharacterEncoding;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
        if (!this.started) {
            this.defaultSmppSession.close(5000L);
        }
    }

    public DefaultSmppSession getSmppSession() {
        return this.defaultSmppSession;
    }

    public void setSmppSession(DefaultSmppSession smppSession) {
        this.defaultSmppSession = smppSession;
    }

    public String toString() {
        return "Smpp [name=" + this.name + ", systemId=" + this.systemId + ", peerIp=" + this.peerIp + ", peerPort=" + this.peerPort + ", smppBindType=" + this.smppBindType + ", password=" + this.password + ", systemType=" + this.systemType + ", interfaceVersion=" + this.interfaceVersion + ", address=" + this.address + ", connectTimeout=" + this.connectTimeout + ", windowSize=" + this.windowSize + ", windowWaitTimeout=" + this.windowWaitTimeout + ", requestExpiryTimeout=" + this.requestExpiryTimeout + ", windowMonitorInterval=" + this.windowMonitorInterval + ", countersEnabled=" + this.countersEnabled + ", logBytes=" + this.logBytes + ", enquireLinkDelay=" + this.enquireLinkDelay + ", inboundCharacterEncoding=" + this.inboundCharacterEncoding.toString() + ", outboundCharacterEncoding=" + this.outboundCharacterEncoding.toString() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Smpp other = (Smpp)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

