/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.graal;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;

public class GenerateGraalvmReflectConfig {
    private static final String entry = "{ \"name\": \"%s\",\n  \"allPublicFields\": true,\n  \"allPublicConstructors\": true,\n  \"allDeclaredConstructors\": true,\n  \"allPublicMethods\": true,\n  \"allDeclaredFields\": true,\n  \"allPublicClasses\": true,\n  \"allDeclaredClasses\": true\n},";

    public static void main(String[] args) {
        System.out.println(GenerateGraalvmReflectConfig.entry("com.google.gson.JsonParser"));
        System.out.println(GenerateGraalvmReflectConfig.entry("com.google.gson.JsonParseException"));
        System.out.println(GenerateGraalvmReflectConfig.entry("java.net.URI"));
        System.out.println(GenerateGraalvmReflectConfig.entry("java.time.Duration"));
        System.out.println(GenerateGraalvmReflectConfig.entry("org.restheart.polyglot.JSInterceptorFactory"));
        try (ScanResult scanResult = new ClassGraph().acceptPackages(new String[]{"java.net.http", "jdk.internal.net.http"}).rejectClasses(new String[]{"jdk.internal.net.http.common.SSLFlowDelegate", "jdk.internal.net.http.common.SSLFlowDelegate$Monitor"}).acceptPackages(new String[]{"org.restheart.exchange"}).acceptClasses(new String[]{"org.restheart.mongodb.db.OperationResult", "org.restheart.mongodb.db.BulkOperationResult"}).acceptClasses(new String[]{"org.restheart.security.BaseAccount", "org.restheart.security.BaseAclPermission", "org.restheart.security.BasePrincipal", "org.restheart.security.FileRealmAccount", "org.restheart.security.JwtAccount", "org.restheart.security.MongoPermissions", "org.restheart.security.MongoRealmAccount", "org.restheart.security.PwdCredentialAccount"}).acceptClasses(new String[]{"org.restheart.utils.BsonUtils"}).acceptClasses(new String[]{"org.restheart.utils.BsonUtils$ArrayBuilder"}).acceptClasses(new String[]{"org.restheart.utils.BsonUtils$DocumentBuilder"}).acceptPackages(new String[]{"org.bson"}).rejectPackages(new String[]{"org.bson.codecs", "org.bson.json", "org.bson.io", "org.bson.assertions", "org.bson.conversions", "org.bson.diagnostics", "org.bson.internal", "org.bson.types", "org.bson.util"}).acceptPackages(new String[]{"com.mongodb.client", "com.mongodb.internal", "com.mongodb.client.internal"}).acceptClasses(new String[]{"com.mongodb.MongoClient", "com.mongodb.client.internal.MongoCollectionImpl", "com.mongodb.client.model.Filters"}).acceptClasses(new String[]{"org.slf4j.Logger", "ch.qos.logback.classic.Logger", "org.apache.commons.logging.LogFactory"}).acceptPackages(new String[]{"com.google.gson"}).rejectPackages(new String[]{"com.google.gson.internal", "com.google.gson.stream", "com.google.gson.annotations"}).enableSystemJarsAndModules().scan();){
            for (ClassInfo classInfo : scanResult.getAllClasses()) {
                if ("org.bson".equals(classInfo.getPackageName()) && classInfo.getSuperclasses().stream().noneMatch(ci -> "org.bson.BsonValue".equals(ci.getName())) || "com.google.gson".equals(classInfo.getPackageName()) && classInfo.getSuperclasses().stream().noneMatch(ci -> "com.google.gson.JsonElement".equals(ci.getName()))) continue;
                System.out.println(GenerateGraalvmReflectConfig.entry(classInfo.getName()));
            }
        }
    }

    private static String entry(String className) {
        return entry.formatted(className);
    }
}

