/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.graal;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.restheart.plugins.Inject;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.PluginsScanner;

public class PluginsReflectionRegistrationFeature
implements Feature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        PluginsScanner.allPluginsClassNames().stream().map(this::clazz).filter(c -> c != null).forEach(this::registerAll);
    }

    private Class<?> clazz(String clazzName) {
        try {
            return Class.forName(clazzName, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException cfe) {
            return null;
        }
    }

    public String getDescription() {
        return "Automates reflection configuration of RESTHeart plugins for native-image builds";
    }

    private void registerAll(Class<?> clazz) {
        RuntimeReflection.register((Class[])new Class[]{clazz});
        RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{clazz});
        RuntimeReflection.register((Field[])this.annotated(clazz.getDeclaredFields()));
        RuntimeReflection.register((Executable[])this.annotated(clazz.getDeclaredMethods()));
    }

    private Field[] annotated(Field ... fields) {
        List list = Arrays.stream(fields).filter(f -> f.getAnnotation(Inject.class) != null).collect(Collectors.toList());
        return (Field[])list.toArray(Field[]::new);
    }

    private Method[] annotated(Method ... methods) {
        List list = Arrays.stream(methods).filter(m -> m.getAnnotation(OnInit.class) != null).collect(Collectors.toList());
        return (Method[])list.toArray(Method[]::new);
    }
}

