/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import org.restheart.exchange.CORSHeaders;
import org.restheart.exchange.Request;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.PluginsRegistryImpl;
import org.restheart.plugins.Service;
import org.restheart.utils.PluginUtils;

public class CORSHandler
extends PipelinedHandler {
    public static void injectAccessControlAllowHeaders(HttpServerExchange exchange) {
        Service handlingService = PluginUtils.handlingService((PluginsRegistry)PluginsRegistryImpl.getInstance(), (HttpServerExchange)exchange);
        if (handlingService == null) {
            return;
        }
        Request request = Request.of((HttpServerExchange)exchange);
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        if (!responseHeaders.contains(CORSHeaders.ACCESS_CONTROL_ALLOW_ORIGIN)) {
            responseHeaders.add(CORSHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, handlingService.accessControlAllowOrigin(request));
        }
        if (!responseHeaders.contains(CORSHeaders.ACCESS_CONTROL_ALLOW_CREDENTIAL)) {
            responseHeaders.add(CORSHeaders.ACCESS_CONTROL_ALLOW_CREDENTIAL, handlingService.accessControlAllowCredentials(request));
        }
        if (!responseHeaders.contains(CORSHeaders.ACCESS_CONTROL_EXPOSE_HEADERS)) {
            responseHeaders.add(CORSHeaders.ACCESS_CONTROL_EXPOSE_HEADERS, handlingService.accessControlExposeHeaders(request));
        }
    }

    public CORSHandler() {
    }

    public CORSHandler(PipelinedHandler next) {
        super(next);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        CORSHandler.injectAccessControlAllowHeaders(exchange);
        this.next(exchange);
    }
}

