/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers;

import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.restheart.exchange.ByteArrayProxyRequest;
import org.restheart.handlers.ResponseInterceptorsExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.StreamSinkConduit;

public class ContentStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    static final Logger LOGGER = LoggerFactory.getLogger(ContentStreamSinkConduit.class);
    private final StreamSinkConduit _next;
    private final ResponseInterceptorsExecutor responseInterceptorsExecutor = new ResponseInterceptorsExecutor(true);

    public ContentStreamSinkConduit(StreamSinkConduit next, HttpServerExchange exchange) {
        super(next);
        this._next = next;
        try {
            this.responseInterceptorsExecutor.handleRequest(exchange);
        }
        catch (Exception e) {
            LOGGER.error("Error executing interceptors", (Throwable)e);
            ByteArrayProxyRequest.of((HttpServerExchange)exchange).setInError(true);
            throw new RuntimeException(e);
        }
    }

    public int write(ByteBuffer src) throws IOException {
        return this._next.write(src);
    }

    public long write(ByteBuffer[] dsts, int offs, int len) throws IOException {
        return this._next.write(dsts, offs, len);
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return this._next.transferFrom(src, position, count);
    }

    public long transferFrom(StreamSourceChannel src, long count, ByteBuffer throughBuffer) throws IOException {
        return this._next.transferFrom(src, count, throughBuffer);
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        return this._next.writeFinal(src);
    }

    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this._next.writeFinal(srcs, offset, length);
    }

    public void terminateWrites() throws IOException {
        this._next.terminateWrites();
    }
}

