/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers.injectors;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.restheart.exchange.ByteArrayProxyResponse;
import org.restheart.handlers.ContentStreamSinkConduit;
import org.restheart.handlers.ModifiableContentSinkConduit;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.Interceptor;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.PluginsRegistryImpl;
import org.restheart.utils.PluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.xnio.conduits.StreamSinkConduit;

public class ConduitInjector
extends PipelinedHandler {
    static final Logger LOGGER = LoggerFactory.getLogger(ConduitInjector.class);
    public static final AttachmentKey<ModifiableContentSinkConduit> MCSC_KEY = AttachmentKey.create(ModifiableContentSinkConduit.class);
    public static final AttachmentKey<HeaderMap> ORIGINAL_ACCEPT_ENCODINGS_KEY = AttachmentKey.create(HeaderMap.class);
    private final PluginsRegistry pluginsRegistry = PluginsRegistryImpl.getInstance();
    private final List<Interceptor<?, ?>> inteceptors = new ArrayList();

    public ConduitInjector() {
        this(null);
    }

    public ConduitInjector(PipelinedHandler next) {
        super(next);
        this.inteceptors.addAll(this.pluginsRegistry.getProxyInterceptors(InterceptPoint.RESPONSE));
        this.inteceptors.addAll(this.pluginsRegistry.getProxyInterceptors(InterceptPoint.RESPONSE_ASYNC));
    }

    private void forceIdentityEncodingForInterceptors(HttpServerExchange exchange) {
        if (this.inteceptors.stream().anyMatch(ri -> PluginUtils.requiresContent((Interceptor)ri))) {
            HeaderMap before = new HeaderMap();
            if (exchange.getRequestHeaders().contains(Headers.ACCEPT_ENCODING)) {
                exchange.getRequestHeaders().get(Headers.ACCEPT_ENCODING).forEach(value -> before.add(Headers.ACCEPT_ENCODING, value));
            }
            exchange.putAttachment(ORIGINAL_ACCEPT_ENCODINGS_KEY, (Object)before);
            LOGGER.debug("{} setting encoding to identity because request involves response interceptors.", (Object)before);
            exchange.getRequestHeaders().put(Headers.ACCEPT_ENCODING, "identity");
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addResponseWrapper((factory, cexchange) -> {
            Map mdcCtx = ByteArrayProxyResponse.of((HttpServerExchange)exchange).getMDCContext();
            if (mdcCtx != null) {
                MDC.setContextMap((Map)mdcCtx);
            }
            if (this.inteceptors.stream().anyMatch(ri -> PluginUtils.requiresContent((Interceptor)ri))) {
                ModifiableContentSinkConduit mcsc = new ModifiableContentSinkConduit((StreamSinkConduit)factory.create(), cexchange);
                cexchange.putAttachment(MCSC_KEY, (Object)mcsc);
                return mcsc;
            }
            return new ContentStreamSinkConduit((StreamSinkConduit)factory.create(), cexchange);
        });
        this.forceIdentityEncodingForInterceptors(exchange);
        this.next(exchange);
    }
}

