/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.handlers;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.restheart.exchange.Request;
import org.restheart.exchange.Response;
import org.restheart.handlers.CORSHandler;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.metrics.Metrics;
import org.restheart.plugins.security.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.channels.StreamSourceChannel;

public class AuthenticationCallHandler
extends PipelinedHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationCallHandler.class);
    private static final MetricRegistry AUTH_METRIC_REGISTRY = SharedMetricRegistries.getOrCreate((String)"AUTH");
    private static final String BLOCK_AUTH_ERR_MSG = "Request authentication was blocked";
    private static final String FAILED_AUTH_METRIC_PREFIX = "failed-auth-";
    private static final HttpString TRANSFER_ENCODING;

    public AuthenticationCallHandler(PipelinedHandler next) {
        super(next);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityContext sc = exchange.getSecurityContext();
        if (Request.of((HttpServerExchange)exchange).isBlockForTooManyRequests()) {
            String remoteIp = ExchangeAttributes.remoteIp().readAttribute(exchange);
            LOGGER.warn(BLOCK_AUTH_ERR_MSG, (Object)remoteIp);
            CORSHandler.injectAccessControlAllowHeaders(exchange);
            exchange.setStatusCode(429);
            this.fastEndExchange(exchange);
        } else if (sc.authenticate() && (!sc.isAuthenticationRequired() || sc.isAuthenticated())) {
            if (!exchange.isComplete()) {
                this.next(exchange);
            }
        } else {
            CORSHandler.injectAccessControlAllowHeaders(exchange);
            this.updateFailedAuthMetrics(exchange);
            Response.of((HttpServerExchange)exchange).setStatusCode(401);
            this.fastEndExchange(exchange);
        }
    }

    private void fastEndExchange(HttpServerExchange exchange) throws IOException {
        StreamSourceChannel requestChannel = exchange.getRequestChannel();
        HeaderValues econding = exchange.getRequestHeaders().get(TRANSFER_ENCODING);
        if (!(econding != null && econding.getFirst().startsWith("chunked") || requestChannel == null)) {
            try {
                requestChannel.shutdownReads();
            }
            catch (IOException ie) {
                LOGGER.debug("ingoring error shutting down reads", (Throwable)ie);
            }
        }
        exchange.endExchange();
    }

    private void updateFailedAuthMetrics(HttpServerExchange exchange) {
        this._update(AUTH_METRIC_REGISTRY.histogram(Metrics.failedAuthHistogramName((HttpServerExchange)exchange), () -> new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(10L, TimeUnit.SECONDS))));
        this.tryPruneMetrics();
    }

    private void _update(Histogram histo) {
        histo.update(histo.getSnapshot().getMax() + 1L);
    }

    private void tryPruneMetrics() {
        Counter total = AUTH_METRIC_REGISTRY.counter(MetricRegistry.name(Authenticator.class, (String[])new String[]{"_total"}));
        total.inc();
        if (total.getCount() % 100L == 0L) {
            total.dec(total.getCount());
            LOGGER.trace("Pruning auth metrics");
            AUTH_METRIC_REGISTRY.removeMatching((name, metric) -> name.startsWith(MetricRegistry.name(Authenticator.class, (String[])new String[]{FAILED_AUTH_METRIC_PREFIX})));
        }
    }

    static {
        if (LOGGER.isTraceEnabled()) {
            Slf4jReporter.forRegistry((MetricRegistry)AUTH_METRIC_REGISTRY).outputTo(LOGGER).filter((name, metric) -> {
                Histogram hist;
                return name.startsWith(MetricRegistry.name(Authenticator.class, (String[])new String[]{FAILED_AUTH_METRIC_PREFIX})) && metric instanceof Histogram && (hist = (Histogram)metric).getSnapshot().getMax() > 0L;
            }).withLoggingLevel(Slf4jReporter.LoggingLevel.TRACE).build().start(5L, TimeUnit.SECONDS);
        }
        TRANSFER_ENCODING = HttpString.tryFromString((String)"Transfer-Encoding");
    }
}

