/*
 * Decompiled with CFR 0.152.
 */
package org.restheart;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.AllowedMethodsHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.server.handlers.HttpContinueAcceptingHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.HttpString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.restheart.Version;
import org.restheart.buffers.ThreadAwareByteBufferPool;
import org.restheart.configuration.Configuration;
import org.restheart.configuration.ConfigurationException;
import org.restheart.configuration.Listener;
import org.restheart.configuration.StaticResource;
import org.restheart.configuration.TLSListener;
import org.restheart.configuration.Utils;
import org.restheart.exchange.Exchange;
import org.restheart.exchange.ExchangeKeys;
import org.restheart.exchange.PipelineInfo;
import org.restheart.handlers.BeforeExchangeInitInterceptorsExecutor;
import org.restheart.handlers.ConfigurableEncodingHandler;
import org.restheart.handlers.ErrorHandler;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.handlers.PipelinedWrappingHandler;
import org.restheart.handlers.ProxyExchangeBuffersCloser;
import org.restheart.handlers.QueryStringRebuilder;
import org.restheart.handlers.RequestInterceptorsExecutor;
import org.restheart.handlers.RequestLogger;
import org.restheart.handlers.RequestNotManagedHandler;
import org.restheart.handlers.TracingInstrumentationHandler;
import org.restheart.handlers.WorkingThreadsPoolDispatcher;
import org.restheart.handlers.injectors.AuthHeadersRemover;
import org.restheart.handlers.injectors.ConduitInjector;
import org.restheart.handlers.injectors.PipelineInfoInjector;
import org.restheart.handlers.injectors.RequestContentInjector;
import org.restheart.handlers.injectors.XForwardedHeadersInjector;
import org.restheart.plugins.InitPoint;
import org.restheart.plugins.Initializer;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsRegistryImpl;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.Service;
import org.restheart.plugins.security.AuthMechanism;
import org.restheart.plugins.security.Authorizer;
import org.restheart.plugins.security.TokenManager;
import org.restheart.security.handlers.SecurityHandler;
import org.restheart.utils.BootstrapperUtils;
import org.restheart.utils.FileUtils;
import org.restheart.utils.LoggingInitializer;
import org.restheart.utils.OSChecker;
import org.restheart.utils.PluginUtils;
import org.restheart.utils.RESTHeartDaemon;
import org.restheart.utils.ResourcesExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;
import org.xnio.Xnio;
import org.xnio.ssl.XnioSsl;
import picocli.CommandLine;

public final class Bootstrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(Bootstrapper.class);
    private static boolean IS_FORKED;
    private static final Map<String, File> TMP_EXTRACTED_FILES;
    private static Path CONFIGURATION_FILE_PATH;
    private static Path CONF_OVERRIDES_FILE_PATH;
    private static boolean printConfiguration;
    private static boolean printConfigurationTemplate;
    private static boolean standaloneConfiguration;
    private static GracefulShutdownHandler HANDLERS;
    private static Configuration configuration;
    private static Undertow undertowServer;
    private static final String EXITING = ", exiting...";
    private static final String RESTHEART = "RESTHeart";

    public static Configuration getConfiguration() {
        return configuration;
    }

    private static void parseCommandLineParameters(String[] args) {
        Args parameters = new Args();
        CommandLine cmd = new CommandLine((Object)parameters);
        try {
            cmd.parseArgs(args);
            if (cmd.isUsageHelpRequested()) {
                cmd.usage(System.out);
                System.exit(0);
            }
            if (cmd.isVersionHelpRequested()) {
                String version = Version.getInstance().getVersion() == null ? "unknown (not packaged)" : Version.getInstance().getVersion();
                System.out.println(RESTHEART.concat(" Version ").concat(version).concat(" Build-Time ").concat(DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.systemDefault()).format(Version.getInstance().getBuildTime())));
                System.exit(0);
            }
            printConfiguration = parameters.printConfiguration;
            printConfigurationTemplate = parameters.printConfigurationTemplate;
            standaloneConfiguration = parameters.standalone;
            String confFilePath = parameters.configPath == null ? System.getenv("RESTHEART_CONF_FILE") : parameters.configPath;
            CONFIGURATION_FILE_PATH = FileUtils.getFileAbsolutePath(confFilePath);
            FileUtils.getFileAbsolutePath(parameters.configPath);
            IS_FORKED = parameters.isForked;
            String confOverridesFilePath = parameters.rho == null ? System.getenv("RHO_FILE") : parameters.rho;
            CONF_OVERRIDES_FILE_PATH = FileUtils.getFileAbsolutePath(confOverridesFilePath);
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage());
            cmd.usage(System.out);
            System.exit(1);
        }
    }

    public static void main(String[] args) throws ConfigurationException, IOException {
        Bootstrapper.doNotWarnTruffleInterpreterOnly();
        Bootstrapper.parseCommandLineParameters(args);
        BootstrapperUtils.setJsonpathDefaults();
        try {
            configuration = Configuration.Builder.build((Path)CONFIGURATION_FILE_PATH, (Path)CONF_OVERRIDES_FILE_PATH, (boolean)standaloneConfiguration, (boolean)true);
        }
        catch (ConfigurationException ce) {
            Configuration confJustForError = Configuration.Builder.build((boolean)true, (boolean)true);
            BootstrapperUtils.initLogging(confJustForError, null, IS_FORKED);
            Bootstrapper.logErrorAndExit(ce.getMessage(), ce, false, true, -1);
        }
        Bootstrapper.run();
    }

    private static void run() {
        if (!configuration.logging().ansiConsole()) {
            AnsiConsole.systemInstall();
        }
        if (!IS_FORKED) {
            BootstrapperUtils.initLogging(configuration, null, IS_FORKED);
            Bootstrapper.startServer(false);
        } else {
            RESTHeartDaemon d;
            boolean isPosix;
            if (OSChecker.isWindows()) {
                LOGGER.error("Fork is not supported on Windows");
                LOGGER.info(Ansi.ansi().fg(Ansi.Color.GREEN).bold().a("RESTHeart stopped").reset().toString());
                System.exit(-1);
            }
            if (!(isPosix = FileSystems.getDefault().supportedFileAttributeViews().contains("posix"))) {
                Bootstrapper.logErrorAndExit("Unable to fork process, this is only supported on POSIX compliant OSes", null, false, -1);
            }
            if ((d = new RESTHeartDaemon()).isDaemonized()) {
                try {
                    d.init();
                    BootstrapperUtils.initLogging(configuration, d, IS_FORKED);
                }
                catch (Exception t) {
                    Bootstrapper.logErrorAndExit("Error staring forked process", t, false, false, -1);
                }
                Bootstrapper.startServer(true);
            } else {
                BootstrapperUtils.initLogging(configuration, d, IS_FORKED);
                try {
                    BootstrapperUtils.logStartMessages(configuration);
                    BootstrapperUtils.logLoggingConfiguration(configuration, false);
                    d.daemonize();
                }
                catch (Throwable t) {
                    Bootstrapper.logErrorAndExit("Error forking", t, false, false, -1);
                }
            }
        }
    }

    public static void shutdown(String[] args) {
        Bootstrapper.stopServer(false);
    }

    private static void startServer(boolean fork) {
        BootstrapperUtils.logStartMessages(configuration);
        Path pidFilePath = BootstrapperUtils.pidFile(CONFIGURATION_FILE_PATH, CONF_OVERRIDES_FILE_PATH);
        boolean pidFileAlreadyExists = false;
        if (!OSChecker.isWindows() && pidFilePath != null) {
            pidFileAlreadyExists = BootstrapperUtils.checkPidFile(CONFIGURATION_FILE_PATH, CONF_OVERRIDES_FILE_PATH);
        }
        BootstrapperUtils.logLoggingConfiguration(configuration, fork);
        try {
            Configuration.Builder.build((Path)CONFIGURATION_FILE_PATH, (Path)CONF_OVERRIDES_FILE_PATH, (boolean)standaloneConfiguration, (boolean)false);
        }
        catch (ConfigurationException ex) {
            Bootstrapper.logErrorAndExit(ex.getMessage() + EXITING, ex, false, -1);
        }
        if (printConfiguration) {
            LOGGER.info("Printing configuration and exiting");
            System.err.println(configuration.toString());
            System.exit(0);
        }
        if (printConfigurationTemplate) {
            String confFilePath = standaloneConfiguration ? "/restheart-default-config-no-mongodb.yml" : "/restheart-default-config.yml";
            try (InputStream confFileStream = Configuration.class.getResourceAsStream(confFilePath);){
                String content = new BufferedReader(new InputStreamReader(confFileStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                LOGGER.info("Printing configuration template and exiting");
                System.err.println(content);
                System.exit(0);
            }
            catch (IOException ioe) {
                Bootstrapper.logErrorAndExit(ioe.getMessage() + EXITING, ioe, false, -1);
            }
        }
        try {
            PluginsRegistryImpl.getInstance().instantiateAll();
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage() != null && iae.getMessage().contains("NoClassDefFoundError")) {
                Bootstrapper.logErrorAndExit("Error instantiating plugins: an external dependency is missing. Copy the missing dependency jar to the plugins directory to add it to the classpath", iae, false, -112);
            } else {
                Bootstrapper.logErrorAndExit("Error instantiating plugins", iae, false, -110);
            }
        }
        catch (NoClassDefFoundError ncdfe) {
            Bootstrapper.logErrorAndExit("Error instantiating plugins: an external dependency is missing. Copy the missing dependency jar to the plugins directory to add it to the classpath", ncdfe, false, -112);
        }
        catch (LinkageError le) {
            String version = Version.getInstance().getVersion() == null ? "of correct version" : "v" + Version.getInstance().getVersion();
            Bootstrapper.logErrorAndExit("Linkage error instantiating plugins. Check that all plugins were compiled against restheart-commons " + version, le, false, -111);
        }
        catch (Throwable t) {
            Bootstrapper.logErrorAndExit("Error instantiating plugins", t, false, -110);
        }
        PluginsRegistryImpl.getInstance().getInitializers().stream().filter(i -> PluginUtils.initPoint((Initializer)((Initializer)i.getInstance())) == InitPoint.BEFORE_STARTUP).forEach(i -> {
            try {
                ((Initializer)i.getInstance()).init();
            }
            catch (NoClassDefFoundError iae) {
                LOGGER.error("Error executing initializer {}. An external dependency is missing. Copy the missing dependency jar to the plugins directory to add it to the classpath", (Object)i.getName(), (Object)iae);
            }
            catch (LinkageError le) {
                String version = Version.getInstance().getVersion() == null ? "of correct version" : "v" + Version.getInstance().getVersion();
                LOGGER.error("Linkage error executing initializer {}. Check that it was compiled against restheart-commons {}", new Object[]{i.getName(), version, le});
            }
            catch (Throwable t) {
                LOGGER.error("Error executing initializer {}", (Object)i.getName());
            }
        });
        try {
            Bootstrapper.startCoreSystem();
        }
        catch (Throwable t) {
            Bootstrapper.logErrorAndExit("Error starting RESTHeart. Exiting...", t, false, !pidFileAlreadyExists, -2);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Bootstrapper.stopServer(false)));
        if (!OSChecker.isWindows() && pidFilePath != null) {
            FileUtils.createPidFile(pidFilePath);
            LOGGER.info("Pid file {}", (Object)pidFilePath);
        }
        PluginsRegistryImpl.getInstance().getInitializers().stream().filter(i -> PluginUtils.initPoint((Initializer)((Initializer)i.getInstance())) == InitPoint.AFTER_STARTUP).forEach(i -> {
            try {
                ((Initializer)i.getInstance()).init();
            }
            catch (NoClassDefFoundError iae) {
                LOGGER.error("Error executing initializer {}. An external dependency is missing. Copy the missing dependency jar to the plugins directory to add it to the classpath", (Object)i.getName(), (Object)iae);
            }
            catch (LinkageError le) {
                String version = Version.getInstance().getVersion() == null ? "of correct version" : "v" + Version.getInstance().getVersion();
                LOGGER.error("Linkage error executing initializer {}. Check that it was compiled against restheart-commons {}", new Object[]{i.getName(), version, le});
            }
            catch (Throwable t) {
                LOGGER.error("Error executing initializer {}", (Object)i.getName(), (Object)t);
            }
        });
        LOGGER.info(Ansi.ansi().fg(Ansi.Color.GREEN).bold().a("RESTHeart started").reset().toString());
    }

    private static void stopServer(boolean silent) {
        Bootstrapper.stopServer(silent, true);
    }

    private static void stopServer(boolean silent, boolean removePid) {
        if (!silent) {
            LOGGER.info("Stopping RESTHeart...");
        }
        if (HANDLERS != null) {
            if (!silent) {
                LOGGER.info("Waiting for pending request to complete (up to 1 minute)...");
            }
            try {
                HANDLERS.shutdown();
                HANDLERS.awaitShutdown(60000L);
            }
            catch (InterruptedException ie) {
                LOGGER.error("Error while waiting for pending request to complete", (Throwable)ie);
                Thread.currentThread().interrupt();
            }
        }
        Path pidFilePath = FileUtils.getPidFilePath(FileUtils.getFileAbsolutePathHash(CONFIGURATION_FILE_PATH, CONF_OVERRIDES_FILE_PATH));
        if (removePid && pidFilePath != null) {
            if (!silent) {
                LOGGER.info("Removing the pid file {}", (Object)pidFilePath.toString());
            }
            try {
                Files.deleteIfExists(pidFilePath);
            }
            catch (IOException ex) {
                LOGGER.error("Can't delete pid file {}", (Object)pidFilePath.toString(), (Object)ex);
            }
        }
        if (!silent) {
            LOGGER.info("Cleaning up temporary directories...");
        }
        TMP_EXTRACTED_FILES.keySet().forEach(k -> {
            try {
                ResourcesExtractor.deleteTempDir(Bootstrapper.class, (String)k, (File)TMP_EXTRACTED_FILES.get(k));
            }
            catch (IOException | URISyntaxException ex) {
                LOGGER.error("Error cleaning up temporary directory {}", (Object)TMP_EXTRACTED_FILES.get(k).toString(), (Object)ex);
            }
        });
        if (undertowServer != null) {
            undertowServer.stop();
        }
        if (!silent) {
            LOGGER.info(Ansi.ansi().fg(Ansi.Color.GREEN).bold().a("RESTHeart stopped").reset().toString());
        }
        LoggingInitializer.stopLogging();
    }

    private static void startCoreSystem() {
        Listener ajpListener;
        Listener httpListener;
        Set<PluginRecord<Authorizer>> authorizers;
        List allowers;
        if (configuration == null) {
            Bootstrapper.logErrorAndExit("No configuration found. exiting..", null, false, -1);
        }
        if (!(configuration.httpsListener().enabled() || configuration.httpListener().enabled() || configuration.ajpListener().enabled())) {
            Bootstrapper.logErrorAndExit("No listener specified. exiting..", null, false, -1);
        }
        PluginRecord<TokenManager> tokenManager = PluginsRegistryImpl.getInstance().getTokenManager();
        Set<PluginRecord<AuthMechanism>> authMechanisms = PluginsRegistryImpl.getInstance().getAuthMechanisms();
        if (authMechanisms == null || authMechanisms.isEmpty()) {
            LOGGER.warn(Ansi.ansi().fg(Ansi.Color.RED).bold().a("No Authentication Mechanisms defined").reset().toString());
        }
        List list = allowers = (authorizers = PluginsRegistryImpl.getInstance().getAuthorizers()) == null ? null : authorizers.stream().filter(a -> a.isEnabled()).filter(a -> a.getInstance() != null).map(a -> (Authorizer)a.getInstance()).filter(a -> PluginUtils.authorizerType((Authorizer)a) == Authorizer.TYPE.ALLOWER).collect(Collectors.toList());
        if (allowers == null || allowers.isEmpty()) {
            LOGGER.warn(Ansi.ansi().fg(Ansi.Color.RED).bold().a("No Authorizer of type ALLOWER defined, all requests to secured services will be forbidden; fullAuthorizer can be enabled to allow any request.").reset().toString());
        }
        Undertow.Builder builder = Undertow.builder();
        builder.setByteBufferPool((ByteBufferPool)new ThreadAwareByteBufferPool(configuration.coreModule().directBuffers(), configuration.coreModule().bufferSize(), configuration.coreModule().buffersPooling()));
        TLSListener httpsListener = configuration.httpsListener();
        if (httpsListener.enabled()) {
            builder.addHttpsListener(httpsListener.port(), httpsListener.host(), Bootstrapper.initSSLContext());
            if (httpsListener.host().equals("127.0.0.1") || httpsListener.host().equalsIgnoreCase("localhost")) {
                LOGGER.warn("HTTPS listener bound to localhost:{}. Remote systems will be unable to connect to this server.", (Object)httpsListener.port());
            } else {
                LOGGER.info("HTTPS listener bound at {}:{}", (Object)httpsListener.host(), (Object)httpsListener.port());
            }
        }
        if ((httpListener = configuration.httpListener()).enabled()) {
            builder.addHttpListener(httpListener.port(), httpListener.host());
            if (httpListener.host().equals("127.0.0.1") || httpListener.host().equalsIgnoreCase("localhost")) {
                LOGGER.warn("HTTP listener bound to localhost:{}. Remote systems will be unable to connect to this server.", (Object)httpListener.port());
            } else {
                LOGGER.info("HTTP listener bound at {}:{}", (Object)httpListener.host(), (Object)httpListener.port());
            }
        }
        if ((ajpListener = configuration.ajpListener()).enabled()) {
            builder.addAjpListener(ajpListener.port(), ajpListener.host());
            if (ajpListener.host().equals("127.0.0.1") || ajpListener.host().equalsIgnoreCase("localhost")) {
                LOGGER.warn("AJP listener bound to localhost:{}. Remote systems will be unable to connect to this server.", (Object)ajpListener.port());
            } else {
                LOGGER.info("AJP listener bound at {}:{}", (Object)ajpListener.host(), (Object)ajpListener.port());
            }
        }
        HANDLERS = Bootstrapper.getPipeline(authMechanisms, authorizers, tokenManager);
        Exchange.updateBufferSize((int)configuration.coreModule().bufferSize());
        boolean autoConfigIoThreads = configuration.coreModule().ioThreads() <= 0;
        int ioThreads = autoConfigIoThreads ? Runtime.getRuntime().availableProcessors() : configuration.coreModule().ioThreads();
        boolean autoConfigWorkersSchedulerParallelism = configuration.coreModule().workersSchedulerParallelism() <= 0;
        long workersSchedulerParallelism = autoConfigWorkersSchedulerParallelism ? Math.round((double)Runtime.getRuntime().availableProcessors() * 1.5) : (long)configuration.coreModule().workersSchedulerParallelism();
        System.setProperty("jdk.virtualThreadScheduler.parallelism", String.valueOf(workersSchedulerParallelism));
        System.setProperty("jdk.virtualThreadScheduler.maxPoolSize", String.valueOf(configuration.coreModule().workersSchedulerMaxPoolSize()));
        LOGGER.info("Available processors: {}, IO threads{}: {}, worker scheduler parallelism{}: {}, worker scheduler max pool size: {}", new Object[]{Runtime.getRuntime().availableProcessors(), autoConfigIoThreads ? " (auto detected)" : "", ioThreads, autoConfigWorkersSchedulerParallelism ? " (auto detected)" : "", workersSchedulerParallelism, configuration.coreModule().workersSchedulerMaxPoolSize()});
        builder = builder.setIoThreads(ioThreads).setWorkerThreads(0).setDirectBuffers(configuration.coreModule().directBuffers()).setBufferSize(configuration.coreModule().bufferSize()).setHandler((HttpHandler)HANDLERS);
        builder.setServerOption(UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL, (Object)configuration.coreModule().allowUnescapedCharsInUrl());
        LOGGER.debug("Allow unescaped characters in URL: {}", (Object)configuration.coreModule().allowUnescapedCharsInUrl());
        Utils.setConnectionOptions((Undertow.Builder)builder, (Configuration)configuration);
        undertowServer = builder.build();
        undertowServer.start();
    }

    private static SSLContext initSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            TLSListener httpsListener = configuration.httpsListener();
            if (httpsListener.keystorePath() != null && httpsListener.keystorePwd() != null && httpsListener.certificatePwd() != null) {
                try (FileInputStream fis = new FileInputStream(new File(httpsListener.keystorePath()));){
                    ks.load(fis, httpsListener.keystorePwd().toCharArray());
                    kmf.init(ks, httpsListener.certificatePwd().toCharArray());
                }
            } else {
                Bootstrapper.logErrorAndExit("Cannot enable the HTTPS listener: the keystore is not configured. Generate a keystore and set the configuration options keystore-path, keystore-password and certificate-password. More information at https://restheart.org/docs/security/tls/", null, false, -1);
            }
            tmf.init(ks);
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return sslContext;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            Bootstrapper.logErrorAndExit("Couldn't start RESTHeart, error with specified keystore. Check the keystore-path, keystore-password and certificate-password options. Exiting..", ex, false, -1);
        }
        catch (FileNotFoundException ex) {
            Bootstrapper.logErrorAndExit("Couldn't start RESTHeart, keystore file not found. Check the keystore-path, keystore-password and certificate-password options. Exiting..", ex, false, -1);
        }
        catch (IOException ex) {
            Bootstrapper.logErrorAndExit("Couldn't start RESTHeart, error reading the keystore file. Check the keystore-path, keystore-password and certificate-password options. Exiting..", ex, false, -1);
        }
        return null;
    }

    private static void logErrorAndExit(String message, Throwable t, boolean silent, int status) {
        Bootstrapper.logErrorAndExit(message, t, silent, true, status);
    }

    private static GracefulShutdownHandler getPipeline(Set<PluginRecord<AuthMechanism>> authMechanisms, Set<PluginRecord<Authorizer>> authorizers, PluginRecord<TokenManager> tokenManager) {
        PluginsRegistryImpl.getInstance().getRootPathHandler().addPrefixPath("/", (HttpHandler)new RequestNotManagedHandler());
        LOGGER.debug("Content buffers maximun size is {} bytes", (Object)0x1000000);
        Bootstrapper.plugServices();
        Bootstrapper.plugProxies(configuration, authMechanisms, authorizers, tokenManager);
        Bootstrapper.plugStaticResourcesHandlers(configuration);
        return Bootstrapper.getBasePipeline();
    }

    private static GracefulShutdownHandler getBasePipeline() {
        return new GracefulShutdownHandler((HttpHandler)new AllowedMethodsHandler((HttpHandler)new ErrorHandler((PipelinedHandler)PipelinedWrappingHandler.wrap((HttpHandler)new HttpContinueAcceptingHandler((HttpHandler)PluginsRegistryImpl.getInstance().getRootPathHandler()))), new HttpString[]{HttpString.tryFromString((String)ExchangeKeys.METHOD.GET.name()), HttpString.tryFromString((String)ExchangeKeys.METHOD.POST.name()), HttpString.tryFromString((String)ExchangeKeys.METHOD.PUT.name()), HttpString.tryFromString((String)ExchangeKeys.METHOD.DELETE.name()), HttpString.tryFromString((String)ExchangeKeys.METHOD.PATCH.name()), HttpString.tryFromString((String)ExchangeKeys.METHOD.OPTIONS.name())}));
    }

    private static void plugServices() {
        PluginsRegistryImpl.getInstance().getServices().stream().filter(srv -> ((Service)srv.getInstance()).getClass().getDeclaredAnnotation(RegisterPlugin.class) != null).forEach(srv -> {
            String uri;
            Map srvConfArgs = srv.getConfArgs();
            RegisterPlugin.MATCH_POLICY mp = PluginUtils.uriMatchPolicy((Service)((Service)srv.getInstance()));
            if (srvConfArgs == null || !srvConfArgs.containsKey("uri") || srvConfArgs.get("uri") == null) {
                uri = PluginUtils.defaultURI((Service)((Service)srv.getInstance()));
            } else {
                if (!(srvConfArgs.get("uri") instanceof String)) {
                    LOGGER.error("Cannot start service {}: the configuration property 'uri' must be a string", (Object)srv.getName());
                    return;
                }
                uri = (String)srvConfArgs.get("uri");
            }
            if (uri == null) {
                LOGGER.error("Cannot start service {}: the configuration property 'uri' is not defined and the service does not have a default value", (Object)srv.getName());
                return;
            }
            if (!uri.startsWith("/")) {
                LOGGER.error("Cannot start service {}: the configuration property 'uri' must start with /", (Object)srv.getName(), (Object)uri);
                return;
            }
            boolean secured = srv.isSecure();
            PluginsRegistryImpl.getInstance().plugService((PluginRecord<Service<?, ?>>)srv, uri, mp, secured);
            LOGGER.info(Ansi.ansi().fg(Ansi.Color.GREEN).a("URI {} bound to service {}, secured: {}, uri match {}").reset().toString(), new Object[]{uri, srv.getName(), secured, mp});
        });
    }

    private static void plugProxies(Configuration conf, Set<PluginRecord<AuthMechanism>> authMechanisms, Set<PluginRecord<Authorizer>> authorizers, PluginRecord<TokenManager> tokenManager) {
        if (conf.getProxies() == null || conf.getProxies().isEmpty()) {
            LOGGER.debug("No proxy specified");
            return;
        }
        conf.getProxies().stream().forEachOrdered(proxy -> {
            if (proxy.location() == null || proxy.proxyPass() == null || proxy.proxyPass().isEmpty()) {
                LOGGER.warn("Invalid proxies entry: {}", proxy);
                return;
            }
            LoadBalancingProxyClient proxyClient = new LoadBalancingProxyClient().setConnectionsPerThread(proxy.connectionPerThread()).setSoftMaxConnectionsPerThread(proxy.softMaxConnectionsPerThread()).setMaxQueueSize(proxy.maxQueueSize()).setProblemServerRetry(proxy.problemServerRetry()).setTtl(proxy.connectionsTTL());
            proxy.proxyPass().stream().forEach(pp -> {
                try {
                    ThreadAwareByteBufferPool byteBufferPool = new ThreadAwareByteBufferPool(configuration.coreModule().directBuffers(), configuration.coreModule().bufferSize(), configuration.coreModule().buffersPooling());
                    UndertowXnioSsl xnioSsl = new UndertowXnioSsl(Xnio.getInstance(), OptionMap.EMPTY, (ByteBufferPool)byteBufferPool);
                    URI uri = new URI((String)pp);
                    proxyClient.addHost(uri, (XnioSsl)xnioSsl);
                }
                catch (URISyntaxException t) {
                    LOGGER.warn("Invalid location URI {}, resource {} not bound ", (Object)proxy.location(), pp);
                }
                catch (GeneralSecurityException ex) {
                    Bootstrapper.logErrorAndExit("error configuring ssl", ex, false, -13);
                }
            });
            ProxyHandler proxyHandler = ProxyHandler.builder().setRewriteHostHeader(proxy.rewriteHostHeader()).setProxyClient((ProxyClient)proxyClient).build();
            PipelinedHandler rhProxy = PipelinedHandler.pipe((PipelinedHandler[])new PipelinedHandler[]{new WorkingThreadsPoolDispatcher(), new PipelineInfoInjector(), new TracingInstrumentationHandler(), new RequestLogger(), new ProxyExchangeBuffersCloser(), new BeforeExchangeInitInterceptorsExecutor(), new RequestContentInjector(RequestContentInjector.Policy.ON_REQUIRES_CONTENT_BEFORE_AUTH), new RequestInterceptorsExecutor(InterceptPoint.REQUEST_BEFORE_AUTH), new QueryStringRebuilder(), new SecurityHandler(authMechanisms, authorizers, tokenManager), new AuthHeadersRemover(), new XForwardedHeadersInjector(), new RequestContentInjector(RequestContentInjector.Policy.ON_REQUIRES_CONTENT_AFTER_AUTH), new RequestInterceptorsExecutor(InterceptPoint.REQUEST_AFTER_AUTH), new QueryStringRebuilder(), new ConduitInjector(), PipelinedWrappingHandler.wrap((HttpHandler)new ConfigurableEncodingHandler((HttpHandler)proxyHandler))});
            PluginsRegistryImpl.getInstance().plugPipeline(proxy.location(), rhProxy, new PipelineInfo(PipelineInfo.PIPELINE_TYPE.PROXY, proxy.location(), proxy.name()));
            LOGGER.info(Ansi.ansi().fg(Ansi.Color.GREEN).a("URI {} bound to proxy resource {}").reset().toString(), (Object)proxy.location(), (Object)proxy.proxyPass());
        });
    }

    private static void plugStaticResourcesHandlers(Configuration conf) {
        if (conf.getStaticResources() == null || conf.getStaticResources().isEmpty()) {
            LOGGER.debug("No static resource specified");
            return;
        }
        conf.getStaticResources().stream().forEach(Bootstrapper::lambda$plugStaticResourcesHandlers$14);
    }

    private static void logErrorAndExit(String message, Throwable t, boolean silent, boolean removePid, int status) {
        if (t == null) {
            LOGGER.error(message);
        } else if (t instanceof ConfigurationException) {
            ConfigurationException ce = (ConfigurationException)t;
            if (ce.shoudlPrintStackTrace()) {
                LOGGER.error(message, t);
            } else {
                LOGGER.error(message);
            }
        } else {
            LOGGER.error(message, t);
        }
        Bootstrapper.stopServer(silent, removePid);
        System.exit(status);
    }

    private static void doNotWarnTruffleInterpreterOnly() {
        System.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$plugStaticResourcesHandlers$14(StaticResource sr) {
        try {
            if (sr.where() == null || !sr.where().startsWith("/")) {
                Bootstrapper.LOGGER.error("Cannot bind static resources {}. parameter 'where' must start with /", (Object)sr);
                return;
            }
            if (sr.what() == null) {
                Bootstrapper.LOGGER.error("Cannot bind static resources to {}. missing parameter 'what'", (Object)sr);
                return;
            }
            if (sr.embedded()) {
                if (sr.what() == null || sr.what().startsWith("/")) {
                    Bootstrapper.LOGGER.error("Cannot bind embedded static resources {}. parameter 'where'cannot start with /. the path is relative to the jar root dir or classpath directory", (Object)sr);
                    return;
                }
                try {
                    file = ResourcesExtractor.extract(Bootstrapper.class, (String)sr.what());
                    if (!ResourcesExtractor.isResourceInJar(Bootstrapper.class, (String)sr.what())) ** GOTO lbl29
                    Bootstrapper.TMP_EXTRACTED_FILES.put(sr.what(), file);
                    Bootstrapper.LOGGER.info("Embedded static resources {} extracted in {}", (Object)sr.what(), (Object)file.toString());
                }
                catch (IOException | IllegalStateException | URISyntaxException ex) {
                    Bootstrapper.LOGGER.error("Error extracting embedded static resource {}", (Object)sr.what(), (Object)ex);
                    return;
                }
            } else if (!sr.what().startsWith("/")) {
                location = Bootstrapper.class.getProtectionDomain().getCodeSource().getLocation();
                locationFile = new File(location.getPath());
                _path = Paths.get(locationFile.getParent().concat(File.separator).concat(sr.what()), new String[0]);
                file = _path.normalize().toFile();
            } else {
                file = new File(sr.what());
            }
lbl29:
            // 4 sources

            if (file.exists()) {
                handler = Handlers.resource((ResourceManager)new FileResourceManager(file, 3L)).addWelcomeFiles(new String[]{sr.welcomeFile()}).setDirectoryListingEnabled(false);
                ph = PipelinedHandler.pipe((PipelinedHandler[])new PipelinedHandler[]{new PipelineInfoInjector(), new RequestLogger(), new WorkingThreadsPoolDispatcher((PipelinedHandler)PipelinedWrappingHandler.wrap((HttpHandler)handler))});
                PluginsRegistryImpl.getInstance().plugPipeline(sr.where(), ph, new PipelineInfo(PipelineInfo.PIPELINE_TYPE.STATIC_RESOURCE, sr.where(), sr.what()));
                Bootstrapper.LOGGER.info(Ansi.ansi().fg(Ansi.Color.GREEN).a("URI {} bound to static resource {}").reset().toString(), (Object)sr.where(), (Object)file.getAbsolutePath());
            } else {
                Bootstrapper.LOGGER.error("Failed to bind URL {} to static resources {}. Directory does not exist.", (Object)sr.where(), (Object)sr.what());
            }
        }
        catch (Throwable t) {
            Bootstrapper.LOGGER.error("Cannot bind static resource", (Object)sr, (Object)t);
        }
    }

    static {
        TMP_EXTRACTED_FILES = new HashMap<String, File>();
        printConfiguration = false;
        printConfigurationTemplate = false;
        standaloneConfiguration = false;
        HANDLERS = null;
    }

    @CommandLine.Command(name="java -jar restheart.jar")
    private static class Args {
        @CommandLine.Parameters(index="0", arity="0..1", paramLabel="CONF_FILE", description={"Main configuration file"})
        private String configPath = null;
        @CommandLine.Option(names={"--fork"}, description={"Fork the process in background"})
        private boolean isForked = false;
        @CommandLine.Option(names={"-o", "--rho"}, paramLabel="RHO_FILE", description={"Configuration overrides file"})
        private String rho = null;
        @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"This help message"})
        private boolean help = false;
        @CommandLine.Option(names={"-c", "--printConfiguration"}, description={"Print the effective configuration to the standard error and exit"})
        private boolean printConfiguration = false;
        @CommandLine.Option(names={"-t", "--printConfigurationTemplate"}, description={"Print the configuration template to the standard error and exit"})
        private boolean printConfigurationTemplate = false;
        @CommandLine.Option(names={"-v", "--version"}, versionHelp=true, description={"Print product version to the output stream and exit"})
        boolean versionRequested;
        @CommandLine.Option(names={"-s", "--standalone"}, description={"Use an alternate configuration that disables all plugins depending from MongoDb"})
        boolean standalone;

        private Args() {
        }
    }
}

