/*
 * Decompiled with CFR 0.152.
 */
package org.restheart;

import com.sun.akuma.CLibrary;
import java.nio.file.Path;
import org.restheart.configuration.Configuration;
import org.restheart.configuration.ConfigurationException;
import org.restheart.utils.FileUtils;
import org.restheart.utils.OSChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shutdowner {
    private static final Logger LOGGER = LoggerFactory.getLogger(Shutdowner.class);

    public static void main(String[] args) {
        if (Shutdowner.askingForHelp(args)) {
            Shutdowner.printHelp();
            System.exit(0);
        }
        if (OSChecker.isWindows()) {
            LOGGER.error("shutdown is not supported on windows.");
            System.exit(-5);
        }
        try {
            Shutdowner.shutdown(args);
        }
        catch (IllegalStateException ise) {
            LOGGER.error("RESTHeart instance pid file not found.");
            Shutdowner.printHelp();
        }
    }

    protected static void shutdown(String[] args) {
        if (FileUtils.getConfigurationFilePath(args) == null) {
            LOGGER.info("Shutting down RESTHeart instance run without configuration file");
        } else if (FileUtils.getOverrideFilePath(args) == null) {
            LOGGER.info("Shutting down RESTHeart instance run with configuration file {}", (Object)FileUtils.getConfigurationFilePath(args));
        } else {
            LOGGER.info("Shutting down RESTHeart instance run with configuration file {} and override file {}", (Object)FileUtils.getConfigurationFilePath(args), (Object)FileUtils.getOverrideFilePath(args));
        }
        Path pidFilePath = FileUtils.getPidFilePath(FileUtils.getFileAbsolutePathHash(FileUtils.getConfigurationFilePath(args), FileUtils.getOverrideFilePath(args)));
        int pid = FileUtils.getPidFromFile(pidFilePath);
        if (pid < 0) {
            throw new IllegalStateException("RESTHeart instance pid file not found: " + pidFilePath.toString());
        }
        LOGGER.info("Pid file {}", (Object)pidFilePath);
        CLibrary.LIBC.kill(pid, 15);
        LOGGER.info("SIGTERM signal sent to RESTHeart instance with pid {} ", (Object)pid);
        try {
            Configuration conf = FileUtils.getConfiguration(args, true);
            LOGGER.info("Check log file {}", (Object)conf.logging().logFilePath());
        }
        catch (ConfigurationException ex) {
            LOGGER.warn(ex.getMessage());
        }
    }

    private static boolean askingForHelp(String[] args) {
        for (String arg : args) {
            if (!arg.equals("--help")) continue;
            return true;
        }
        return false;
    }

    static void printHelp() {
        LOGGER.info("usage: java -cp restheart.jar org.restheart.Shutdowner [configuration file] [-e properties file].");
        LOGGER.info("java -cp restheart.jar org.restheart.Shutdowner --help \u2192 prints this help message and exits.");
        LOGGER.info("java -cp restheart.jar org.restheart.Shutdowner \u2192 shutdown RESTHeart instance run without specifying the configuration file.");
        LOGGER.info(" java -cp restheart.jar org.restheart.Shutdowner restheart.yml -e default.properties \u2192 shutdown RESTHeart instance run with configuration and properties files.");
        LOGGER.info("NOTE: shutdown is not supported on windows.");
    }

    private Shutdowner() {
    }
}

