/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.buffers;

import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import org.restheart.buffers.SlimPooledBuffer;

public class NotPoolingByteBufferPool
implements ByteBufferPool {
    private final boolean direct;
    private final int bufferSize;

    public NotPoolingByteBufferPool(boolean direct, int bufferSize) {
        this.direct = direct;
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public PooledByteBuffer allocate() {
        return new SlimPooledBuffer(this.direct, this.bufferSize);
    }

    public NotPoolingByteBufferPool getArrayBackedPool() {
        return this;
    }

    public void close() {
    }
}

