/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.buffers;

import io.undertow.connector.PooledByteBuffer;
import java.nio.ByteBuffer;

public class SlimPooledBuffer
implements PooledByteBuffer {
    private boolean open;
    private final ByteBuffer buffer;

    public SlimPooledBuffer(boolean direct, int bufferSize) {
        this.buffer = direct ? ByteBuffer.allocateDirect(bufferSize) : ByteBuffer.allocate(bufferSize);
        this.open = false;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void close() {
        this.open = false;
    }

    public void open() {
        this.open = true;
    }

    public boolean isOpen() {
        return this.open;
    }

    public String toString() {
        return "SlimPooledBuffer{buffer=" + String.valueOf(this.buffer) + ", open=" + this.open + "}";
    }
}

