/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.buffers;

import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.DefaultByteBufferPool;
import org.restheart.buffers.NotPoolingByteBufferPool;

public class ThreadAwareByteBufferPool
implements ByteBufferPool {
    private final DefaultByteBufferPool undertowDefaultByteBufferPool;
    private final NotPoolingByteBufferPool notPoolingByteBufferPool;
    private final boolean enablePooling;

    public ThreadAwareByteBufferPool(boolean direct, int bufferSize, boolean enablePooling) {
        this.undertowDefaultByteBufferPool = enablePooling ? new DefaultByteBufferPool(direct, bufferSize, -1, 4) : null;
        this.notPoolingByteBufferPool = new NotPoolingByteBufferPool(false, bufferSize);
        this.enablePooling = enablePooling;
    }

    public int getBufferSize() {
        return this.notPoolingByteBufferPool.getBufferSize();
    }

    public boolean isDirect() {
        return this.notPoolingByteBufferPool.isDirect();
    }

    public PooledByteBuffer allocate() {
        return !this.enablePooling || Thread.currentThread().isVirtual() ? this.notPoolingByteBufferPool.allocate() : this.undertowDefaultByteBufferPool.allocate();
    }

    public ByteBufferPool getArrayBackedPool() {
        return !this.enablePooling || Thread.currentThread().isVirtual() ? this.notPoolingByteBufferPool.getArrayBackedPool() : this.undertowDefaultByteBufferPool.getArrayBackedPool();
    }

    public void close() {
        if (this.enablePooling && !Thread.currentThread().isVirtual()) {
            this.undertowDefaultByteBufferPool.close();
        }
    }
}

