/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers;

import io.undertow.server.HttpServerExchange;
import java.util.List;
import org.restheart.exchange.ByteArrayProxyRequest;
import org.restheart.exchange.ByteArrayProxyResponse;
import org.restheart.exchange.Exchange;
import org.restheart.exchange.Request;
import org.restheart.exchange.Response;
import org.restheart.exchange.ServiceRequest;
import org.restheart.exchange.ServiceResponse;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.handlers.ResponseSender;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.Interceptor;
import org.restheart.plugins.InterceptorException;
import org.restheart.plugins.Plugin;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.PluginsRegistryImpl;
import org.restheart.plugins.Service;
import org.restheart.utils.LambdaUtils;
import org.restheart.utils.PluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestInterceptorsExecutor
extends PipelinedHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestInterceptorsExecutor.class);
    private final ResponseSender sender = new ResponseSender();
    private final InterceptPoint interceptPoint;
    private final PluginsRegistry pluginsRegistry = PluginsRegistryImpl.getInstance();

    public RequestInterceptorsExecutor(InterceptPoint interceptPoint) {
        super(null);
        this.interceptPoint = interceptPoint;
    }

    public RequestInterceptorsExecutor(PipelinedHandler next, InterceptPoint interceptPoint) {
        super(next);
        this.interceptPoint = interceptPoint;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        List interceptors;
        ByteArrayProxyResponse response;
        ByteArrayProxyRequest request;
        Service handlingService = PluginUtils.handlingService((PluginsRegistry)this.pluginsRegistry, (HttpServerExchange)exchange);
        if (handlingService != null) {
            request = ServiceRequest.of((HttpServerExchange)exchange, ServiceRequest.class);
            response = ServiceResponse.of((HttpServerExchange)exchange, ServiceResponse.class);
            interceptors = this.pluginsRegistry.getServiceInterceptors(handlingService, this.interceptPoint);
        } else {
            request = ByteArrayProxyRequest.of((HttpServerExchange)exchange);
            response = ByteArrayProxyResponse.of((HttpServerExchange)exchange);
            interceptors = this.pluginsRegistry.getProxyInterceptors(this.interceptPoint);
        }
        interceptors.stream().filter(ri -> ri instanceof Interceptor).map(ri -> ri).filter(arg_0 -> this.lambda$handleRequest$2((Request)request, (Response)response, exchange, arg_0)).forEachOrdered(arg_0 -> this.lambda$handleRequest$3(exchange, (Request)request, (Response)response, arg_0));
        if (this.interceptPoint == InterceptPoint.REQUEST_AFTER_AUTH && Exchange.isInError((HttpServerExchange)exchange)) {
            if (response.getStatusCode() < 0) {
                response.setStatusCode(400);
            }
            if (handlingService != null && request.isOptions()) {
                handlingService.handleOptions(ServiceRequest.of((HttpServerExchange)exchange, ServiceRequest.class));
            }
            this.sender.handleRequest(exchange);
        } else {
            this.next(exchange);
        }
    }

    private /* synthetic */ void lambda$handleRequest$3(HttpServerExchange exchange, Request request, Response response, Interceptor ri) {
        try {
            LOGGER.debug("Executing interceptor {} for {} on intercept point {}", new Object[]{PluginUtils.name((Plugin)ri), exchange.getRequestPath(), this.interceptPoint});
            ri.handle(request, response);
        }
        catch (Exception ex) {
            LOGGER.error("Error executing interceptor {} for {} on intercept point {}", new Object[]{PluginUtils.name((Plugin)ri), exchange.getRequestPath(), this.interceptPoint, ex});
            Exchange.setInError((HttpServerExchange)exchange);
            LambdaUtils.throwsSneakyException((Throwable)new InterceptorException("Error executing interceptor " + ri.getClass().getSimpleName(), (Throwable)ex));
        }
    }

    private /* synthetic */ boolean lambda$handleRequest$2(Request request, Response response, HttpServerExchange exchange, Interceptor ri) {
        try {
            return ri.resolve(request, response);
        }
        catch (Exception ex) {
            LOGGER.warn("Error resolving interceptor {} for {} on intercept point {}", new Object[]{ri.getClass().getSimpleName(), exchange.getRequestPath(), this.interceptPoint, ex});
            Exchange.setInError((HttpServerExchange)exchange);
            LambdaUtils.throwsSneakyException((Throwable)new InterceptorException("Error resolving interceptor " + ri.getClass().getSimpleName(), (Throwable)ex));
            return false;
        }
    }
}

