/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.LocaleUtils;
import io.undertow.util.QueryParameterUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.fusesource.jansi.Ansi;
import org.restheart.Bootstrapper;
import org.restheart.configuration.Configuration;
import org.restheart.exchange.ByteArrayProxyResponse;
import org.restheart.exchange.JsonProxyRequest;
import org.restheart.exchange.PipelineInfo;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.plugins.security.TokenManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class RequestLogger
extends PipelinedHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestLogger.class);
    private final Configuration configuration = Bootstrapper.getConfiguration();

    public RequestLogger() {
    }

    public RequestLogger(PipelinedHandler next) {
        super(next);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.configuration.logging().requestsLogMode() > 0 && LOGGER.isInfoEnabled()) {
            this.dumpExchange(exchange, this.configuration.logging().requestsLogMode());
        }
        this.next(exchange);
    }

    protected void dumpExchange(HttpServerExchange exchange, Integer logLevel) {
        long start;
        if (logLevel < 1) {
            return;
        }
        JsonProxyRequest request = JsonProxyRequest.of((HttpServerExchange)exchange);
        StringBuilder sb = new StringBuilder();
        long l = start = request != null && request.getStartTime() != null ? request.getStartTime() : System.currentTimeMillis();
        if (logLevel == 1) {
            sb.append(exchange.getRequestMethod()).append(" ").append(exchange.getRequestURL());
            if (exchange.getQueryString() != null && !exchange.getQueryString().isEmpty()) {
                try {
                    sb.append("?").append(URLDecoder.decode(exchange.getQueryString(), QueryParameterUtils.getQueryParamEncoding((HttpServerExchange)exchange)));
                }
                catch (UnsupportedEncodingException uee) {
                    sb.append("?").append(exchange.getQueryString());
                }
            }
            sb.append(" from ").append(exchange.getSourceAddress());
        } else if (logLevel >= 2) {
            PipelineInfo pb;
            sb.append("\n----------------------------REQUEST---------------------------\n");
            sb.append("               URI=").append(exchange.getRequestURI()).append("\n");
            PipelineInfo pipelineInfo = pb = request == null ? null : request.getPipelineInfo();
            if (pb != null) {
                sb.append("          servedBy=").append(pb.getType().name().toLowerCase()).append(" ");
                if (pb.getName() != null) {
                    sb.append("'").append(pb.getName()).append("' ");
                }
                sb.append("bound to '").append(pb.getUri()).append("'\n");
            }
            sb.append(" characterEncoding=").append(exchange.getRequestHeaders().get(Headers.CONTENT_ENCODING)).append("\n");
            sb.append("     contentLength=").append(exchange.getRequestContentLength()).append("\n");
            sb.append("       contentType=").append(exchange.getRequestHeaders().get(Headers.CONTENT_TYPE)).append("\n");
            Map cookies = exchange.getRequestCookies();
            if (cookies != null) {
                cookies.entrySet().stream().map(entry -> (Cookie)entry.getValue()).forEach(cookie -> sb.append("            cookie=").append(cookie.getName()).append("=").append(cookie.getValue()).append("\n"));
            }
            for (HeaderValues header : exchange.getRequestHeaders()) {
                header.stream().forEach(value -> {
                    if (header.getHeaderName() != null && "Authorization".equalsIgnoreCase(header.getHeaderName().toString())) {
                        value = "**********";
                    }
                    sb.append("            header=").append(header.getHeaderName()).append("=").append((String)value).append("\n");
                });
            }
            sb.append("            locale=").append(LocaleUtils.getLocalesFromHeader((List)exchange.getRequestHeaders().get(Headers.ACCEPT_LANGUAGE))).append("\n");
            sb.append("            method=").append(exchange.getRequestMethod()).append("\n");
            Map pnames = exchange.getQueryParameters();
            pnames.entrySet().stream().map(entry -> {
                String pname = (String)entry.getKey();
                Iterator pvalues = ((Deque)entry.getValue()).iterator();
                sb.append("         parameter=");
                sb.append(pname);
                sb.append('=');
                while (pvalues.hasNext()) {
                    sb.append((String)pvalues.next());
                    if (!pvalues.hasNext()) continue;
                    sb.append(", ");
                }
                return entry;
            }).forEach(_item -> sb.append("\n"));
            sb.append("          protocol=").append(exchange.getProtocol()).append("\n");
            sb.append("       queryString=").append(exchange.getQueryString()).append("\n");
            sb.append("        remoteAddr=").append(exchange.getSourceAddress()).append("\n");
            sb.append("        remoteHost=").append(exchange.getSourceAddress().getHostName()).append("\n");
            sb.append("            scheme=").append(exchange.getRequestScheme()).append("\n");
            sb.append("              host=").append(exchange.getRequestHeaders().getFirst(Headers.HOST)).append("\n");
            sb.append("        serverPort=").append(exchange.getDestinationAddress().getPort()).append("\n");
        }
        this.addExchangeCompleteListener(exchange, logLevel, sb, start);
    }

    private void addExchangeCompleteListener(HttpServerExchange exchange, Integer logLevel, StringBuilder sb, long start) {
        exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
            if (logLevel < 1) {
                return;
            }
            Map mdcCtx = ByteArrayProxyResponse.of((HttpServerExchange)exchange).getMDCContext();
            if (mdcCtx != null) {
                MDC.setContextMap((Map)mdcCtx);
            }
            SecurityContext sc = exchange1.getSecurityContext();
            if (logLevel == 1) {
                sb.append(" =>").append(" status=");
                if (exchange.getStatusCode() >= 300 && exchange.getStatusCode() != 304) {
                    sb.append(Ansi.ansi().fg(Ansi.Color.RED).bold().a(exchange.getStatusCode()).reset().toString());
                } else {
                    sb.append(Ansi.ansi().fg(Ansi.Color.GREEN).bold().a(exchange.getStatusCode()).reset().toString());
                }
                sb.append(" elapsed=").append(System.currentTimeMillis() - start).append("ms").append(" contentLength=").append(exchange1.getResponseContentLength());
                if (sc != null && sc.getAuthenticatedAccount() != null) {
                    sb.append(" ").append(sc.getAuthenticatedAccount().toString());
                }
            } else if (logLevel >= 2) {
                sb.append("--------------------------RESPONSE--------------------------\n");
                if (sc != null) {
                    if (sc.isAuthenticated()) {
                        sb.append("          authType=").append(sc.getMechanismName()).append("\n");
                        sb.append("          account=").append(sc.getAuthenticatedAccount().toString()).append("\n");
                    } else {
                        sb.append("          authType=none\n");
                    }
                }
                sb.append("     contentLength=").append(exchange1.getResponseContentLength()).append("\n");
                sb.append("       contentType=").append(exchange1.getResponseHeaders().getFirst(Headers.CONTENT_TYPE)).append("\n");
                Map cookies1 = exchange1.getResponseCookies();
                if (cookies1 != null) {
                    cookies1.values().stream().forEach(cookie -> sb.append("            cookie=").append(cookie.getName()).append("=").append(cookie.getValue()).append("; domain=").append(cookie.getDomain()).append("; path=").append(cookie.getPath()).append("\n"));
                }
                for (HeaderValues header : exchange1.getResponseHeaders()) {
                    header.stream().forEach(value -> {
                        if (header.getHeaderName() != null && TokenManager.AUTH_TOKEN_HEADER.toString().equalsIgnoreCase(header.getHeaderName().toString())) {
                            value = "**********";
                        }
                        sb.append("            header=").append(header.getHeaderName()).append("=").append((String)value).append("\n");
                    });
                }
                sb.append("            status=");
                if (exchange.getStatusCode() >= 300) {
                    sb.append(Ansi.ansi().fg(Ansi.Color.RED).bold().a(exchange1.getStatusCode()).reset().toString());
                } else {
                    sb.append(Ansi.ansi().fg(Ansi.Color.GREEN).bold().a(exchange1.getStatusCode()).reset().toString());
                }
                sb.append("\n");
                sb.append("           elapsed=").append(System.currentTimeMillis() - start).append("ms\n");
                sb.append("==============================================================");
            }
            nextListener.proceed();
            LOGGER.info(sb.toString());
        });
    }
}

