/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers.injectors;

import io.undertow.security.idm.Account;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.HttpServerExchange;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.plugins.security.TokenManager;

public class TokenInjector
extends PipelinedHandler {
    private final TokenManager tokenManager;

    public TokenInjector(PipelinedHandler next, TokenManager tokenManager) {
        super(next);
        this.tokenManager = tokenManager;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.tokenManager != null && exchange.getSecurityContext() != null && exchange.getSecurityContext().isAuthenticated()) {
            Account authenticatedAccount = exchange.getSecurityContext().getAuthenticatedAccount();
            PasswordCredential token = this.tokenManager.get(authenticatedAccount);
            this.tokenManager.injectTokenHeaders(exchange, token);
        }
        this.next(exchange);
    }
}

