/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers.injectors;

import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.List;
import java.util.Map;
import org.restheart.exchange.Request;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.security.BaseAccount;

public class XForwardedHeadersInjector
extends PipelinedHandler {
    public static HttpString getXForwardedHeaderName(String suffix) {
        return HttpString.tryFromString((String)"X-Forwarded-".concat(suffix));
    }

    public static HttpString getXForwardedAccountIdHeaderName() {
        return XForwardedHeadersInjector.getXForwardedHeaderName("Account-Id");
    }

    public static HttpString getXForwardedRolesHeaderName() {
        return XForwardedHeadersInjector.getXForwardedHeaderName("Account-Roles");
    }

    public XForwardedHeadersInjector(PipelinedHandler next) {
        super(next);
    }

    public XForwardedHeadersInjector() {
        super(null);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange != null && exchange.getSecurityContext() != null && exchange.getSecurityContext().getAuthenticatedAccount() != null) {
            Account a = exchange.getSecurityContext().getAuthenticatedAccount();
            exchange.getRequestHeaders().remove(XForwardedHeadersInjector.getXForwardedAccountIdHeaderName());
            exchange.getRequestHeaders().remove(XForwardedHeadersInjector.getXForwardedRolesHeaderName());
            Map xfhs = Request.of((HttpServerExchange)exchange).getXForwardedHeaders();
            if (xfhs != null) {
                xfhs.entrySet().stream().forEachOrdered(m -> exchange.getRequestHeaders().remove((String)m.getKey()));
            }
            if (a.getPrincipal() != null) {
                exchange.getRequestHeaders().add(XForwardedHeadersInjector.getXForwardedAccountIdHeaderName(), a.getPrincipal().getName());
            }
            if (a instanceof BaseAccount && ((BaseAccount)a).getRoles() != null) {
                ((BaseAccount)a).getRoles().stream().forEachOrdered(role -> exchange.getRequestHeaders().add(XForwardedHeadersInjector.getXForwardedRolesHeaderName(), role));
            }
            if (xfhs != null) {
                xfhs.entrySet().stream().forEachOrdered(m -> ((List)m.getValue()).stream().forEachOrdered(v -> exchange.getRequestHeaders().put(XForwardedHeadersInjector.getXForwardedHeaderName((String)m.getKey()), v)));
            }
        }
        this.next(exchange);
    }
}

