/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.plugins;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.restheart.Bootstrapper;
import org.restheart.configuration.Configuration;
import org.restheart.configuration.ConfigurationException;
import org.restheart.configuration.Utils;
import org.restheart.plugins.FieldInjectionDescriptor;
import org.restheart.plugins.Initializer;
import org.restheart.plugins.Interceptor;
import org.restheart.plugins.MethodInjectionDescriptor;
import org.restheart.plugins.NoProviderException;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.Plugin;
import org.restheart.plugins.PluginDescriptor;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsClassloader;
import org.restheart.plugins.PluginsScanner;
import org.restheart.plugins.Provider;
import org.restheart.plugins.ProvidersChecker;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.Service;
import org.restheart.plugins.security.AuthMechanism;
import org.restheart.plugins.security.Authenticator;
import org.restheart.plugins.security.Authorizer;
import org.restheart.plugins.security.TokenManager;
import org.restheart.utils.PluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginsFactory.class);
    private static final PluginsFactory SINGLETON = new PluginsFactory();
    private Set<PluginRecord<AuthMechanism>> authMechanismsCache = null;
    private Set<PluginRecord<Authenticator>> authenticatorsCache = null;
    private Set<PluginRecord<Authorizer>> authorizersCache = null;
    private PluginRecord<TokenManager> tokenManagerCache = null;
    private Set<PluginRecord<Initializer>> initializersCache = null;
    private Set<PluginRecord<Interceptor<?, ?>>> interceptorsCache = null;
    private Set<PluginRecord<Service<?, ?>>> servicesCache = null;
    private Set<PluginDescriptor> validProviders = null;
    private Set<PluginRecord<Provider<?>>> providersCache = null;
    private static final Map<String, Class<?>> providersTypes = new HashMap();
    Map<String, Class<Plugin>> PC_CACHE = new HashMap<String, Class<Plugin>>();
    private final List<InstatiatedPlugin> PLUGINS_TO_INJECT_DEPS = new ArrayList<InstatiatedPlugin>();
    private final HashMap<String, PluginRecord<?>> INSTANTIATED_PLUGINS_RECORDS = new HashMap();

    public static PluginsFactory getInstance() {
        return SINGLETON;
    }

    private PluginsFactory() {
    }

    Set<PluginRecord<AuthMechanism>> authMechanisms() {
        if (this.authMechanismsCache == null) {
            List<PluginDescriptor> validPlugins = PluginsScanner.authMechanisms().stream().filter(p -> ProvidersChecker.checkDependencies(LOGGER, this.validProviders, p)).collect(Collectors.toList());
            this.authMechanismsCache = this.createPlugins(validPlugins, "Authentication Mechanism", Bootstrapper.getConfiguration());
        }
        return this.authMechanismsCache;
    }

    Set<PluginRecord<Authenticator>> authenticators() {
        if (this.authenticatorsCache == null) {
            List<PluginDescriptor> validPlugins = PluginsScanner.authenticators().stream().filter(p -> ProvidersChecker.checkDependencies(LOGGER, this.validProviders, p)).collect(Collectors.toList());
            this.authenticatorsCache = this.createPlugins(validPlugins, "Authenticator", Bootstrapper.getConfiguration());
        }
        return this.authenticatorsCache;
    }

    Set<PluginRecord<Authorizer>> authorizers() {
        if (this.authorizersCache == null) {
            List<PluginDescriptor> validPlugins = PluginsScanner.authorizers().stream().filter(p -> ProvidersChecker.checkDependencies(LOGGER, this.validProviders, p)).collect(Collectors.toList());
            this.authorizersCache = this.createPlugins(validPlugins, "Authorizer", Bootstrapper.getConfiguration());
        }
        return this.authorizersCache;
    }

    PluginRecord<TokenManager> tokenManager() {
        Optional<PluginRecord> tkm;
        List<PluginDescriptor> validPlugins;
        Set tkms;
        if (this.tokenManagerCache == null && (tkms = this.createPlugins(validPlugins = PluginsScanner.tokenManagers().stream().filter(p -> ProvidersChecker.checkDependencies(LOGGER, this.validProviders, p)).collect(Collectors.toList()), "Token Manager", Bootstrapper.getConfiguration())) != null && (tkm = tkms.stream().filter(t -> t.isEnabled()).findFirst()) != null && tkm.isPresent()) {
            this.tokenManagerCache = tkm.get();
        }
        return this.tokenManagerCache;
    }

    Set<PluginRecord<Initializer>> initializers() {
        if (this.initializersCache == null) {
            List<PluginDescriptor> validPlugins = PluginsScanner.initializers().stream().filter(p -> ProvidersChecker.checkDependencies(LOGGER, this.validProviders, p)).collect(Collectors.toList());
            this.initializersCache = this.createPlugins(validPlugins, "Initializer", Bootstrapper.getConfiguration());
        }
        return this.initializersCache;
    }

    Set<PluginRecord<Interceptor<?, ?>>> interceptors() {
        if (this.interceptorsCache == null) {
            List<PluginDescriptor> validPlugins = PluginsScanner.interceptors().stream().filter(p -> ProvidersChecker.checkDependencies(LOGGER, this.validProviders, p)).collect(Collectors.toList());
            this.interceptorsCache = this.createPlugins(validPlugins, "Interceptor", Bootstrapper.getConfiguration());
        }
        return this.interceptorsCache;
    }

    Set<PluginRecord<Service<?, ?>>> services() {
        if (this.servicesCache == null) {
            List<PluginDescriptor> validPlugins = PluginsScanner.services().stream().filter(p -> ProvidersChecker.checkDependencies(LOGGER, this.validProviders, p)).collect(Collectors.toList());
            this.servicesCache = this.createPlugins(validPlugins, "Service", Bootstrapper.getConfiguration());
        }
        return this.servicesCache;
    }

    Set<PluginRecord<Provider<?>>> providers() {
        if (this.providersCache == null) {
            Set providers = this.createPlugins(PluginsScanner.providers(), "Provider", Bootstrapper.getConfiguration());
            providers.stream().forEach(p -> providersTypes.put(p.getName(), ((Provider)p.getInstance()).rawType()));
            this.validProviders = ProvidersChecker.validProviders(LOGGER, PluginsScanner.providers());
            this.providersCache = this.validProviders.stream().map(pd -> providers.stream().filter(p -> p.getClassName().equals(pd.clazz())).findFirst()).filter(p -> p.isPresent()).map(p -> (PluginRecord)p.get()).collect(Collectors.toSet());
        }
        return this.providersCache;
    }

    static Map<String, Class<?>> providersTypes() {
        if (!PluginsScanner.providers().isEmpty() && providersTypes.keySet().isEmpty()) {
            throw new IllegalStateException("providersTypes are available only after providers instantiation happening in method providers()");
        }
        return providersTypes;
    }

    private <T extends Plugin> Set<PluginRecord<T>> createPlugins(List<PluginDescriptor> pluginDescriptors, String type, Configuration conf) {
        LinkedHashSet ret = new LinkedHashSet();
        pluginDescriptors.sort((cd1, cd2) -> {
            try {
                Class<Plugin> clazz1 = this.loadPluginClass((PluginDescriptor)cd1);
                Class<Plugin> clazz2 = this.loadPluginClass((PluginDescriptor)cd2);
                return Integer.compare(this.priority(clazz1), this.priority(clazz2));
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.error("error sorting {} plugins by priority", (Object)type, (Object)cnfe);
                return -1;
            }
        });
        pluginDescriptors.stream().forEachOrdered(plugin -> {
            try {
                Class<Plugin> clazz = this.loadPluginClass((PluginDescriptor)plugin);
                String name = this.name(clazz);
                String description = this.description(clazz);
                Boolean secure = this.secure(clazz);
                Boolean enabledByDefault = this.enabledByDefault(clazz);
                Map pluginConf = (Map)Utils.getOrDefault((Configuration)conf, (String)name, null, (boolean)true);
                boolean enabled = PluginRecord.isEnabled((boolean)enabledByDefault, (Map)pluginConf);
                if (enabled) {
                    Plugin i = this.instantiatePlugin(clazz, type, name, conf);
                    PluginRecord pr = new PluginRecord(name, description, secure.booleanValue(), enabledByDefault.booleanValue(), clazz.getName(), i, pluginConf);
                    this.INSTANTIATED_PLUGINS_RECORDS.put(i.getClass().getName(), pr);
                    if (pr.isEnabled()) {
                        ret.add(pr);
                        LOGGER.debug("Registered {} {}: {}", new Object[]{type, name, description});
                        if (!plugin.injections().isEmpty()) {
                            InstatiatedPlugin ip = new InstatiatedPlugin(name, type, (PluginDescriptor)plugin, clazz, i);
                            this.PLUGINS_TO_INJECT_DEPS.add(ip);
                        }
                    }
                } else {
                    LOGGER.debug("{} {} is disabled", (Object)type, (Object)name);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException | ConfigurationException e) {
                LOGGER.error("Error registering {} {}: {}", new Object[]{type, plugin.clazz(), this.getRootException(e).getMessage(), e});
            }
        });
        return ret;
    }

    private Class<Plugin> loadPluginClass(PluginDescriptor plugin) throws ClassNotFoundException {
        if (this.PC_CACHE.containsKey(plugin.clazz())) {
            return this.PC_CACHE.get(plugin.clazz());
        }
        return PluginsClassloader.getInstance().loadClass(plugin.clazz());
    }

    private Plugin instantiatePlugin(Class<Plugin> pc, String pluginType, String pluginName, Configuration conf) throws InstantiationException, IllegalAccessException, InvocationTargetException, IllegalArgumentException, SecurityException, ClassNotFoundException {
        try {
            return pc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException nme) {
            throw new ConfigurationException(pluginType + " " + pluginName + " does not have default constructor " + pc.getSimpleName() + "()");
        }
    }

    void injectDependencies() {
        for (InstatiatedPlugin ip : this.PLUGINS_TO_INJECT_DEPS) {
            try {
                this.inject(ip);
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() != null && ite.getCause() instanceof NoClassDefFoundError) {
                    String errMsg = "An external dependency is missing for " + ip.type + " " + ip.name + ". Copying the missing dependency jar into the plugins directory should fix the error";
                    LOGGER.error(errMsg, (Throwable)ite);
                    continue;
                }
                LOGGER.error("Error injecting dependency into {} {}: {}", new Object[]{ip.type, ip.name, this.getRootException(ite).getMessage(), ite});
            }
            catch (NoProviderException npe) {
                LOGGER.error("Error injecting dependency into {} {}: {}", new Object[]{ip.type, ip.name, npe.getMessage()});
            }
            catch (IllegalAccessException | InstantiationException ex) {
                LOGGER.error("Error injecting dependency into {} {}: {}", new Object[]{ip.type, ip.name, this.getRootException(ex).getMessage(), ex});
            }
        }
    }

    private void inject(InstatiatedPlugin ip) throws NoProviderException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.setInjectFields(ip);
        this.invokeOnInitMethods(ip);
    }

    private void setInjectFields(InstatiatedPlugin ip) throws NoProviderException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList injections = new ArrayList();
        ip.descriptor.injections().stream().filter(i -> i instanceof FieldInjectionDescriptor).map(i -> (FieldInjectionDescriptor)i).forEach(injections::add);
        for (FieldInjectionDescriptor injection : injections) {
            try {
                Field field = ip.clazz.getDeclaredField(injection.field());
                Object providerName = injection.annotationParams().get(0).getValue();
                Optional<PluginRecord> _provider = this.providers().stream().filter(p -> p.getName().equals(providerName)).findFirst();
                if (_provider.isPresent()) {
                    Object value = ((Provider)_provider.get().getInstance()).get(this.INSTANTIATED_PLUGINS_RECORDS.get(ip.clazz.getName()));
                    field.setAccessible(true);
                    LOGGER.debug("Injecting {} into field {} of class {}", new Object[]{PluginUtils.name((Plugin)_provider.get().getInstance()), field.getName(), ip.instance.getClass().getName()});
                    field.set(ip.instance, value);
                    continue;
                }
                throw new NoProviderException("no provider found for @Inject(\"" + String.valueOf(providerName) + "\")");
            }
            catch (NoSuchFieldException nsfe) {
                throw new InvocationTargetException(nsfe);
            }
        }
    }

    private void invokeOnInitMethods(InstatiatedPlugin ip) throws ConfigurationException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList injections = new ArrayList();
        ip.descriptor.injections().stream().filter(i -> i instanceof MethodInjectionDescriptor).map(i -> (MethodInjectionDescriptor)i).forEach(injections::add);
        for (MethodInjectionDescriptor injection : injections) {
            if (!OnInit.class.equals(injection.clazz()) || ip.descriptor.injections().stream().filter(p -> p instanceof MethodInjectionDescriptor).map(p -> (MethodInjectionDescriptor)p).filter(p -> p.methodHash() == injection.methodHash()).count() != 1L) continue;
            try {
                ip.clazz.getDeclaredMethod(injection.method(), new Class[0]).invoke(ip.instance, new Object[0]);
            }
            catch (NoSuchMethodException nme) {
                throw new ConfigurationException(ip.type + " " + ip.name + " has an invalid method @OnInit " + injection.method() + "()");
            }
            catch (Throwable t) {
                throw new ConfigurationException("Error executing @OnInit method " + injection.method() + " of " + ip.type + " " + ip.name, this.getRootException(t));
            }
        }
    }

    private Throwable getRootException(Throwable t) {
        if (t.getCause() != null) {
            return this.getRootException(t.getCause());
        }
        return t;
    }

    private int priority(Class<Plugin> p) {
        return p.getAnnotation(RegisterPlugin.class).priority();
    }

    private String name(Class<Plugin> p) {
        return p.getAnnotation(RegisterPlugin.class).name();
    }

    private String description(Class<Plugin> p) {
        return p.getAnnotation(RegisterPlugin.class).description();
    }

    private Boolean enabledByDefault(Class<Plugin> p) {
        return p.getAnnotation(RegisterPlugin.class).enabledByDefault();
    }

    private Boolean secure(Class<Plugin> p) {
        return p.getAnnotation(RegisterPlugin.class).secure();
    }

    private record InstatiatedPlugin(String name, String type, PluginDescriptor descriptor, Class<Plugin> clazz, Object instance) {
    }
}

