/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.plugins;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.restheart.Bootstrapper;
import org.restheart.configuration.Configuration;
import org.restheart.configuration.Utils;
import org.restheart.plugins.FieldInjectionDescriptor;
import org.restheart.plugins.PluginDescriptor;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsFactory;
import org.restheart.plugins.PluginsScanner;
import org.slf4j.Logger;

public class ProvidersChecker {
    private static List<PluginDescriptor> enabledProviders(Logger LOGGER, List<PluginDescriptor> providers) {
        return providers.stream().filter(p -> p != null).peek(p -> {
            if (!ProvidersChecker.enabled(p)) {
                LOGGER.info("Provider {} disabled", (Object)p.name());
            }
        }).filter(p -> ProvidersChecker.enabled(p)).collect(Collectors.toList());
    }

    private static boolean enabled(PluginDescriptor plugin) {
        Map pluginConf = (Map)Utils.getOrDefault((Configuration)Bootstrapper.getConfiguration(), (String)plugin.name(), null, (boolean)true);
        return PluginRecord.isEnabled((boolean)plugin.enabled(), (Map)pluginConf);
    }

    private static void removeIfWrongDependency(Logger LOGGER, MutableGraph<PluginDescriptor> providersGraph) {
        ArrayList toRemove = new ArrayList();
        providersGraph.nodes().forEach(thisProvider -> thisProvider.injections().stream().filter(i -> {
            boolean bl;
            if (i instanceof FieldInjectionDescriptor) {
                FieldInjectionDescriptor a = (FieldInjectionDescriptor)i;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).map(i -> (FieldInjectionDescriptor)i).forEach(i -> {
            String otherProviderName = (String)i.annotationParams().get(0).getValue();
            PluginDescriptor otherProvider = ProvidersChecker.providerDescriptorFromName(otherProviderName);
            if (otherProvider == null) {
                LOGGER.error("Provider {} disabled: no provider found for @Inject(\"{}\")", (Object)thisProvider.name(), (Object)otherProviderName);
                toRemove.add(thisProvider);
            } else if (!ProvidersChecker.enabled(otherProvider)) {
                LOGGER.error("Provider {} disabled: the provider for @Inject(\"{}\") is disabled", (Object)thisProvider.name(), (Object)otherProvider.name());
                toRemove.add(thisProvider);
            } else {
                Class<?> providedType = PluginsFactory.providersTypes().get(otherProviderName);
                Class<?> fieldType = i.clazz();
                if (!fieldType.isAssignableFrom(providedType)) {
                    LOGGER.error("Plugin {} disabled: the type of the provider for @Inject(\"{}\") is {} but the type of the annotated field {} is {}", new Object[]{thisProvider.name(), otherProviderName, providedType, i.field(), fieldType});
                    toRemove.add(thisProvider);
                }
            }
        }));
        toRemove.stream().forEach(arg_0 -> providersGraph.removeNode(arg_0));
    }

    private static void removeIfCircularDependency(Logger LOGGER, MutableGraph<PluginDescriptor> providersGraph) {
        ArrayList toRemove = new ArrayList();
        providersGraph.nodes().stream().forEach(provider -> {
            ImmutableSet reachableNodes = Graphs.reachableNodes((Graph)providersGraph, (Object)provider);
            MutableGraph subGraph = Graphs.inducedSubgraph((Graph)providersGraph, (Iterable)reachableNodes);
            if (Graphs.hasCycle((Graph)subGraph)) {
                LOGGER.error("Provider {} disabled due to circular dependency", (Object)provider.name());
                toRemove.add(provider);
            }
        });
        toRemove.stream().forEach(arg_0 -> providersGraph.removeNode(arg_0));
    }

    static Set<PluginDescriptor> validProviders(Logger LOGGER, List<PluginDescriptor> providers) {
        MutableGraph providersGraph = GraphBuilder.directed().allowsSelfLoops(true).build();
        ProvidersChecker.enabledProviders(LOGGER, providers).stream().forEach(arg_0 -> ((MutableGraph)providersGraph).addNode(arg_0));
        for (PluginDescriptor thisProvider : providers) {
            thisProvider.injections().stream().filter(i -> {
                boolean bl;
                if (i instanceof FieldInjectionDescriptor) {
                    FieldInjectionDescriptor a = (FieldInjectionDescriptor)i;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }).map(i -> (FieldInjectionDescriptor)i).forEach(i -> {
                String otherProviderName = (String)i.annotationParams().get(0).getValue();
                PluginDescriptor otherProvider = ProvidersChecker.providerDescriptorFromName(otherProviderName);
                if (otherProvider != null) {
                    providersGraph.putEdge((Object)thisProvider, (Object)otherProvider);
                }
            });
        }
        int count = providersGraph.edges().size();
        ProvidersChecker.removeIfWrongDependency(LOGGER, (MutableGraph<PluginDescriptor>)providersGraph);
        ProvidersChecker.removeIfCircularDependency(LOGGER, (MutableGraph<PluginDescriptor>)providersGraph);
        int newCount = providersGraph.edges().size();
        while (newCount < count) {
            count = providersGraph.edges().size();
            ProvidersChecker.removeIfWrongDependency(LOGGER, (MutableGraph<PluginDescriptor>)providersGraph);
            ProvidersChecker.removeIfCircularDependency(LOGGER, (MutableGraph<PluginDescriptor>)providersGraph);
            newCount = providersGraph.edges().size();
        }
        return providersGraph.nodes();
    }

    static PluginDescriptor providerDescriptorFromClass(String className) {
        return PluginsScanner.providers().stream().filter(p -> p.clazz().equals(className)).findFirst().orElse(null);
    }

    static PluginDescriptor providerDescriptorFromName(String name) {
        return PluginsScanner.providers().stream().filter(p -> p.name().equals(name)).findFirst().orElse(null);
    }

    static boolean checkDependencies(Logger LOGGER, Set<PluginDescriptor> validProviders, PluginDescriptor plugin) {
        if (!ProvidersChecker.enabled(plugin)) {
            return true;
        }
        boolean ret = true;
        ArrayList injections = new ArrayList();
        plugin.injections().stream().filter(i -> {
            boolean bl;
            if (i instanceof FieldInjectionDescriptor) {
                FieldInjectionDescriptor fid = (FieldInjectionDescriptor)i;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).map(i -> (FieldInjectionDescriptor)i).forEach(injections::add);
        for (FieldInjectionDescriptor injection : injections) {
            Object providerName = injection.annotationParams().get(0).getValue();
            Optional<PluginDescriptor> _provider = validProviders.stream().filter(p -> p.name().equals(providerName)).findFirst();
            if (_provider.isEmpty()) {
                LOGGER.error("Plugin {} disabled: no provider found for @Inject(\"{}\")", (Object)plugin.name(), providerName);
                ret = false;
                continue;
            }
            if (_provider.get().clazz().equals(plugin.clazz())) {
                LOGGER.error("Provider {} disabled: it depends on itself via @Inject(\"{}\")", (Object)plugin.name(), providerName);
                continue;
            }
            PluginDescriptor provider = _provider.get();
            if (ProvidersChecker.enabled(provider)) continue;
            LOGGER.error("Plugin {} disabled: the provider for @Inject(\"{}\") is disabled", (Object)plugin.name(), providerName);
            return false;
        }
        return ret;
    }
}

