/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authorizers;

import java.util.Map;
import org.restheart.exchange.Request;
import org.restheart.plugins.Inject;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.Authorizer;

@RegisterPlugin(name="fullAuthorizer", description="authorizes all requests", enabledByDefault=false)
public class FullAuthorizer
implements Authorizer {
    private boolean authenticationRequired;
    @Inject(value="config")
    private Map<String, Object> config;

    @OnInit
    public void init() {
        this.authenticationRequired = (Boolean)this.arg(this.config, "authentication-required");
    }

    public FullAuthorizer(boolean authenticationRequired) {
        this.authenticationRequired = authenticationRequired;
    }

    public FullAuthorizer() {
        this(false);
    }

    public boolean isAllowed(Request request) {
        return true;
    }

    public boolean isAuthenticationRequired(Request request) {
        return !request.isOptions() && this.authenticationRequired;
    }
}

