/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.handlers;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import org.restheart.plugins.security.AuthMechanism;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatorMechanismWrapper
implements AuthMechanism {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthMechanism.class);
    private final AuthMechanism wrapped;

    public AuthenticatorMechanismWrapper(AuthMechanism wrapped) {
        this.wrapped = wrapped;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        AuthenticationMechanism.AuthenticationMechanismOutcome outcome = this.wrapped.authenticate(exchange, securityContext);
        LOGGER.debug("{} -> {}", (Object)this.wrapped.getMechanismName(), (Object)outcome.name());
        switch (outcome) {
            case NOT_AUTHENTICATED: {
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
            }
        }
        return outcome;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return this.wrapped.sendChallenge(exchange, securityContext);
    }

    public String getMechanismName() {
        return this.wrapped.getMechanismName();
    }
}

