/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.handlers;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismContext;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.security.AuthMechanism;
import org.restheart.security.handlers.AuthenticatorMechanismWrapper;

public class AuthenticatorMechanismsHandler
extends PipelinedHandler {
    private final Set<AuthenticatorMechanismWrapper> wrappedAuthenticatorMechanisms;

    public AuthenticatorMechanismsHandler(PipelinedHandler next, Set<PluginRecord<AuthMechanism>> authenticatorMechanisms) {
        super(next);
        this.wrappedAuthenticatorMechanisms = authenticatorMechanisms.stream().map(mechanism -> new AuthenticatorMechanismWrapper((AuthMechanism)mechanism.getInstance())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public AuthenticatorMechanismsHandler(Set<PluginRecord<AuthMechanism>> authenticatorMechanisms) {
        this.wrappedAuthenticatorMechanisms = authenticatorMechanisms.stream().map(mechanism -> new AuthenticatorMechanismWrapper((AuthMechanism)mechanism.getInstance())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityContext sc = exchange.getSecurityContext();
        if (sc == null || !(sc instanceof AuthenticationMechanismContext)) {
            throw new IllegalStateException("The SecurityContext does not support authentication mechanisms!");
        }
        AuthenticationMechanismContext amc = (AuthenticationMechanismContext)sc;
        this.wrappedAuthenticatorMechanisms.stream().forEachOrdered(wrappedMechanism -> amc.addAuthenticationMechanism((AuthenticationMechanism)wrappedMechanism));
        this.next(exchange);
    }
}

