/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.handlers;

import io.undertow.security.api.AuthenticationMode;
import io.undertow.server.HttpServerExchange;
import java.util.Set;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.handlers.injectors.TokenInjector;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.security.AuthMechanism;
import org.restheart.plugins.security.Authorizer;
import org.restheart.plugins.security.TokenManager;
import org.restheart.security.handlers.AuthenticationCallHandler;
import org.restheart.security.handlers.AuthenticationConstraintHandler;
import org.restheart.security.handlers.AuthenticatorMechanismsHandler;
import org.restheart.security.handlers.AuthorizersHandler;
import org.restheart.security.handlers.SecurityInitialHandler;

public class SecurityHandler
extends PipelinedHandler {
    private final Set<PluginRecord<AuthMechanism>> mechanisms;
    private final Set<PluginRecord<Authorizer>> authorizers;
    private final PluginRecord<TokenManager> tokenManager;

    public SecurityHandler(Set<PluginRecord<AuthMechanism>> mechanisms, Set<PluginRecord<Authorizer>> authorizers, PluginRecord<TokenManager> tokenManager) {
        this.mechanisms = mechanisms;
        this.authorizers = authorizers;
        this.tokenManager = tokenManager;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        this.next(exchange);
    }

    protected void setNext(PipelinedHandler next) {
        super.setNext(SecurityHandler.buildSecurityHandlersChain(next, this.mechanisms, this.authorizers, this.tokenManager));
    }

    private static PipelinedHandler buildSecurityHandlersChain(PipelinedHandler next, Set<PluginRecord<AuthMechanism>> mechanisms, Set<PluginRecord<Authorizer>> authorizers, PluginRecord<TokenManager> tokenManager) {
        if (authorizers == null || authorizers.isEmpty()) {
            throw new IllegalArgumentException("Error, authorizers cannot be null or empty. Eventually use FullAuthorizer that gives full access power");
        }
        if (mechanisms != null && mechanisms.size() > 0) {
            return new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, new AuthenticatorMechanismsHandler(new AuthenticationConstraintHandler(new AuthenticationCallHandler(new TokenInjector(new AuthorizersHandler(authorizers, next), tokenManager != null ? (TokenManager)tokenManager.getInstance() : null)), authorizers), mechanisms));
        }
        if (authorizers != null && authorizers.size() > 0) {
            return new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, new AuthorizersHandler(authorizers, next));
        }
        return next;
    }
}

