/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.handlers;

import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.SecurityContextFactoryImpl;
import io.undertow.server.HttpServerExchange;
import org.restheart.handlers.PipelinedHandler;

public class SecurityInitialHandler
extends PipelinedHandler {
    private final AuthenticationMode authenticationMode;
    private final String programaticMechName;
    private final SecurityContextFactoryImpl contextFactory;

    public SecurityInitialHandler(AuthenticationMode authenticationMode, String programaticMechName, SecurityContextFactoryImpl contextFactory, PipelinedHandler next) {
        super(next);
        this.authenticationMode = authenticationMode;
        this.programaticMechName = programaticMechName;
        this.contextFactory = contextFactory;
    }

    public SecurityInitialHandler(AuthenticationMode authenticationMode, IdentityManager identityManager, String programaticMechName, PipelinedHandler next) {
        this(authenticationMode, programaticMechName, (SecurityContextFactoryImpl)SecurityContextFactoryImpl.INSTANCE, next);
    }

    public SecurityInitialHandler(AuthenticationMode authenticationMode, PipelinedHandler next) {
        this(authenticationMode, null, (SecurityContextFactoryImpl)SecurityContextFactoryImpl.INSTANCE, next);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.setSecurityContext(this.contextFactory.createSecurityContext(exchange, this.authenticationMode, null, this.programaticMechName));
        this.next(exchange);
    }
}

